/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.detail;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.detail.InetFlowDetailMaker;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.event.accounting.InetDetailCreateEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadLocalEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;

public class InetDetailWorker
extends EventWorker
implements Lifecycle {
    private final Setup setup;
    private final Accounting accounting;

    @ConstructorProperties(value={"setup", "accounting"})
    public InetDetailWorker(Setup setup, Accounting accounting) throws BGException {
        super(SetupParam.getModuleId((ParameterMap)setup));
        this.setup = setup;
        this.accounting = accounting;
        this.context = new EventListenerContext(setup, this.moduleId, SetupParam.getApplicationName());
        EventProcessor.getInstance().addListener((EventListener)new EventListener<Event>(){

            public void notify(Event e, EventListenerContext ctx) throws BGException {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            if (!InetUtils.checkAccountingRootDeviceId(InetDetailWorker.this.setup, InetDetailWorker.this.moduleId)) {
                                InetDetailWorker.this.setConsumer(InetDetailCreateEvent.class, InetDetailWorker.getQuery(InetDetailWorker.this.setup, InetDetailWorker.this.accounting));
                            }
                        }
                        catch (BGException e) {
                            InetDetailWorker.this.getLogger().error(e.getMessage(), (Throwable)e);
                        }
                    }
                }.start();
            }
        }, InetReloadLocalEvent.class, this.moduleId, null);
    }

    private static String getQuery(Setup setup, Accounting accounting) throws BGException {
        Set<Integer> childrenDeviceIds;
        if (accounting != null && accounting.childrenDeviceIds != null) {
            childrenDeviceIds = accounting.childrenDeviceIds;
        } else {
            int rootDeviceId = setup.getInt("rootDeviceId", 0);
            InetDeviceMap deviceMap = InetDeviceMap.getInstance(SetupParam.getModuleId((ParameterMap)setup));
            childrenDeviceIds = deviceMap.get(rootDeviceId).getDescendantIds();
            childrenDeviceIds = new HashSet<Integer>(childrenDeviceIds);
            childrenDeviceIds.add(rootDeviceId);
        }
        StringBuilder sb = new StringBuilder(20).append('(');
        for (Integer id : childrenDeviceIds) {
            sb.append("deviceId=").append(id).append(" OR ");
        }
        sb.setLength(sb.length() - 4);
        sb.append(')');
        return sb.toString();
    }

    public void start() throws Exception {
        if (InetUtils.checkAccountingRootDeviceId(this.setup, this.moduleId)) {
            this.setConsumer(InetDetailCreateEvent.class, "accountingRootDeviceId=" + this.accounting.rootDeviceId);
        } else {
            this.setConsumer(InetDetailCreateEvent.class, InetDetailWorker.getQuery(this.setup, this.accounting));
        }
        new Thread((Runnable)((Object)this), "detail-worker").start();
    }

    public void stop() throws Exception {
        this.shutdown();
    }

    protected boolean runWorker() throws BGException {
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        try {
            InetDetailCreateEvent e = (InetDetailCreateEvent)task;
            new InetFlowDetailMaker().createDetail((DefaultServerSetup)((EventListenerContext)this.context).getSetup(), ((EventListenerContext)this.context).getConnectionSet(), e);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return null;
    }
}

