/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.service;

import au.com.bytecode.opencsv.CSVWriter;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.mail.BodyPart;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import jakarta.xml.bind.annotation.XmlMimeType;
import jakarta.xml.ws.Holder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeKey;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAccountingPeriod;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficAccountDetail;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficMaxDetailReport;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeDetailReport;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeDetailValue;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeSpec;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.event.accounting.InetConnectionCommandEvent;
import ru.bitel.bgbilling.modules.inet.common.event.accounting.InetDetailCreateEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaStateModifyEvent;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.common.service.InetSessionService;
import ru.bitel.bgbilling.modules.inet.server.AuthUtils;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetAccountingPeriodDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionLogDao;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxDao;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxTariffTreeNode;
import ru.bitel.bgbilling.modules.inet.server.tariff.range.InetTrafficRangeDao;
import ru.bitel.bgbilling.modules.inet.server.tariff.range.TrafficRangeTariffTreeNode;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.localize.Localizer;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.common.xml.JAXBMarshaller;
import ru.bitel.common.xml.strategy.MarshallerStrategy;
import ru.bitel.common.xml.strategy.WebMarshallerStrategy;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceInterfaceIndexDao;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.inet.common.service.InetSessionService")
public class InetSessionServiceImpl
extends AbstractService
implements InetSessionService {
    @Resource
    private ModuleService moduleService;
    @Resource
    private InetServService servService;
    private InetSessionDao sessionDao = null;
    private InetSessionLogDao sessionLogDao = null;
    private InetServDao inetServDao = null;
    private static final int CSV_EXPORT_HEADER_COLUMN_COUNT = 12;
    Map<Integer, InetDevice> deviceMap = new HashMap<Integer, InetDevice>();
    Map<Integer, InetServ> serviceMap = new HashMap<Integer, InetServ>();

    private InetSessionDao getInetSessionDao() throws BGException {
        if (this.sessionDao == null) {
            this.sessionDao = new InetSessionDao(this.getConnection(), this.moduleId);
        }
        return this.sessionDao;
    }

    private InetSessionLogDao getInetSessionLogDao() throws BGException {
        if (this.sessionLogDao == null) {
            this.sessionLogDao = new InetSessionLogDao(this.getConnection(), this.moduleId);
        }
        return this.sessionLogDao;
    }

    private InetServDao getInetServDao() throws BGException {
        if (this.inetServDao == null) {
            this.inetServDao = new InetServDao(this.getConnection(), this.moduleId);
        }
        return this.inetServDao;
    }

    public Result<InetSessionLog> inetSessionAliveList(Set<Integer> deviceIds, Set<Integer> contractIds, String contract, String login, String ip, String callingStation, Date timeFrom, Date timeTo, Page page) throws BGException {
        List<InetSessionLog> result = this.getInetSessionDao().listAsLog(this.context.getDirectory(InetServType.class, this.moduleId).list(), deviceIds, null, contractIds, contract, null, login, ip, callingStation, timeFrom, timeTo, page, 0, 0, true);
        this.getInetSessionLogDao().loadTraffics(result, null);
        return new Result(result, page);
    }

    public Result<InetSessionLog> inetSessionLogList(Set<Integer> deviceIds, Set<Integer> contractIds, String contract, String login, String ip, String callingStation, Date timeFrom, Date timeTo, Page page) throws BGException, BGMessageException {
        try (InetSessionLogDao dao = new InetSessionLogDao(this.getConnection(), this.moduleId, timeFrom);){
            Result result = new Result(dao.list(deviceIds, contractIds, contract, Collections.emptySet(), login, ip, callingStation, timeFrom, timeTo, false, page), page);
            return result;
        }
    }

    public Result<InetSessionLog> inetSessionAliveContractList(int contractId, Set<Integer> servIds, Date timeFrom, Date timeTo, Set<Integer> trafficTypeIds, Set<Integer> serviceIds, Page page) throws BGException, BGMessageException {
        if (contractId <= 0) {
            throw new BGIllegalAccessException();
        }
        HashSet<Integer> contracts = new HashSet<Integer>();
        contracts.add(contractId);
        List<InetSessionLog> sessionLogList = this.getInetSessionDao().listAsLog(this.context.getDirectory(InetServType.class, this.moduleId).list(), null, null, contracts, servIds, timeFrom, timeTo, page, 0, 0, true);
        InetSessionLogDao sessionLogDao = this.getInetSessionLogDao();
        sessionLogDao.loadTraffics(sessionLogList, trafficTypeIds);
        sessionLogDao.loadAccount(sessionLogList, serviceIds);
        return this.resultWithTotal(sessionLogDao, contractId, servIds, timeFrom, timeTo, trafficTypeIds, sessionLogList, page);
    }

    public Result<InetSessionLog> inetSessionLogContractList(int contractId, Set<Integer> servIds, Date dateFrom, Date dateTo, Set<Integer> trafficTypeIds, Set<Integer> serviceIds, Page page) throws BGException, BGMessageException {
        if (dateFrom == null || contractId <= 0) {
            throw new BGIllegalArgumentException();
        }
        InetSessionLogDao sessionLogDao = new InetSessionLogDao(this.getConnection(), this.moduleId, dateFrom);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateFrom);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        dateFrom = calendar.getTime();
        calendar.setTime(dateTo);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        ((Calendar)calendar).add(5, 1);
        ((Calendar)calendar).add(13, -1);
        dateTo = calendar.getTime();
        List<InetSessionLog> sessionLogList = sessionLogDao.list(Collections.emptySet(), Collections.singleton(contractId), null, servIds, null, null, null, dateFrom, dateTo, true, page);
        sessionLogDao.loadTraffics(sessionLogList, trafficTypeIds);
        sessionLogDao.loadAccount(sessionLogList, serviceIds);
        return this.resultWithTotal(sessionLogDao, contractId, servIds, dateFrom, dateTo, trafficTypeIds, sessionLogList, page);
    }

    private Result<InetSessionLog> resultWithTotal(InetSessionLogDao sessionLogDao, int contractId, Set<Integer> servIds, Date dateFrom, Date dateTo, Set<Integer> trafficTypeIds, List<InetSessionLog> sessionLogList, Page page) throws BGException, BGMessageException {
        Result result = new Result(sessionLogList, page);
        Period period = new Period(dateFrom, dateTo);
        HashMap<Integer, Long> sumTraffics = new HashMap<Integer, Long>();
        sumTraffics.putAll(sessionLogDao.getSessionTrafficsReport(contractId, servIds, period, trafficTypeIds));
        result.setAttribute("totalTraffics", (Object)new JSONObject(sumTraffics).toString());
        sessionLogDao.getSumReportInfo(contractId, servIds, period, result);
        return result;
    }

    public void connectionClose(long connectionId) throws BGException {
        this.connectionClose(0, connectionId);
    }

    public void connectionClose(int contractId, long connectionId) throws BGException {
        InetServ inetServ;
        InetConnectionDao connectionDao = new InetConnectionDao(this.context.getConnection(), this.moduleId);
        InetConnection connection = connectionDao.get(connectionId);
        if (connection == null) {
            throw new BGMessageException("\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e (\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0436\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e)");
        }
        if (contractId > 0 && (inetServ = (InetServ)this.getInetServDao().get(connection.getServId())) != null && inetServ.getContractId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
        EventProcessor.getInstance().publish((Event)new InetSaStateModifyEvent(this.moduleId, connection.getContractId(), this.userId, connection.getDeviceId(), connection.getServId(), connection.getId(), InetServState.STATE_DISABLE.getCode(), AccessCode.TOO_MANY_SESSIONS_ERROR.getCode(), false));
    }

    public void connectionFinish(long connectionId) throws BGException {
        this.connectionFinish(0, connectionId);
    }

    public void connectionFinish(int contractId, long connectionId) throws BGException {
        InetServ inetServ;
        InetConnectionDao connectionDao = new InetConnectionDao(this.context.getConnection(), this.moduleId);
        InetConnection connection = connectionDao.get(connectionId);
        if (connection == null) {
            throw new BGMessageException("\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e (\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0436\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e)");
        }
        if (contractId > 0 && (inetServ = (InetServ)this.getInetServDao().get(connection.getServId())) != null && inetServ.getContractId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
        int accountingRootDeviceId = InetUtils.getAccountingRootDeviceId(this.context.getSetup(), this.moduleId, connection.getDeviceId());
        InetConnectionCommandEvent e = (InetConnectionCommandEvent)EventProcessor.getInstance().request((Event)new InetConnectionCommandEvent(this.moduleId, this.userId, accountingRootDeviceId, connection.getDeviceId(), connection.getServId(), connection.getId(), "finish"), 6000L);
        if (e == null) {
            throw new BGMessageException("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e Accounting \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d");
        }
    }

    public void inetSessionExportSendToEmail(int contractId, Set<Integer> servIds, Period period, Set<Integer> trafficTypeIds, Set<Integer> serviceIds, boolean alive, String format, String orderBy, long unit, List<String> emails) throws BGException {
        Holder data;
        ArrayList<Holder> listData = new ArrayList<Holder>();
        if (format == null || format.equals("html")) {
            data = new Holder();
            this.inetSessionExport(contractId, servIds, period.getDateFrom(), period.getDateTo(), trafficTypeIds, serviceIds, null, (Holder<DataHandler>)data, alive, "html", null, unit);
            listData.add(data);
        }
        if (format == null || format.equals("csv")) {
            data = new Holder();
            this.inetSessionExport(contractId, servIds, period.getDateFrom(), period.getDateTo(), trafficTypeIds, serviceIds, null, (Holder<DataHandler>)data, alive, "csv", null, unit);
            listData.add(data);
        }
        try {
            MimeMultipart multipart = new MimeMultipart();
            for (Holder data2 : listData) {
                MimeBodyPart attach = new MimeBodyPart();
                attach.setFileName(MimeUtility.encodeText((String)((DataHandler)data2.value).getName(), (String)"utf-8", (String)"B"));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ((DataHandler)data2.value).writeTo((OutputStream)baos);
                attach.setContent((Object)baos.toByteArray(), "application/html");
                multipart.addBodyPart((BodyPart)attach);
            }
            MailMsg msg = new MailMsg((Preferences)Setup.getSetup());
            for (String email : emails) {
                msg.sendMessage(email, "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0441\u0435\u0441\u0441\u0438\u044f\u043c ( " + period.toString() + " )", (Multipart)multipart);
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    @Deprecated
    public void inetSessionExport(int contractId, Set<Integer> servIds, Date dateFrom, Date dateTo, Set<Integer> trafficTypeIds, Set<Integer> serviceIds, Page page, @XmlMimeType(value="application/octet-stream") Holder<DataHandler> data, boolean alive, String format) throws BGException {
        this.inetSessionExport(contractId, servIds, dateFrom, dateTo, trafficTypeIds, serviceIds, page, data, alive, format, null, 1L);
    }

    public void inetSessionExport(int contractId, Set<Integer> servIds, Date dateFrom, Date dateTo, Set<Integer> trafficTypeIds, Set<Integer> serviceIds, Page page, @XmlMimeType(value="application/octet-stream") Holder<DataHandler> data, boolean alive, String format, String orderBy, long unit) throws BGException {
        InputStream exportDataStream;
        String contentType;
        Result<InetSessionLog> result = alive ? this.inetSessionAliveContractList(contractId, servIds, dateFrom, dateTo, trafficTypeIds, serviceIds, page) : this.inetSessionLogContractList(contractId, servIds, dateFrom, dateTo, trafficTypeIds, serviceIds, page);
        for (InetSessionLog sessionLog : result.getList()) {
            BigDecimal sessionCost = sessionLog.getSessionCost();
            List children = sessionLog.getChildren();
            if (children == null || children.size() <= 0) continue;
            for (InetSessionLog child : children) {
                sessionCost = sessionCost.add(child.getSessionCost());
            }
            Iterator<Object> iterator = trafficTypeIds.iterator();
            while (iterator.hasNext()) {
                int typeId = (Integer)iterator.next();
                if (typeId == 0) continue;
                long amountSum = 0L;
                if (sessionLog.getTrafficMap().get(typeId) != null) {
                    amountSum = (Long)sessionLog.getTrafficMap().get(typeId);
                }
                for (InetSessionLog child : children) {
                    Long amount = (Long)child.getTrafficMap().get(typeId);
                    if (amount == null) continue;
                    amountSum += amount.longValue();
                }
                if (amountSum <= 0L) continue;
                sessionLog.getTrafficMap().put(typeId, amountSum);
            }
            sessionLog.setSessionCost(sessionCost);
        }
        if (trafficTypeIds == null) {
            trafficTypeIds = new HashSet<Integer>();
            for (TrafficType type : this.servService.trafficTypeList()) {
                trafficTypeIds.add(type.getId());
            }
        }
        String nameExtension = "";
        if (format.equals("html")) {
            nameExtension = ".html";
            contentType = "text/html";
            exportDataStream = this.htmlExport(contractId, dateFrom, dateTo, result, trafficTypeIds, orderBy, unit);
        } else if (format.equals("csv")) {
            nameExtension = ".csv";
            contentType = "text/csv";
            exportDataStream = this.csvExport(contractId, result, trafficTypeIds, unit);
        } else {
            contentType = "text/plain";
            exportDataStream = null;
        }
        final String name = "sessions" + nameExtension;
        data.value = new DataHandler(new DataSource(){

            public String getContentType() {
                return contentType;
            }

            public InputStream getInputStream() throws IOException {
                return exportDataStream;
            }

            public String getName() {
                return name;
            }

            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        });
    }

    private InputStream htmlExport(int contractId, Date dateFrom, Date dateTo, Result<InetSessionLog> sessionLogContractList, Set<Integer> trafficTypeIds, String orderBy, long unit) throws BGException {
        ByteArrayInputStream htmlStream;
        JAXBMarshaller marshaller = new JAXBMarshaller((MarshallerStrategy)new WebMarshallerStrategy(), new HashSet<Class>(Arrays.asList(Result.class)));
        Document doc = XMLUtils.newDocument();
        Element root = XMLUtils.createElement((Document)doc, (String)"data");
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            Contract contract = (Contract)contractDao.get(contractId);
            root.setAttribute("contractTitle", contract.getTitle());
            root.setAttribute("comment", contract.getComment());
            root.setAttribute("dateFrom", TimeUtils.formatDate((Date)dateFrom));
            root.setAttribute("dateTo", TimeUtils.formatDate((Date)dateTo));
            root.setAttribute("unit", String.valueOf(unit));
            ArrayList<TrafficType> selectedTrafficTypes = new ArrayList<TrafficType>();
            for (TrafficType type : this.servService.trafficTypeList()) {
                if (!trafficTypeIds.contains(type.getId()) || type.getId() == 0) continue;
                selectedTrafficTypes.add(type);
            }
            marshaller.marshal((Object)this.servService.inetServList(contractId, orderBy), "servs", (javax.xml.transform.Result)new DOMResult(root));
            marshaller.marshal(selectedTrafficTypes, "trafficTypes", (javax.xml.transform.Result)new DOMResult(root));
            marshaller.marshal((Object)this.moduleService.serviceList(this.moduleId), "services", (javax.xml.transform.Result)new DOMResult(root));
            marshaller.marshal(sessionLogContractList, null, (javax.xml.transform.Result)new DOMResult(root));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XSLManager.getInstance().transform((Source)new DOMSource(doc), "inet_sessions.xsl", (OutputStream)baos);
            htmlStream = new ByteArrayInputStream(baos.toByteArray());
            baos.close();
            baos = null;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return htmlStream;
    }

    private InputStream csvExport(int contractId, Result<InetSessionLog> sessionLogContractList, Set<Integer> trafficTypeIds, long unit) throws BGException {
        PipedInputStream csvStream = new PipedInputStream(51200);
        try {
            PipedOutputStream output = new PipedOutputStream(csvStream);
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            char decimalSeparator = this.getModuleSetup().getChar("format.decimal.separator", Localizer.getDecimalFormatSymbols().getDecimalSeparator());
            dfs.setDecimalSeparator(decimalSeparator);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
            CSVWriter csv = new CSVWriter((Writer)writer, this.getModuleSetup().get("csv.separator", ";").charAt(0));
            int index = 0;
            String[] csvHeaderArray = new String[12 + trafficTypeIds.size() - 1];
            csvHeaderArray[index++] = "\u041a\u043e\u0434 \u0441\u0435\u0441\u0441\u0438\u0438";
            csvHeaderArray[index++] = "\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e";
            csvHeaderArray[index++] = "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440";
            csvHeaderArray[index++] = "\u0421\u0435\u0440\u0432\u0438\u0441";
            csvHeaderArray[index++] = "\u0421 \u043d\u043e\u043c\u0435\u0440\u0430/\u043d\u0430 \u043d\u043e\u043c\u0435\u0440";
            csvHeaderArray[index++] = "IP";
            csvHeaderArray[index++] = "\u041d\u0430\u0447\u0430\u043b\u043e";
            csvHeaderArray[index++] = "\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435";
            csvHeaderArray[index++] = "\u0410\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u044c";
            String extTraffic = ", \u0431\u0430\u0439\u0442";
            if (unit == 1024L) {
                extTraffic = ", \u041a\u0431";
            } else if (unit == 0x100000L) {
                extTraffic = ", \u041c\u0431";
            } else if (unit == 0x40000000L) {
                extTraffic = ", \u0413\u0431";
            }
            for (Integer trafficTypeId : trafficTypeIds) {
                TrafficType type;
                if (trafficTypeId == 0 || (type = this.servService.trafficTypeGet(trafficTypeId.intValue())) == null) continue;
                csvHeaderArray[index++] = type.getTitle() + extTraffic;
            }
            csvHeaderArray[index++] = "\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c";
            csvHeaderArray[index++] = "\u0421\u0442\u0430\u0442\u0443\u0441";
            csvHeaderArray[index++] = "\u0412\u0440\u0435\u043c\u044f";
            csv.writeNext(csvHeaderArray);
            for (InetSessionLog session : sessionLogContractList.getList()) {
                InetDevice device = this.getDeviceById(session.getDeviceId());
                InetServ serv = this.getServById(session.getServId());
                index = 0;
                String[] csvStringArray = new String[12 + trafficTypeIds.size() - 1];
                csvStringArray[index++] = String.valueOf(session.getId());
                csvStringArray[index++] = device.getTitle();
                csvStringArray[index++] = session.getAcctSessionId();
                csvStringArray[index++] = serv.getTitle();
                csvStringArray[index++] = session.getFromNumberToNumberAsString();
                csvStringArray[index++] = session.getInetAddress();
                csvStringArray[index++] = session.getSessionStartAsString();
                csvStringArray[index++] = session.getSessionStopAsString();
                csvStringArray[index++] = session.getSessionActivityAsString();
                Map trafficTypeMap = session.getTrafficMap();
                for (Integer trafficTypeId : trafficTypeIds) {
                    if (trafficTypeId == 0) continue;
                    Long traffic = (Long)trafficTypeMap.get(trafficTypeId);
                    csvStringArray[index++] = String.valueOf(traffic != null ? traffic.doubleValue() / (double)unit : 0.0);
                }
                csvStringArray[index++] = session.getSessionCost().toString();
                csvStringArray[index++] = session.getStatusName();
                csvStringArray[index++] = session.getDurationAsString();
                csv.writeNext(csvStringArray, false);
            }
            csv.flush();
            csv.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return csvStream;
    }

    public void inetSessionLogContractListExport(int contractId, Set<Integer> servIds, Date dateFrom, Date dateTo, Set<Integer> trafficTypeIds, Set<Integer> serviceIds, @XmlMimeType(value="application/octet-stream") Holder<DataHandler> data) throws BGException {
        JAXBMarshaller marshaller = new JAXBMarshaller((MarshallerStrategy)new WebMarshallerStrategy(), new HashSet<Class>(Arrays.asList(Result.class)));
        Document doc = XMLUtils.newDocument();
        Element root = XMLUtils.createElement((Document)doc, (String)"data");
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            Contract contract = (Contract)contractDao.get(contractId);
            root.setAttribute("contractTitle", contract.getTitle());
            root.setAttribute("comment", contract.getComment());
            root.setAttribute("dateFrom", TimeUtils.formatDate((Date)dateFrom));
            root.setAttribute("dateTo", TimeUtils.formatDate((Date)dateTo));
            ArrayList<TrafficType> selectedTrafficTypes = new ArrayList<TrafficType>();
            for (TrafficType type : this.servService.trafficTypeList()) {
                if (!trafficTypeIds.contains(type.getId()) || type.getId() == 0) continue;
                selectedTrafficTypes.add(type);
            }
            marshaller.marshal((Object)this.servService.inetServList(contractId, null), "servs", (javax.xml.transform.Result)new DOMResult(root));
            marshaller.marshal(selectedTrafficTypes, "trafficTypes", (javax.xml.transform.Result)new DOMResult(root));
            marshaller.marshal((Object)this.moduleService.serviceList(this.moduleId), "services", (javax.xml.transform.Result)new DOMResult(root));
            Result<InetSessionLog> result = this.inetSessionLogContractList(contractId, servIds, dateFrom, dateTo, trafficTypeIds, serviceIds, null);
            marshaller.marshal(result, null, (javax.xml.transform.Result)new DOMResult(root));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XSLManager.getInstance().transform((Source)new DOMSource(doc), "inet_sessions.xsl", (OutputStream)baos);
            final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            baos.close();
            baos = null;
            data.value = new DataHandler(new DataSource(){

                public String getContentType() {
                    return "text/html";
                }

                public InputStream getInputStream() throws IOException {
                    return bais;
                }

                public String getName() {
                    return "sessions.html";
                }

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    private InetDevice getDeviceById(int deviceId) {
        InetDevice device;
        block7: {
            device = this.deviceMap.get(deviceId);
            try {
                if (device != null || this.deviceMap.containsKey(deviceId)) break block7;
                try (InetDeviceDao inetDeviceDao = new InetDeviceDao(this.getConnection(), this.moduleId);){
                    device = inetDeviceDao.get(deviceId);
                    this.deviceMap.put(deviceId, device);
                }
            }
            catch (BGException e) {
                e.printStackTrace();
            }
        }
        return device;
    }

    private InetServ getServById(int servId) {
        InetServ serv = this.serviceMap.get(servId);
        try {
            if (serv == null && !this.deviceMap.containsKey(servId)) {
                serv = (InetServ)this.getInetServDao().get(servId);
                this.serviceMap.put(servId, serv);
            }
        }
        catch (BGException e) {
            e.printStackTrace();
        }
        return serv;
    }

    public void inetSessionDetail(long id, Date sessionStart, String email) throws BGException, BGMessageException {
        InetSessionLogDao dao = new InetSessionLogDao(this.getConnection(), this.moduleId, sessionStart);
        InetSessionLog sessionLog = dao.get(id);
        dao.close();
        if (sessionLog == null && (sessionLog = this.getInetSessionDao().getAsLog(this.context.getDirectory(InetServType.class, this.moduleId).list(), id)) == null) {
            throw new BGMessageException("\u0421\u0435\u0441\u0441\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
        }
        InetServ inetServ = (InetServ)this.getInetServDao().get(sessionLog.getServId());
        List<InetDetailCreateEvent.SessionInfo> sessionInfoList = this.sessionInfoList(inetServ, Collections.singletonList(sessionLog));
        Date timeFrom = sessionLog.getSessionStart();
        Date timeTo = sessionLog.getSessionStop();
        if (timeTo == null) {
            timeTo = new Date();
        }
        int accountingRootDeviceId = InetUtils.getAccountingRootDeviceId(this.context.getSetup(), this.moduleId, inetServ.getDeviceId());
        EventProcessor.getInstance().publish((Event)new InetDetailCreateEvent(this.moduleId, accountingRootDeviceId, inetServ.getDeviceId(), inetServ.getId(), inetServ.getTitle(), timeFrom, timeTo, sessionInfoList, email));
    }

    private List<InetDetailCreateEvent.SessionInfo> sessionInfoList(InetServ inetServ, List<InetSessionLog> sessionLogList) throws BGException {
        ArrayList<InetDetailCreateEvent.SessionInfo> sessionInfoList = new ArrayList<InetDetailCreateEvent.SessionInfo>();
        InetDeviceMap inetDeviceMap = InetDeviceMap.getInstance(this.moduleId);
        HashMap deviceifaceIndexMap = new HashMap();
        DeviceInterfaceIndexDao interfaceIndexDao = new DeviceInterfaceIndexDao(this.getConnection(), this.moduleId);
        long[] intersection = new long[2];
        for (InetSessionLog sessionLog : sessionLogList) {
            byte[] addressFrom;
            byte[] addressTo = addressFrom = sessionLog.getInetAddressBytes();
            byte[] prefix = sessionLog.getPrefix();
            if (!(addressFrom != null && addressFrom.length != 0 || prefix != null && prefix.length != 0)) {
                addressFrom = inetServ.getAddressFrom();
                addressTo = inetServ.getAddressTo();
            }
            if (!(addressFrom != null && addressFrom.length != 0 || prefix != null && prefix.length != 0)) {
                InetServType servType = this.servService.inetServTypeGet(inetServ.getTypeId());
                if (servType.isAddressAllInterface()) {
                    addressFrom = null;
                    addressTo = null;
                } else {
                    this.getLogger().warn("Address range not found for detail (inetServ:" + inetServ.getId() + ", session:" + sessionLog.getId() + "). Skipping");
                    continue;
                }
            }
            InetDeviceMap.InetDeviceMapItem device = inetDeviceMap.get(sessionLog.getDeviceId());
            for (Map.Entry<Integer, List<Integer>> e : device.getFlowAgentIfaceMap().entrySet()) {
                Integer agentDeviceId = e.getKey();
                HashSet<Object> protoIfaces = new HashSet(e.getValue());
                if (!(agentDeviceId.intValue() != inetServ.getDeviceId() || inetServ.getInterfaceId() < 0 || protoIfaces.size() == 1 && protoIfaces.contains(-1))) {
                    protoIfaces = new HashSet<Integer>(Collections.singleton(inetServ.getInterfaceId()));
                }
                Date timeFrom = sessionLog.getSessionStart();
                Date timeTo = sessionLog.getSessionStop();
                if (timeTo == null) {
                    timeTo = new Date();
                }
                HashSet<Integer> ifaces = new HashSet<Integer>();
                InetDeviceMap.InetDeviceMapItem agentDeviceMapItem = inetDeviceMap.get(agentDeviceId);
                int invDeviceId = agentDeviceMapItem != null ? agentDeviceMapItem.getDevice().getInvDeviceId() : agentDeviceId.intValue();
                Map ifaceIndexMap = DeviceInterfaceIndexDao.getIfaceIndexMap((DeviceInterfaceIndexDao)interfaceIndexDao, deviceifaceIndexMap, (int)invDeviceId);
                block2: for (Integer n : protoIfaces) {
                    List ifaceIndexList = (List)ifaceIndexMap.get(n);
                    if (ifaceIndexList == null || ifaceIndexList.size() == 0) {
                        ifaces.add(n);
                        continue;
                    }
                    for (DeviceInterfaceIndexDao.DeviceInterfaceIndexItem index : ifaceIndexList) {
                        if (RangeUtils.intersectionAnd((long[])intersection, (long)index.millisFrom, (long)index.millisTo, (long)timeFrom.getTime(), (long)timeFrom.getTime()) == null) continue;
                        ifaces.add(index.index);
                        continue block2;
                    }
                    ifaces.add(n);
                }
                sessionInfoList.add(new InetDetailCreateEvent.SessionInfo(timeFrom, timeTo, agentDeviceId.intValue(), ifaces, new IpAddress(addressFrom), new IpAddress(addressTo), new IpAddress(prefix), sessionLog.getPrefixLength(), null));
            }
        }
        return sessionInfoList;
    }

    public void inetSessionPeriodDetail(int inetServId, Date dateFrom, Date dateTo, String email) throws BGException, BGMessageException {
        GregorianCalendar calendarFrom = new GregorianCalendar();
        calendarFrom.setTime(dateFrom);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendarFrom);
        Date timeFrom = TimeUtils.convertCalendarToDate((Calendar)calendarFrom);
        GregorianCalendar calendarTo = new GregorianCalendar();
        calendarTo.setTime(dateTo);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendarTo);
        ((Calendar)calendarTo).add(5, 1);
        ((Calendar)calendarTo).add(13, -1);
        Date timeTo = TimeUtils.convertCalendarToDate((Calendar)calendarTo);
        if (timeFrom.after(timeTo)) {
            throw new BGMessageException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434");
        }
        if (TimeUtils.compare((Calendar)calendarFrom, (Calendar)calendarTo, (int)2) != 0) {
            throw new BGMessageException("\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0432\u0445\u043e\u0434\u0438\u0442\u044c \u0432 \u043e\u0434\u0438\u043d \u043c\u0435\u0441\u044f\u0446");
        }
        InetServ inetServ = (InetServ)this.getInetServDao().get(inetServId);
        if (inetServ != null) {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("inetSessionPeriodDetail( inetServId = {}, dateFrom = {}, dateTo = {}, email = {} )", (Object)inetServId, (Object)dateFrom, (Object)dateTo, (Object)email);
            }
            try (InetSessionLogDao dao = new InetSessionLogDao(this.getConnection(), this.moduleId, timeFrom);){
                List<InetSessionLog> sessionLogList = dao.list(null, Collections.singleton(inetServ.getContractId()), null, Collections.singleton(inetServId), null, null, null, timeFrom, timeTo, true, null);
                List<InetSessionLog> sessionLogList2 = this.getInetSessionDao().listAsLog(this.context.getDirectory(InetServType.class, this.moduleId).list(), null, null, Collections.singleton(inetServ.getContractId()), Collections.singleton(inetServId), timeFrom, timeTo, null, 0, 0, true);
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("sessionLogList.size() = {}", (Object)sessionLogList.size());
                    this.getLogger().trace("sessionLogList2.size() = {}", (Object)sessionLogList2.size());
                }
                sessionLogList.addAll(sessionLogList2);
                List<InetDetailCreateEvent.SessionInfo> sessionInfoList = this.sessionInfoList(inetServ, sessionLogList);
                int accountingRootDeviceId = InetUtils.getAccountingRootDeviceId(this.context.getSetup(), this.moduleId, inetServ.getDeviceId());
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("moduleId = {}", (Object)this.moduleId);
                    this.getLogger().trace("accountingRootDeviceId = {}", (Object)accountingRootDeviceId);
                    this.getLogger().trace("deviceId = {}", (Object)inetServ.getDeviceId());
                    this.getLogger().trace("inetServId = {}", (Object)inetServ.getId());
                    this.getLogger().trace("inetServTitle = {}", (Object)inetServ.getTitle());
                    this.getLogger().trace("timeFrom = {}", (Object)timeFrom);
                    this.getLogger().trace("timeTo = {}", (Object)timeTo);
                    this.getLogger().trace("sessionInfoList.size() = {}", (Object)sessionInfoList.size());
                }
                EventProcessor.getInstance().publish((Event)new InetDetailCreateEvent(this.moduleId, accountingRootDeviceId, inetServ.getDeviceId(), inetServ.getId(), inetServ.getTitle(), timeFrom, timeTo, sessionInfoList, email));
            }
        }
    }

    public List<TrafficAmount> inetSessionTraffic(int contractId, Set<Integer> inetServIds, int sessionId, Set<Integer> trafficTypeIds, Period period, long unit, boolean byDay, boolean continuous) throws BGException, BGMessageException {
        try (InetSessionLogDao sessionLogDao = new InetSessionLogDao(this.getConnection(), this.moduleId, period.getDateFrom());){
            List<TrafficAmount> list = sessionLogDao.traffic(contractId, inetServIds, sessionId, trafficTypeIds, period, byDay, true, continuous);
            return list;
        }
    }

    public List<TrafficMaxDetailReport> inetSessionTrafficMax(int contractId, Set<Integer> inetServIds, Date dateFrom, Date dateTo, long unit) throws BGException {
        ArrayList<TrafficMaxDetailReport> result = new ArrayList<TrafficMaxDetailReport>();
        GregorianCalendar timeFrom = new GregorianCalendar();
        timeFrom.setTime(dateFrom);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)timeFrom);
        GregorianCalendar timeTo = new GregorianCalendar();
        timeTo.setTime(dateTo);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)timeTo);
        ((Calendar)timeTo).add(5, 1);
        ((Calendar)timeTo).add(14, -1);
        TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(this.getConnection());
        TariffModuleTreeSet treeSet = treeSetDao.getRealtimeTariffTreeSet(contractId, timeFrom.getTime(), "inet", this.moduleId, 0, 0);
        treeSetDao.close();
        TrafficMaxDao trafficMaxDao = new TrafficMaxDao(this.getConnection(), this.moduleId);
        ArrayList trafficMaxTreeNodeList = new ArrayList();
        for (TariffModuleTreeSet.Entry entry : treeSet.entries()) {
            entry.getTree().getNodeList(trafficMaxTreeNodeList, new Class[]{TrafficMaxTariffTreeNode.class});
        }
        ModuleSetup moduleSetup = this.getModuleSetup();
        block4: for (TariffTreeNodeHolder holder : trafficMaxTreeNodeList) {
            String title;
            TrafficMaxTariffTreeNode node = (TrafficMaxTariffTreeNode)holder.node;
            if (node.getLabelId() <= 0 || Utils.isBlankString((String)(title = moduleSetup.get("tariffication.tariff.label." + node.getLabelId() + ".title", null)))) continue;
            int mode = node.getMode();
            switch (mode) {
                case 5: {
                    continue block4;
                }
            }
            TrafficMaxDetailReport report = new TrafficMaxDetailReport().setTreeNodeId(holder.treeNodeId.longValue()).setMode(node.getMode()).setTitle(title).setTrafficTypeId1(node.getTrafficType1()).setTrafficTypeId2(node.getTrafficType2()).setTrafficMaxDetailList(trafficMaxDao.listDetail(contractId, holder.treeNodeId, dateFrom, dateTo));
            result.add(report);
        }
        return result;
    }

    public List<TrafficRangeDetailReport> inetSessionTrafficRange(int contractId, int tariffOptionId, Date dateFrom, Date dateTo, long unit) throws BGException {
        ArrayList<TrafficRangeDetailReport> result = new ArrayList<TrafficRangeDetailReport>();
        GregorianCalendar timeFrom = new GregorianCalendar();
        timeFrom.setTime(dateFrom);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)timeFrom);
        GregorianCalendar timeTo = new GregorianCalendar();
        timeTo.setTime(dateTo);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)timeTo);
        ((Calendar)timeTo).add(5, 1);
        ((Calendar)timeTo).add(14, -1);
        TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(this.getConnection());
        TariffModuleTreeSet treeSet = treeSetDao.getRealtimeTariffTreeSet(contractId, timeFrom.getTime(), "inet", this.moduleId, 0, 0);
        treeSetDao.close();
        Directory trafficRangeSpecDir = this.context.getDirectory(TrafficRangeSpec.class, this.moduleId);
        ArrayList trafficMaxTreeNodeList = new ArrayList();
        for (TariffModuleTreeSet.Entry entry : treeSet.entries()) {
            entry.getTree().getNodeList(trafficMaxTreeNodeList, new Class[]{TrafficRangeTariffTreeNode.class});
        }
        HashSet<Integer> specIds = new HashSet<Integer>();
        ModuleSetup moduleSetup = this.getModuleSetup();
        try (InetTrafficRangeDao trafficRangeDao = new InetTrafficRangeDao(this.getConnection(), this.moduleId);){
            block13: for (TariffTreeNodeHolder holder : trafficMaxTreeNodeList) {
                String title;
                long treeNodeId;
                TrafficRangeTariffTreeNode node = (TrafficRangeTariffTreeNode)holder.node;
                if (node.getLabelId() <= 0 && node.getTrafficRangeSpecId() <= 0 || tariffOptionId > 0 && tariffOptionId != node.getTariffOptionId()) continue;
                if (node.getTrafficRangeSpecId() > 0) {
                    if (!specIds.add(node.getTrafficRangeSpecId())) continue;
                    TrafficRangeSpec trafficRangeSpec = (TrafficRangeSpec)trafficRangeSpecDir.get(node.getTrafficRangeSpecId());
                    treeNodeId = trafficRangeSpec.getId();
                    title = trafficRangeSpec.getTitleForCustomer();
                } else {
                    treeNodeId = holder.treeNodeId;
                    title = moduleSetup.get("tariffication.tariff.label." + node.getLabelId() + ".title", null);
                }
                if (Utils.isBlankString((String)title)) continue;
                int mode = node.getPeriodMode();
                switch (mode) {
                    case 4: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        continue block13;
                    }
                }
                TrafficRangeDetailReport report = new TrafficRangeDetailReport().setTreeNodeId(treeNodeId).setMode(node.getPeriodMode()).setType(node.getProportionType()).setTariffOptionId(node.getTariffOptionId().intValue()).setTitle(title).setMaxAmount(node.getMaxAmount());
                trafficRangeDao.report(contractId, treeNodeId, dateFrom, dateTo, report);
                result.add(report);
            }
        }
        for (TrafficRangeDetailReport report : result) {
            switch (report.getMode()) {
                case 1: {
                    InetAccountingPeriodDao accountingPeriodDao = new InetAccountingPeriodDao(this.getConnection(), this.moduleId, this.userId);
                    GregorianCalendar utilCalendar = new GregorianCalendar();
                    for (TrafficRangeDetailValue value : report.getDetailValueList()) {
                        int accountingPeriodId = (int)TrafficRangeKey.getId((long)value.getRangeKey());
                        InetAccountingPeriod accountingPeriod = (InetAccountingPeriod)accountingPeriodDao.get(accountingPeriodId);
                        value.setAccountingPeriod(accountingPeriod);
                        utilCalendar.setTime(accountingPeriod.getDateTo());
                        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
                        ((Calendar)utilCalendar).add(5, 1);
                        ((Calendar)utilCalendar).add(14, -1);
                        accountingPeriod.setDateTo(utilCalendar.getTime());
                    }
                    accountingPeriodDao.close();
                    break;
                }
                case 5: {
                    ContractTariffOptionDao tariffOptionDao = new ContractTariffOptionDao(this.getConnection());
                    for (TrafficRangeDetailValue value : report.getDetailValueList()) {
                        int contractTariffOptionId = (int)TrafficRangeKey.getId((long)value.getRangeKey());
                        ContractTariffOption tariffOption = (ContractTariffOption)tariffOptionDao.get(contractTariffOptionId);
                        value.setContractTariffOption(tariffOption);
                    }
                    tariffOptionDao.close();
                    break;
                }
            }
        }
        return result;
    }

    public List<TrafficAmount> inetContractTraffic(int contractId, Set<Integer> servIds, Period period, Set<Integer> requestTrafsIds, int unit, boolean byDay) throws BGException {
        if (period.getDateFrom() == null || contractId <= 0) {
            throw new BGIllegalArgumentException();
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(period.getDateFrom());
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        period.setDateFrom(calendar.getTime());
        calendar.setTime(period.getDateTo());
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        ((Calendar)calendar).add(5, 1);
        ((Calendar)calendar).add(13, -1);
        period.setDateTo(calendar.getTime());
        List<TrafficAmount> result = this.inetSessionTraffic(contractId, servIds, 0, requestTrafsIds, period, unit, byDay, false);
        return result;
    }

    public TrafficAccountDetail inetSessionAccountSums(int contractId, Collection<Integer> inetServIds, Period period, Collection<Integer> serviceIds, boolean isActive) throws BGException, BGMessageException {
        try (InetSessionLogDao sessionLogDao = isActive ? new InetSessionLogDao(this.getConnection(), this.moduleId) : new InetSessionLogDao(this.getConnection(), this.moduleId, period.getDateFrom());){
            TrafficAccountDetail trafficAccountDetail = sessionLogDao.getSessionAccountSums(contractId, inetServIds, period, serviceIds);
            return trafficAccountDetail;
        }
    }

    public Pair<InetServ, InetConnection> connectionFind(Set<Integer> servIds, String acctSessionId, String address, String login, String callingStationId) throws BGException {
        try {
            return InetConnectionDao.find(this.getConnection(), this.moduleId, servIds, acctSessionId, address, login, callingStationId);
        }
        catch (UnknownHostException e) {
            throw new BGException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void connectionRebind(long connectionId, int newContractId, int newServId, short newState, Set<Integer> newOptionIds) throws BGException {
        AuthUtils.connectionRebind(this.getSetup(), this.getConnection(), this.moduleId, connectionId, newContractId, newServId, newState, newOptionIds);
    }

    public void connectionsStop(int deviceId, long timeoutMinutes) throws BGException {
        if (timeoutMinutes <= 0L) {
            throw new BGMessageException("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 1 \u043c\u0438\u043d\u0443\u0442\u044b.");
        }
        int accountingRootDeviceId = InetUtils.getAccountingRootDeviceId(this.context.getSetup(), this.moduleId, deviceId);
        Preferences params = new Preferences();
        params.set("timeout", String.valueOf(timeoutMinutes));
        InetConnectionCommandEvent e = new InetConnectionCommandEvent(this.moduleId, this.userId, accountingRootDeviceId, deviceId, 0, 0L, "stopAllForDeviceId", params.toString());
        e = (InetConnectionCommandEvent)EventProcessor.getInstance().request((Event)e, 6000L);
        if (e == null) {
            throw new BGMessageException("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e Accounting \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d");
        }
    }
}

