/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.service;

import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.log.server.bean.ConnectionLogEntryDao;
import ru.bitel.bgbilling.kernel.log.server.event.RequestLogGetEvent;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.service.RequestLogService;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.concurrent.ConcurrentUtils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.inet.common.service.RequestLogService")
public class RequestLogServiceImpl
extends AbstractService
implements RequestLogService {
    public String inetConnectionLog(int deviceId, long connectionId, Date connectionStartTime) throws BGException {
        InetConnection connection = InetUtils.getConnection(this.getConnection(), this.moduleId, connectionId, connectionStartTime);
        if (connection == null) {
            connection = new InetConnectionDao(this.getConnection(), this.moduleId).get(deviceId, connectionId);
        }
        if (connection == null) {
            return "\u0421\u0435\u0441\u0441\u0438\u044f:" + connectionId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430";
        }
        ConnectionLogEntryDao dataLogEntryDao = new ConnectionLogEntryDao(this.getConnectionSet(), this.moduleId);
        List entryList = dataLogEntryDao.list(connection.getConnectionStart(), connection.getConnectionStop(), deviceId, connection.getDevicePort(), connection.getAcctSessionId(), connection.getId(), null);
        HashMap<Integer, ArrayList<ConnectionLogEntry>> map = new HashMap<Integer, ArrayList<ConnectionLogEntry>>();
        for (ConnectionLogEntry entry : entryList) {
            ArrayList<ConnectionLogEntry> list = (ArrayList<ConnectionLogEntry>)map.get(entry.getApplicationId());
            if (list == null) {
                list = new ArrayList<ConnectionLogEntry>();
                map.put(entry.getApplicationId(), list);
            }
            list.add(entry);
        }
        ArrayList<Future> futures = new ArrayList<Future>();
        long timeout = (long)this.context.getModuleSetup().getInt("requestLog.request.timeout", 30) * 1000L;
        for (Map.Entry e : map.entrySet()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Send request to " + e.getKey());
                for (ConnectionLogEntry connectionLogEntry : (List)e.getValue()) {
                    this.getLogger().debug("\tconnectionLogEntry.getId() = " + connectionLogEntry.getId());
                    this.getLogger().debug("\tconnectionLogEntry.getLogType() = " + connectionLogEntry.getLogType());
                    this.getLogger().debug("\tconnectionLogEntry.getDeviceId() = " + connectionLogEntry.getDeviceId());
                    this.getLogger().debug("\tconnectionLogEntry.getIdentifier() = " + connectionLogEntry.getIdentifier());
                    this.getLogger().debug("\tconnectionLogEntry.getConnectionId() = " + connectionLogEntry.getConnectionId());
                    this.getLogger().debug("\tconnectionLogEntry.getApplicationId() = " + connectionLogEntry.getApplicationId());
                }
            }
            RequestLogGetEvent event = new RequestLogGetEvent(this.moduleId, deviceId, ((Integer)e.getKey()).intValue(), (List)e.getValue());
            futures.add(EventProcessor.getInstance().requestAsync((Event)event, timeout));
        }
        try {
            if (!ConcurrentUtils.awaitFutures(futures, (long)timeout, (TimeUnit)TimeUnit.MILLISECONDS)) {
                return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430";
            }
        }
        catch (InterruptedException ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430: " + ex.getMessage();
        }
        StringBuilder result = new StringBuilder(1000);
        HashMap<Integer, ArrayList<RequestLogGetEvent.LogEntryResult>> resultMap = new HashMap<Integer, ArrayList<RequestLogGetEvent.LogEntryResult>>();
        for (Future future : futures) {
            try {
                RequestLogGetEvent event = (RequestLogGetEvent)future.get();
                if (event.getLogEntryResultList() != null) {
                    for (RequestLogGetEvent.LogEntryResult logEntryResult : event.getLogEntryResultList()) {
                        ArrayList<RequestLogGetEvent.LogEntryResult> list;
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug(logEntryResult.getId() + ":\n" + logEntryResult.getData());
                        }
                        if ((list = (ArrayList<RequestLogGetEvent.LogEntryResult>)resultMap.get(logEntryResult.getId())) == null) {
                            list = new ArrayList<RequestLogGetEvent.LogEntryResult>();
                            resultMap.put(logEntryResult.getId(), list);
                        }
                        list.add(logEntryResult);
                    }
                    continue;
                }
                this.getLogger().debug("Result list is null for contractId = " + event.getContractId() + "; event.getLogEntryList().size() = " + event.getLogEntryList().size());
            }
            catch (Exception ex) {
                this.getLogger().error(ex.getMessage(), (Throwable)ex);
                result.append(ex.getMessage()).append("\n");
            }
        }
        for (ConnectionLogEntry e : entryList) {
            List entryResultList = (List)resultMap.get(e.getId());
            if (entryResultList == null) continue;
            result.append(result.length() > 0 ? "\n" : "");
            for (RequestLogGetEvent.LogEntryResult entryResult : entryResultList) {
                result.append(result.length() > 0 ? "\n" : "");
                result.append("Time: ").append(TimeUtils.format((Date)new Date(entryResult.getMillis()), (String)"dd.MM.yyyy HH:mm:ss")).append("\n");
                result.append(entryResult != null ? entryResult.getData() : "null");
            }
        }
        return result.toString();
    }

    public String authErrorLog(int deviceId, Date errorTime, int logCoordinateRecordId) throws BGException {
        ConnectionLogEntryDao dataLogEntryDao = new ConnectionLogEntryDao(this.getConnectionSet(), this.moduleId);
        ConnectionLogEntry entry = dataLogEntryDao.get(deviceId, errorTime, logCoordinateRecordId);
        if (entry == null) {
            return "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u0430 \u043b\u043e\u0433\u0430.";
        }
        RequestLogGetEvent event = new RequestLogGetEvent(this.moduleId, deviceId, entry);
        event = (RequestLogGetEvent)EventProcessor.getInstance().request((Event)event, 10000L);
        StringBuilder result = new StringBuilder(1000);
        if (event.getLogEntryResultList() != null) {
            for (RequestLogGetEvent.LogEntryResult entryResult : event.getLogEntryResultList()) {
                result.append("Time: ").append(TimeUtils.format((Date)new Date(entryResult.getMillis()), (String)"dd.MM.yyyy HH:mm:ss")).append("\n");
                result.append(entryResult.getData());
                result.append("\n");
            }
        }
        return result.toString();
    }
}

