/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGFilterPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tools.client.ToolDialog;
import ru.bitel.bgbilling.modules.inet.client.InetContractMonitorPanel;
import ru.bitel.bgbilling.modules.inet.client.InvDevicePanel;
import ru.bitel.bgbilling.modules.inet.client.device.InetDeviceFormMain;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InvDevice;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.common.service.InetSessionService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.GroupParent;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.oss.systems.inventory.resource.client.device.DevicePanel;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceInterface;
import ru.bitel.oss.systems.inventory.resource.common.bean.DevicePortSubscription;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceTreeFilter;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceService;

public class InetDevicePanel
extends DevicePanel<InetDevice, InetDeviceType>
implements GroupParent {
    private static final String CONTRACT_MODE = "contracts";
    private final DataFlavor[] dataFlavors = new DataFlavor[]{new DataFlavor(DeviceOrderData.class, "DeviceOrderData")};
    AbstractBGUPanel.DefaultAction reloadAction;
    JPanel editorPanel = new JPanel();
    private InetDeviceService inetDeviceService = null;
    InetContractMonitorPanel contractPanel = new InetContractMonitorPanel();
    AbstractBGUPanel.MenuAction portContract = new AbstractBGUPanel.MenuAction("port.contract", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            DeviceInterface iface = (DeviceInterface)e.getSource();
            if (iface == null || iface.getSubscriberId() <= 0) {
                return;
            }
            InetServService servService = (InetServService)((ClientContext)InetDevicePanel.this.getContext()).getPort(InetServService.class);
            InetServ serv = servService.inetServGet(iface.getSubscriberId());
            if (serv == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0421\u0435\u0440\u0432\u0438\u0441 Inet \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
                return;
            }
            ClientUtils.openContract((int)serv.getContractId());
        }
    };
    AbstractBGUPanel.MenuAction portSubscriptionContract = new AbstractBGUPanel.MenuAction("devicePortSubscription.contract", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            DevicePortSubscription portSubscription = (DevicePortSubscription)e.getSource();
            if (portSubscription == null || portSubscription.getSubscriberId() <= 0) {
                return;
            }
            InetServService servService = (InetServService)((ClientContext)InetDevicePanel.this.getContext()).getPort(InetServService.class);
            InetServ serv = servService.inetServGet(portSubscription.getSubscriberId());
            if (serv == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0421\u0435\u0440\u0432\u0438\u0441 Inet \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                return;
            }
            ClientUtils.openContract((int)serv.getContractId());
        }
    };

    public InetDevicePanel(ClientContext clientContext) {
        this(clientContext, 1, null);
    }

    public InetDevicePanel(ClientContext clientContext, int mode, ActionListener actionListener) {
        super(clientContext, mode, actionListener);
        if (mode == 1) {
            new AbstractBGUPanel.MenuAction("device.contracts", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b", ClientUtils.getIcon((String)"fugue/folder-open-document-text")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    int id = ((InetDevice)InetDevicePanel.this.getModel().getSelectedRow()).getId();
                    InetDevicePanel.this.contractPanel.setDeviceId(id);
                    InetDevicePanel.this.contractPanel.setData(InetDevicePanel.this.getInetDeviceService().getContracts(id));
                    ((CardLayout)InetDevicePanel.this.editorPanel.getLayout()).show(InetDevicePanel.this.editorPanel, InetDevicePanel.CONTRACT_MODE);
                    InetDevicePanel.this.editorPanel.setVisible(true);
                }
            };
            new AbstractBGUPanel.MenuAction("device.saReinit", "\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441\u044b", ClientUtils.getIcon((String)"fugue/arrow-repeat")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    InetDevice device = (InetDevice)InetDevicePanel.this.getModel().getSelectedRow();
                    if (device != null && device.getId() > 0 && BGSwingUtilites.confirm((String)"\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u044b \u043d\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0435", (Object)device)) {
                        InetDevicePanel.this.getInetDeviceService().deviceSaReinit(device.getId());
                    }
                }
            };
            new AbstractBGUPanel.MenuAction("device.manage", "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443", ClientUtils.getIcon((String)"fugue/terminal-network")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    String operation;
                    InetDevice device = (InetDevice)InetDevicePanel.this.getModel().getSelectedRow();
                    if (device != null && device.getId() > 0 && Utils.notBlankString((String)(operation = JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443?", "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443", 3)))) {
                        InetDevicePanel.this.executeCommand(device, operation);
                    }
                }
            };
            new AbstractBGUPanel.MenuAction("device.stopConnections", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0432 \u0411\u0414", ClientUtils.getIcon((String)"fugue/plug--minus")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    InetDevice device = (InetDevice)InetDevicePanel.this.getModel().getSelectedRow();
                    if (device == null || device.getId() <= 0) {
                        return;
                    }
                    String s = (String)JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0442\u0430\u0439\u043c\u0430\u0443\u0442 (\u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445) \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438\n\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0439, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0432 \u0411\u0414:", "\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0439", 2, null, null, "0");
                    if (s == null) {
                        return;
                    }
                    ((InetSessionService)((ClientContext)InetDevicePanel.this.getContext()).getPort(InetSessionService.class)).connectionsStop(device.getId(), Utils.parseLong((String)s, (long)0L));
                }
            };
            new AbstractBGUPanel.MenuAction("device.__skipSaEvent", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438", ClientUtils.getIcon((String)"fugue/traffic-cone--minus")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    String result;
                    InetDevice device = (InetDevice)InetDevicePanel.this.getModel().getSelectedRow();
                    if (device != null && device.getId() > 0 && BGSwingUtilites.confirm((String)"\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438", (Object)device) && Utils.notBlankString((String)(result = InetDevicePanel.this.getInetDeviceService().deviceManage(device.getInvDeviceId(), device.getId(), "__skipSaEvent:" + device.getId(), 0, 0, 20000L)))) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), result, "\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442", 0);
                    }
                }
            };
        }
    }

    protected void jbInit() {
        super.jbInit();
    }

    protected BGTreeTableModel<InetDevice> newModel() {
        return new InetDeviceTableModel();
    }

    public boolean isLibrary() {
        return false;
    }

    protected String getTitle(InetDevice val, Calendar calendar) {
        String title = val.getTitle();
        Object result = title;
        if (val.getEntityId() == -100) {
            result = "<html><font color='#666666'>" + (String)result + "</font></html>";
        } else if (title.equals(val.getInvTitle())) {
            if (title != val.getInvTitle()) {
                val.setTitle(val.getInvTitle());
            }
            if (val.getDateTo() != null) {
                calendar.setTime(val.getDateTo());
                if (TimeUtils.dateBefore((Calendar)calendar, (Calendar)this.currentDay)) {
                    result = "<html><font color='#666666'>" + (String)result + "</font></html>";
                }
            }
        } else if (val.getDateTo() != null) {
            calendar.setTime(val.getDateTo());
            if (TimeUtils.dateBefore((Calendar)calendar, (Calendar)this.currentDay)) {
                result = "<html><font color='#666666'>" + (String)result + "</font></html>";
            }
        } else {
            result = "<html>" + (String)result + "</html>";
        }
        return result;
    }

    protected void initEditor(BGEditor editor) {
        super.initEditor(editor);
        editor.addForm((JComponent)((Object)new MenuForm()));
        editor.addForm((JComponent)((Object)new MenuForm2()));
    }

    protected void executeCommand(InetDevice device, String operation) throws BGException {
        InetDevicePanel.executeCommand((ClientContext)this.getContext(), device.getInvDeviceId(), device.getId(), operation, 0, 0);
    }

    public static void executeCommand(ClientContext context, int invDeviceId, int inetDeviceId, String operation, int servId, int connectionId) throws BGException {
        ToolDialog dialog = new ToolDialog(context);
        Async future = Async.of(() -> ((InetDeviceService)context.getPort(InetDeviceService.class)).deviceManage(invDeviceId, inetDeviceId, operation, servId, connectionId, TimeUnit.MINUTES.toMillis(3L))).handle((result, ex) -> {
            dialog.handler(result, ex);
            return result;
        });
        dialog.setFuture(future);
    }

    public void setFilter(Set<Integer> deviceTypeIds, Set<Integer> deviceGroupIds) {
        this.filter.setDeviceGroupIds(deviceGroupIds);
        if (deviceTypeIds == null || deviceTypeIds.size() == 0 || deviceTypeIds.size() == 1 && deviceTypeIds.contains(-1)) {
            deviceTypeIds = null;
        }
        this.defaultDeviceTypeIds = deviceTypeIds;
    }

    protected void initActions() {
        super.initActions();
        this.reloadAction = new AbstractBGUPanel.DefaultAction("inetReload", "\u041f\u0435\u0440\u0435\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430\u0445"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e\n\u043d\u0430 \u0432\u0441\u0435\u0445 \u0441\u0435\u0440\u0432\u0435\u0440\u0430\u0445 InetAccess/InetAccounting?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                    InetDevicePanel.this.getInetDeviceService().deviceReload(0);
                }
            }
        };
    }

    protected JComponent treeWrap(BGFilterPane splitPane) {
        if (this.mode == 1) {
            JButton reloadButton = new JButton((Action)this.reloadAction);
            Border border = reloadButton.getBorder();
            splitPane.getToolBar().add((Action)new BGUAction("showReorderDialog", "\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430", ClientUtils.getIcon((String)"fugue/tree--pencil")){

                public void actionPerformed(ActionEvent actionEvent) {
                    InetDevicePanel.this.reorderTree();
                }
            });
            splitPane.getToolBar().add(Box.createHorizontalStrut(100));
            splitPane.getToolBar().add((Component)reloadButton);
            reloadButton.setBorder(border);
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)splitPane, "Center");
            this.editorPanel.setLayout(new CardLayout());
            this.editorPanel.add((Component)((Object)this.contractPanel), CONTRACT_MODE);
            this.editorPanel.setVisible(false);
            panel2.add((Component)this.editorPanel, "East");
            return panel2;
        }
        return splitPane;
    }

    private void reorderTree() {
        try {
            JSONObject treeJsonObject = this.getInetDeviceService().inetDeviceTree();
            DeviceOrderData deviceOrderData = new DeviceOrderData();
            deviceOrderData.id = treeJsonObject.getInt("id");
            deviceOrderData.title = treeJsonObject.getString("title");
            deviceOrderData.type = 0;
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(deviceOrderData);
            this.buildTree(rootNode, treeJsonObject);
            JTree deviceTree = new JTree(rootNode);
            deviceTree.setCellRenderer(new DeviceTreeCellRender());
            deviceTree.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            deviceTree.getSelectionModel().setSelectionMode(2);
            deviceTree.setDragEnabled(true);
            deviceTree.setDropMode(DropMode.ON_OR_INSERT);
            deviceTree.setTransferHandler(new TreeTransferHandler());
            Dimension dimension = new Dimension(1000, 600);
            JScrollPane scrollPane = new JScrollPane(deviceTree);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            JButton expandTreeButton = new JButton("\u0440\u0430\u0437\u0432\u0435\u0440\u043d\u0443\u0442\u044c \u0434\u0435\u0440\u0435\u0432\u043e");
            expandTreeButton.addActionListener(e -> {
                for (int i = 0; i < deviceTree.getRowCount(); ++i) {
                    deviceTree.expandRow(i);
                }
            });
            JButton expandTreeNodeButton = new JButton("\u0440\u0430\u0437\u0432\u0435\u0440\u043d\u0443\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0432\u0435\u0442\u043a\u0443");
            expandTreeNodeButton.addActionListener(e -> {
                if (!deviceTree.getSelectionModel().isSelectionEmpty()) {
                    int i;
                    int j = i = deviceTree.getSelectionModel().getSelectionRows()[0];
                    while (true) {
                        int max1 = deviceTree.getRowCount();
                        deviceTree.expandRow(i);
                        int max2 = deviceTree.getRowCount();
                        if (i == (j += max2 - max1)) break;
                        ++i;
                    }
                }
            });
            JButton collapseTreeButton = new JButton("\u0441\u0432\u0435\u0440\u043d\u0443\u0442\u044c \u0434\u0435\u0440\u0435\u0432\u043e");
            collapseTreeButton.addActionListener(e -> {
                for (int i = 1; i < deviceTree.getRowCount(); ++i) {
                    deviceTree.collapseRow(i);
                }
            });
            JPanel topPanel = new JPanel(new GridBagLayout());
            topPanel.add(collapseTreeButton);
            topPanel.add(expandTreeButton);
            topPanel.add(expandTreeNodeButton);
            topPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)topPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            JButton[] buttons = new JButton[]{new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c")};
            BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430", buttons);
            JDialog dialog = optionPane.getDialog();
            buttons[0].addActionListener(e -> dialog.setVisible(false));
            dialog.setVisible(true);
        }
        catch (Exception e2) {
            ClientUtils.showErrorMessageDialog((Throwable)e2);
        }
    }

    private void buildTree(DefaultMutableTreeNode treeNode, JSONObject jsonObject) {
        JSONArray array = jsonObject.optJSONArray("children");
        if (array != null && !array.isEmpty()) {
            for (int i = 0; i < array.length(); ++i) {
                JSONObject chJsonObject = array.getJSONObject(i);
                DeviceOrderData deviceOrderData = new DeviceOrderData();
                deviceOrderData.id = chJsonObject.getInt("id");
                deviceOrderData.title = chJsonObject.getString("title");
                deviceOrderData.type = chJsonObject.getInt("deviceTypeId");
                DefaultMutableTreeNode chTreeNode = new DefaultMutableTreeNode(deviceOrderData);
                treeNode.add(chTreeNode);
                this.buildTree(chTreeNode, chJsonObject);
            }
        }
    }

    protected Class<InetDevice> getDeviceClass() {
        return InetDevice.class;
    }

    public InetDevice newDevice() {
        return new InetDevice();
    }

    public InetDeviceType newDeviceType(int id, String title) {
        return new InetDeviceType(id, title);
    }

    public DeviceService getWs() {
        return this.getInetDeviceService();
    }

    public InetDeviceService getInetDeviceService() {
        if (this.inetDeviceService == null) {
            this.inetDeviceService = (InetDeviceService)((ClientContext)this.getContext()).getPort(InetDeviceService.class);
        }
        return this.inetDeviceService;
    }

    public InetDevice deviceGet(int id) throws BGException {
        return this.getInetDeviceService().inetDeviceGet(id);
    }

    public void deviceDelete(int id) throws BGException {
        this.getInetDeviceService().inetDeviceDelete(id);
    }

    public int deviceUpdate(InetDevice device) throws BGException {
        return this.getInetDeviceService().inetDeviceUpdate(device, true);
    }

    public void deviceMove(int id, Set<Integer> cutSet) throws BGException {
        this.getInetDeviceService().inetDeviceMove(id, cutSet);
    }

    public InetDevice deviceSourceRoot() throws BGException {
        return this.getInetDeviceService().deviceSourceRoot();
    }

    public InetDevice deviceRoot(DeviceTreeFilter deviceTreeFilter) throws BGException {
        deviceTreeFilter.setLoadDeviceGroupLink(false);
        return this.getInetDeviceService().inetDeviceRoot(deviceTreeFilter, this.mode == 2 || this.mode == 1);
    }

    public int getInvDeviceId(InetDevice device) {
        return device.getInvDeviceId();
    }

    protected Class<InetDeviceType> getDeviceTypeClass() {
        return InetDeviceType.class;
    }

    protected BGUPanel newMainForm(AtomicReference<InetDevice> currentRef) {
        return new InetDeviceFormMain(this, currentRef);
    }

    protected void ok() {
        this.selectedDevice = (Device)this.getModel().getSelectedRow();
        if (this.selectedDevice == null) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
            return;
        }
        if (((InetDevice)this.selectedDevice).getInvDeviceId() == 0) {
            return;
        }
        this.performDeviceSelected();
        this.performActionClose();
    }

    protected InetDevice getLoadingStateRoot() {
        InetDevice result = new InetDevice();
        result.setId(-1);
        return result;
    }

    class DeviceOrderData
    implements Transferable {
        int id;
        int type;
        String title;

        DeviceOrderData() {
        }

        public String toString() {
            return this.title;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return InetDevicePanel.this.dataFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor != null && flavor.equals(InetDevicePanel.this.dataFlavors[0]);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this;
        }
    }

    protected class InetDeviceTableModel
    extends DevicePanel.DeviceTableModel {
        protected InetDeviceTableModel() {
            super((DevicePanel)InetDevicePanel.this);
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", Device.class, -1, 300, -1, "title", false);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", "comment", false);
            if (InetDevicePanel.this.mode != 3) {
                this.addColumn("SVLAN", 80, 80, 80, "svlan", false);
                if (!InetDevicePanel.this.isLibrary() && InetDevicePanel.this.mode == 1) {
                    this.addColumn("InvDeviceID", 100, 100, 100, "invDeviceId", false, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
                    this.invDeviceIdCol = 3;
                }
                this.addColumnId(false);
            }
        }

        public Object getValue(InetDevice val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("title".equals(identifier)) {
                return super.getValue((Device)val, column);
            }
            if ("svlan".equals(identifier)) {
                return val.getSvlan() < 0 ? "" : Integer.valueOf(val.getSvlan());
            }
            return super.getValue((Device)val, column);
        }
    }

    class MenuForm
    extends BGUPanel {
        AbstractBGUPanel.MenuAction copyFromLibrary = new AbstractBGUPanel.MenuAction("device.copyFromLibrary", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u0437 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438", ClientUtils.getIcon((String)"fugue/servers-network")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InvDevicePanel.COPY_DEVICE_IDS.clear();
                InetDevicePanel.this.getModel().optSelectedRows().ifPresent(a -> a.forEach(d -> InvDevicePanel.COPY_DEVICE_IDS.add(d.getInvDeviceId())));
            }
        };
        AbstractBGUPanel.MenuAction pasteFromLibrary = new AbstractBGUPanel.MenuAction("device.pasteFromLibrary", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0438\u0437 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438", ClientUtils.getIcon((String)"fugue/server--plus")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetDevice parent = (InetDevice)InetDevicePanel.this.getModel().getSelectedRow();
                if (parent == null || InvDevicePanel.COPY_DEVICE_IDS.size() == 0) {
                    return;
                }
                for (Integer deviceId : InvDevicePanel.COPY_DEVICE_IDS) {
                    InvDevice device = (InvDevice)InetDevicePanel.this.getInetDeviceService().deviceGet(deviceId.intValue());
                    InetDevice inetDevice = new InetDevice();
                    inetDevice.fromInvDevice(device);
                    inetDevice.setParentId(parent.getId());
                    inetDevice.setDeviceTypeId(-1);
                    inetDevice.setConfig("");
                    InetDevicePanel.this.getInetDeviceService().inetDeviceUpdate(inetDevice, false);
                }
                InetDevicePanel.this.performAction("refresh");
            }
        };

        MenuForm() {
        }

        protected void jbInit() throws Exception {
        }
    }

    class MenuForm2
    extends BGUPanel {
        AbstractBGUPanel.MenuAction inetReload = new AbstractBGUPanel.MenuAction("device.inetReload", "\u041f\u0435\u0440\u0435\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e", ClientUtils.getIcon((String)"fugue/arrow-circle-double")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetDevice device = (InetDevice)InetDevicePanel.this.getModel().getSelectedRow();
                if (device != null && device.getId() > 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u0441\u0435\u0440\u0432\u0435\u0440\u0430\u0445 InetAccess/InetAccounting?\n\u0415\u0441\u043b\u0438 \u0432\u044b \u0432\u044b\u0431\u0440\u0430\u043b\u0438 \u043d\u0435 \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e, \u0442\u043e \u043d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u043f\u0440\u043e\u0438\u0437\u043e\u0439\u0434\u0435\u0442.", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                    InetDevicePanel.this.getInetDeviceService().deviceReload(device.getId());
                }
            }
        };

        MenuForm2() {
        }

        protected void jbInit() throws Exception {
        }
    }

    class DeviceTreeCellRender
    extends DefaultTreeCellRenderer {
        DeviceTreeCellRender() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject;
            Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof DeviceOrderData) {
                if (((DeviceOrderData)userObject).id == 0) {
                    this.setIcon(InetDevicePanel.this.iconRoot);
                } else if (((DeviceOrderData)userObject).type == 0) {
                    this.setIcon(InetDevicePanel.this.iconFolder);
                } else if (leaf) {
                    this.setIcon(InetDevicePanel.this.iconLeaf);
                } else {
                    this.setIcon(InetDevicePanel.this.iconNode);
                }
            }
            return component;
        }
    }

    class TreeTransferHandler
    extends TransferHandler {
        TreeTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent component) {
            Transferable transferable = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)((JTree)component).getLastSelectedPathComponent();
            if (node.getUserObject() instanceof Transferable) {
                transferable = (Transferable)node.getUserObject();
            }
            return transferable;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            Object transferData = null;
            try {
                transferData = transferSupport.getTransferable().getTransferData(InetDevicePanel.this.dataFlavors[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (transferData == null) {
                return false;
            }
            final JTree tree = (JTree)transferSupport.getComponent();
            final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
            int srcId = ((DeviceOrderData)transferData).id;
            DefaultMutableTreeNode moveNode = this.getNode(rootNode, srcId);
            JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
            final TreePath treePath = dropLocation.getPath();
            DefaultMutableTreeNode last = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            int childIndex = dropLocation.getChildIndex();
            try {
                InetDevicePanel.this.getInetDeviceService().deviceTreeReorder(srcId, ((DeviceOrderData)last.getUserObject()).id, childIndex);
                if (childIndex == -1) {
                    treeModel.removeNodeFromParent(moveNode);
                    last.add(moveNode);
                } else if (moveNode.getParent() == last) {
                    int srcIndex = treeModel.getIndexOfChild(moveNode.getParent(), moveNode);
                    treeModel.removeNodeFromParent(moveNode);
                    last.insert(moveNode, childIndex - (srcIndex < childIndex ? 1 : 0));
                } else {
                    last.insert(moveNode, childIndex);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        treeModel.reload();
                        tree.expandPath(treePath);
                        InetDevicePanel.this.performAction("refresh");
                    }
                });
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            return true;
        }

        private DefaultMutableTreeNode getNode(DefaultMutableTreeNode currentNode, int deviceId) {
            DeviceOrderData deviceOrderData = (DeviceOrderData)currentNode.getUserObject();
            if (deviceOrderData.id == deviceId) {
                return currentNode;
            }
            Enumeration<TreeNode> enumeration = currentNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
                DefaultMutableTreeNode resultNode = this.getNode(node, deviceId);
                if (resultNode == null) continue;
                return resultNode;
            }
            return null;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            Object transferData = null;
            try {
                transferData = transferSupport.getTransferable().getTransferData(InetDevicePanel.this.dataFlavors[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (transferData == null) {
                return false;
            }
            int srcId = ((DeviceOrderData)transferData).id;
            JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
            TreePath treePath = dropLocation.getPath();
            for (Object object : treePath.getPath()) {
                Object userObject = ((DefaultMutableTreeNode)object).getUserObject();
                int dstId = ((DeviceOrderData)userObject).id;
                if (srcId != dstId) continue;
                return false;
            }
            return true;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
        }
    }
}

