/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.json.JSONObject;
import org.jxmapviewer.viewer.GeoPosition;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.map.bean.MapMarker;
import ru.bitel.bgbilling.kernel.map.bean.PointPair;
import ru.bitel.bgbilling.kernel.map.kernel.MapViewerFrame;
import ru.bitel.bgbilling.kernel.map.kernel.MapViewerHelper;
import ru.bitel.bgbilling.modules.inet.client.map.bean.DeviceMapMarker;
import ru.bitel.bgbilling.modules.inet.common.bean.InvDevice;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;

public class InvDeviceMap {
    private final ClientContext context;
    private AddressService addressService;
    private final MapViewerHelper mapViewerHelper;
    private final BGUList<InvDevice> devicesList;
    private final Map<Integer, DeviceMapMarker> locationCache = new HashMap<Integer, DeviceMapMarker>();
    private final MapViewerFrame mapViewerFrame = new MapViewerFrame(false);

    public InvDeviceMap(ClientContext context) {
        this.context = context;
        this.mapViewerHelper = new MapViewerHelper(this.mapViewerFrame.getMapViewer());
        this.devicesList = new BGUList();
        this.devicesList.setCellRenderer((ListCellRenderer)new DeviceListCellRenderer());
        this.devicesList.setOpaque(false);
        JScrollPane devicesScroll = new JScrollPane((Component)this.devicesList);
        devicesScroll.setVerticalScrollBarPolicy(20);
        Dimension dimension = new Dimension(250, -1);
        devicesScroll.setSize(dimension);
        devicesScroll.setPreferredSize(dimension);
        this.mapViewerFrame.getRootPanel().add((Component)devicesScroll, "East");
        this.mapViewerFrame.getFrame().setVisible(true);
        this.devicesList.addListSelectionListener(e -> {
            if (this.devicesList.getSelectedValue() != null && e.getValueIsAdjusting()) {
                InvDevice selected = (InvDevice)this.devicesList.getSelectedValue();
                this.mapViewerHelper.getWaypoints().stream().filter(waypoint -> waypoint.getMapMarker().getTitle().equals(selected.getTitle())).findFirst().ifPresent(waypoint -> {
                    this.mapViewerHelper.getMapViewer().setAddressLocation((GeoPosition)waypoint.getMapMarker());
                    this.mapViewerHelper.setZoom(3);
                });
            }
        });
    }

    public void showDevicesOnMap(List<InvDevice> devices) {
        this.setPointsToMap(this.convertDevicesToMapTrack(devices));
        this.devicesList.setData(this.deviceWithChildren(devices));
    }

    private List<InvDevice> deviceWithChildren(List<InvDevice> devices) {
        ArrayList<InvDevice> result = new ArrayList<InvDevice>();
        for (InvDevice d : devices) {
            result.add(d);
            if (!Utils.notEmptyCollection((Collection)d.getChildren())) continue;
            result.addAll(this.deviceWithChildren(d.getChildren()));
        }
        return result;
    }

    private List<PointPair> convertDevicesToMapTrack(List<InvDevice> devices) {
        ArrayList<PointPair> track = new ArrayList<PointPair>();
        for (InvDevice device : devices) {
            PointPair pair = this.buildTrack(device);
            if (pair != null) {
                track.add(pair);
            }
            if (!Utils.notEmptyCollection((Collection)device.getChildren())) continue;
            track.addAll(this.convertDevicesToMapTrack(device.getChildren()));
        }
        return track;
    }

    private PointPair buildTrack(InvDevice invDevice) {
        DeviceMapMarker deviceMapMarker = null;
        Map attributes = invDevice.getEntityAttributes();
        if (attributes == null) {
            return null;
        }
        for (EntityAttr attr : attributes.values()) {
            if (!(attr instanceof EntityAttrAddress)) continue;
            EntityAttrAddress house = (EntityAttrAddress)attr;
            deviceMapMarker = this.getLocationByHouseId(invDevice, house);
            break;
        }
        if (deviceMapMarker == null) {
            return null;
        }
        this.locationCache.put(invDevice.getId(), deviceMapMarker);
        DeviceMapMarker start = this.locationCache.get(invDevice.getParentId()) != null ? this.locationCache.get(invDevice.getParentId()) : deviceMapMarker;
        DeviceMapMarker end = this.locationCache.get(invDevice.getParentId()) != null && start != null ? deviceMapMarker : null;
        return new PointPair((MapMarker)start, (MapMarker)end);
    }

    private DeviceMapMarker getLocationByHouseId(InvDevice device, EntityAttrAddress address) {
        try {
            JSONObject coordinates = new JSONObject((Object)this.getAddressService().searchCoordinatesByHouseId(address.getHouseId()));
            if (!coordinates.has("latitude") || !coordinates.has("longitude")) {
                return null;
            }
            DeviceMapMarker deviceMapMarker = new DeviceMapMarker(device, coordinates.optDouble("latitude"), coordinates.optDouble("longitude"));
            deviceMapMarker.setClickListener(new DeviceClickListener(deviceMapMarker));
            return deviceMapMarker;
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
            return null;
        }
    }

    public void setPointsToMap(List<PointPair> points) {
        this.mapViewerHelper.getMapViewer().setOverlayPainter(null);
        this.mapViewerHelper.setTrackToBetweenPoints(points);
    }

    private AddressService getAddressService() {
        if (this.addressService == null) {
            this.addressService = (AddressService)this.context.getWebService(AddressService.class, 0);
        }
        return this.addressService;
    }

    static class DeviceListCellRenderer
    extends DefaultListCellRenderer {
        DeviceListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            InvDevice device = (InvDevice)value;
            JPanel p = new JPanel(new GridBagLayout());
            if (isSelected) {
                p.setBackground(list.getSelectionBackground());
            } else {
                p.setBackground(Color.pink);
            }
            p.setOpaque(true);
            Font font = new Font(p.getFont().getFamily(), 2, 10);
            JLabel title = new JLabel(device.getTitle());
            JLabel state = new JLabel("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435:");
            state.setFont(font);
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 17, 2, new Insets(0, 3, 0, 3), 0, 0);
            p.add((Component)title, constraints);
            if (Utils.notBlankString((String)device.getHost())) {
                JLabel host = new JLabel("\u0425\u043e\u0441\u0442: " + device.getHost());
                host.setFont(font);
                p.add((Component)host, constraints);
            }
            if (Utils.notBlankString((String)device.getIdentifier())) {
                JLabel ident = new JLabel(device.getIdentifier());
                ident.setFont(font);
                p.add((Component)ident, constraints);
            }
            JLabel address = new JLabel();
            address.setFont(font);
            address.setText("<html><div style='width: 200px;'>" + this.getAddress(device) + "</div></html>");
            p.add((Component)address, constraints);
            p.add(Box.createHorizontalGlue(), constraints);
            BGSwingUtilites.wrapRoundedBorder((JComponent)p, (int)14);
            p.setPreferredSize(new Dimension(-1, 70));
            return p;
        }

        private String getAddress(InvDevice device) {
            String address = "";
            if (device.getEntityAttributes() == null) {
                return address;
            }
            for (EntityAttr attr : device.getEntityAttributes().values()) {
                if (!(attr instanceof EntityAttrAddress)) continue;
                EntityAttrAddress entityAttrAddress = (EntityAttrAddress)attr;
                address = entityAttrAddress.getTitle();
                break;
            }
            return address;
        }
    }

    private final class DeviceClickListener
    extends MouseAdapter {
        private final DeviceMapMarker deviceMapMarker;

        public DeviceClickListener(DeviceMapMarker deviceMapMarker) {
            this.deviceMapMarker = deviceMapMarker;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            InvDeviceMap.this.devicesList.setSelectedValue((Object)this.deviceMapMarker.getDevice(), true);
        }
    }

    private static final class StatusCircle
    extends JPanel {
        private final Color color;

        public StatusCircle(Color color) {
            this.color = color;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(this.color);
            int diameter = 10;
            int x = 5;
            int y = (this.getHeight() - diameter) / 2;
            g.fillOval(x, y, diameter, diameter);
        }
    }
}

