/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn;

import bitel.billing.server.load.bean.Source;
import bitel.billing.server.netflow.ipn.BinaryLogLoadOut;
import bitel.billing.server.netflow.ipn.FlowListLoadIn;
import bitel.billing.server.netflow.ipn.NetFlowSetup;
import bitel.billing.server.netflow.ipn.SourceSelector;
import bitel.billing.server.netflow.packet.FlowPacket;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.ipn.server.BaseLoader;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;

@Deprecated
public class FlowsLoader {
    private Logger logger = LogManager.getLogger((String)"loader");
    private NetFlowSetup setup;
    private SourceSelector ss;
    private long lastHour;
    private Map<Integer, BaseLoader> loadersMap = Collections.synchronizedMap(new HashMap());
    private AtomicInteger packetCount = new AtomicInteger();
    private AtomicInteger flowCount = new AtomicInteger();

    public FlowsLoader(NetFlowSetup setup, SourceSelector ss) {
        this.setup = setup;
        this.ss = ss;
        this.lastHour = FlowsLoader.getLastHour();
    }

    public void finishLoad() {
        this.finishLoad(this.loadersMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishLoad(Map<Integer, BaseLoader> loadersMap) {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            for (BaseLoader loader : loadersMap.values()) {
                loader.finishLoad(con, false, 0L, 0L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private static final long getLastHour() {
        GregorianCalendar lastHour = new GregorianCalendar();
        lastHour.set(12, 0);
        lastHour.set(13, 0);
        lastHour.set(14, 0);
        ((Calendar)lastHour).add(11, 1);
        return lastHour.getTimeInMillis() + 1L;
    }

    static String numericToTextFormat(byte[] src) {
        return (src[0] & 0xFF) + "." + (src[1] & 0xFF) + "." + (src[2] & 0xFF) + "." + (src[3] & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFlow(byte[] address, FlowPacket packet) {
        Source source;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Load NetFlow packet from {}", (Object)FlowsLoader.numericToTextFormat(address));
        }
        long hostAddress = address[3] & 0xFF;
        hostAddress |= (long)(address[2] << 8 & 0xFF00);
        hostAddress |= (long)(address[1] << 16 & 0xFF0000);
        hostAddress |= (long)(address[0] << 24 & 0xFF000000);
        hostAddress &= 0xFFFFFFFFL;
        long now = System.currentTimeMillis();
        if (now > this.lastHour) {
            if (this.loadersMap.size() > 0) {
                FlowsLoader flowsLoader = this;
                synchronized (flowsLoader) {
                    this.logger.info("Reinit loaders map...");
                    Map<Integer, BaseLoader> loadersMap = this.loadersMap;
                    this.loadersMap = Collections.synchronizedMap(new HashMap());
                    this.finishLoad(loadersMap);
                }
            }
            this.lastHour = FlowsLoader.getLastHour();
        }
        if ((source = this.ss.getAddressSource(hostAddress)) != null) {
            FlowListLoadIn loadIn;
            BaseLoader loader = this.loadersMap.get(source.getId());
            if (loader == null) {
                FlowsLoader flowsLoader = this;
                synchronized (flowsLoader) {
                    loader = this.loadersMap.get(source.getId());
                    if (loader == null) {
                        this.logger.info("Make new loader for {}", (Object)source.getId());
                        loader = new BaseLoader();
                        loader.init((DefaultServerSetup)this.setup, source, new GregorianCalendar(), 0);
                        BinaryLogLoadOut loadOut = new BinaryLogLoadOut(loader);
                        loader.setLoadOut(loadOut);
                        this.loadersMap.put(source.getId(), loader);
                    }
                }
                this.packetCount.getAndIncrement();
                this.flowCount.getAndAdd(packet.getFlowCount());
                loadIn = new FlowListLoadIn(loader, packet);
                loader.doLoad(null, loadIn);
            }
            this.packetCount.getAndIncrement();
            this.flowCount.getAndAdd(packet.getFlowCount());
            loadIn = new FlowListLoadIn(loader, packet);
            loader.doLoad(null, loadIn);
        } else {
            this.logger.warn("Ignore packet from {}", (Object)FlowsLoader.numericToTextFormat(address));
        }
    }

    public void resetCounters() {
        this.flowCount.set(0);
        this.packetCount.set(0);
    }

    public String getStatus() {
        StringBuffer result = new StringBuffer();
        result.append(" packets: ");
        result.append(this.packetCount);
        result.append("; flows: ");
        result.append(this.flowCount);
        return result.toString();
    }
}

