/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ContractMonitor
extends TaskBase {
    private int CALL = 0;
    private int WAIT = 0;
    private int TO_OFF = 0;
    private int OFF = 0;
    private int ON = 0;
    private int statusListID = 0;
    private int callStartDateID = 0;
    private int waitStartDateID = 0;
    private IntervalChecker callIch;
    private IntervalChecker waitIch;
    private PreparedStatement psUpdateStatus;
    private PreparedStatement psInsertStatus;
    private PreparedStatement psUpdateDateParameter;
    private PreparedStatement psInsertDateParameter;
    private PreparedStatement psDeleteDateParameter;

    @Override
    public String getDescription() {
        return this.defaultDescription + "\u0417\u0430\u0434\u0430\u0447\u0430 \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0438\u043d\u0433\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432.";
    }

    @Override
    protected boolean initTask() {
        String statusList = this.taskSetup.get("status.list", null);
        if (statusList == null || statusList.length() == 0) {
            this.getLogger().error("Wrong param status.list");
            return false;
        }
        String[] id_values = statusList.split(";");
        if (id_values.length != 2) {
            this.getLogger().error("Wrong param status.list. Mast be id;call:wait:to_off:off:on");
            return false;
        }
        this.statusListID = Utils.parseInt((String)id_values[0].trim(), (int)-1);
        if (this.statusListID < 0) {
            this.getLogger().error("Wrong status list param id!");
            return false;
        }
        String[] codes = id_values[1].split(":");
        if (codes.length != 5) {
            this.getLogger().error("You must define 5 values for status list param!");
            return false;
        }
        this.CALL = Utils.parseInt((String)codes[0].trim(), (int)-1);
        this.WAIT = Utils.parseInt((String)codes[1].trim(), (int)-1);
        this.TO_OFF = Utils.parseInt((String)codes[2].trim(), (int)-1);
        this.OFF = Utils.parseInt((String)codes[3].trim(), (int)-1);
        this.ON = Utils.parseInt((String)codes[4].trim(), (int)-1);
        if (this.CALL < 0 || this.WAIT < 0 || this.TO_OFF < 0 || this.OFF < 0 || this.ON < 0) {
            this.getLogger().error("List param values must be positive integer!");
            return false;
        }
        this.callStartDateID = this.taskSetup.getInt("call.start.date", -1);
        if (this.callStartDateID < 0) {
            this.getLogger().error("Wrong call.start.date!");
            return false;
        }
        this.waitStartDateID = this.taskSetup.getInt("wait.start.date", -1);
        if (this.waitStartDateID < 0) {
            this.getLogger().error("Wrong wait.start.date!");
            return false;
        }
        String periodCall = this.taskSetup.get("period.call", "3d");
        this.getLogger().debug("Create call interval checker for period.call=" + periodCall);
        this.callIch = new IntervalChecker(periodCall);
        String waitCall = this.taskSetup.get("period.wait", "3d");
        this.getLogger().debug("Create wait interval checker for period.wait=" + waitCall);
        this.waitIch = new IntervalChecker(waitCall);
        return true;
    }

    @Override
    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();
             BalanceUtils bu = new BalanceUtils(con);){
            String q = "UPDATE contract_parameter_type_7 SET val=? WHERE cid=? AND pid=?";
            this.psUpdateStatus = con.prepareStatement(q);
            this.psUpdateStatus.setInt(3, this.statusListID);
            q = "INSERT INTO contract_parameter_type_7 SET val=?, cid=?,  pid=?";
            this.psInsertStatus = con.prepareStatement(q);
            this.psInsertStatus.setInt(3, this.statusListID);
            q = "UPDATE contract_parameter_type_6 SET val=? WHERE pid=? AND cid=?";
            this.psUpdateDateParameter = con.prepareStatement(q);
            q = "INSERT INTO contract_parameter_type_6 SET val=?, pid=?, cid=?";
            this.psInsertDateParameter = con.prepareStatement(q);
            q = "DELETE FROM contract_parameter_type_6 WHERE pid=? AND cid=?";
            this.psDeleteDateParameter = con.prepareStatement(q);
            long time = System.currentTimeMillis();
            StringBuffer query = new StringBuffer(300);
            query.append("SELECT t1.id, t1.mode, t1.closesumma, t1.title, t2.val, t3.val, t4.val");
            query.append(" FROM contract AS t1");
            query.append(" LEFT OUTER JOIN contract_parameter_type_7 AS t2");
            query.append(" ON t1.id=t2.cid AND t2.pid=");
            query.append(this.statusListID);
            query.append(" LEFT OUTER JOIN contract_parameter_type_6 AS t3");
            query.append(" ON t1.id=t3.cid AND t3.pid=");
            query.append(this.callStartDateID);
            query.append(" LEFT OUTER JOIN contract_parameter_type_6 AS t4");
            query.append(" ON t1.id=t4.cid AND t4.pid=");
            query.append(this.waitStartDateID);
            PreparedStatement ps = con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            this.getLogger().info("Query time " + (System.currentTimeMillis() - time));
            int cid = 0;
            int mode = 0;
            int limit = 0;
            int status = 0;
            Calendar callStart = null;
            Calendar waitStart = null;
            float balance = 0.0f;
            String title = null;
            GregorianCalendar now = new GregorianCalendar();
            while (rs.next()) {
                boolean balanceOk;
                cid = rs.getInt(1);
                mode = rs.getInt(2);
                limit = rs.getInt(3);
                title = rs.getString(4);
                status = rs.getInt(5);
                callStart = TimeUtils.convertDateToCalendar((Date)rs.getDate(6));
                waitStart = TimeUtils.convertDateToCalendar((Date)rs.getDate(7));
                this.getLogger().debug("Processing {}", (Object)title);
                this.getLogger().debug("Status: {}", (Object)status);
                if (status == this.OFF || status == this.TO_OFF || mode == 0) {
                    this.getLogger().debug("Contract is OFF or TO_OFF or credit mode.");
                    continue;
                }
                balance = bu.getBalance(now.getTime(), cid).floatValue();
                boolean bl = balanceOk = balance >= (float)limit;
                if (balanceOk) {
                    this.getLogger().debug("Balance is OK.");
                    this.resetDates(cid);
                    if (status == 0 || status == this.ON) continue;
                    this.getLogger().debug("Seting status to ON");
                    this.changeStatus(cid, this.ON);
                    continue;
                }
                this.getLogger().debug("Balance is NOT OK.");
                if (status == 0 || status == this.ON) {
                    this.getLogger().debug("Setting status to CALL");
                    this.changeStatus(cid, this.CALL);
                    this.changeDateParam(TimeUtils.convertCalendarToSqlDate((Calendar)now), this.callStartDateID, cid);
                    continue;
                }
                if (status == this.CALL) {
                    this.getLogger().debug("Processing in CALL status.");
                    if (callStart == null || !this.callIch.checkInterval(callStart, now)) continue;
                    this.getLogger().debug("Switch to WAIT");
                    this.changeStatus(cid, this.WAIT);
                    this.changeDateParam(TimeUtils.convertCalendarToSqlDate((Calendar)now), this.waitStartDateID, cid);
                    continue;
                }
                if (status != this.WAIT) continue;
                this.getLogger().debug("Processing WAIT status.");
                if (waitStart == null || !this.waitIch.checkInterval(waitStart, now)) continue;
                this.getLogger().debug("Switch TO_OFF");
                this.changeStatus(cid, this.TO_OFF);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            this.error = ex;
        }
    }

    private void changeDateParam(java.sql.Date value, int pid, int cid) throws SQLException {
        this.psUpdateDateParameter.setDate(1, value);
        this.psUpdateDateParameter.setInt(2, pid);
        this.psUpdateDateParameter.setInt(3, cid);
        if (this.psUpdateDateParameter.executeUpdate() == 0) {
            this.psInsertDateParameter.setDate(1, value);
            this.psInsertDateParameter.setInt(2, pid);
            this.psInsertDateParameter.setInt(3, cid);
            this.psInsertDateParameter.executeUpdate();
        }
    }

    private void changeStatus(int cid, int status) throws SQLException {
        this.psUpdateStatus.setInt(1, status);
        this.psUpdateStatus.setInt(2, cid);
        if (this.psUpdateStatus.executeUpdate() == 0) {
            this.psInsertStatus.setInt(1, status);
            this.psInsertStatus.setInt(2, cid);
            this.psInsertStatus.executeUpdate();
        }
        if (status == this.ON) {
            this.resetDates(cid);
        }
    }

    private void resetDates(int cid) {
        this.getLogger().debug("Reset dates..");
        try {
            this.psDeleteDateParameter.setInt(1, this.callStartDateID);
            this.psDeleteDateParameter.setInt(2, cid);
            this.psDeleteDateParameter.executeUpdate();
            this.psDeleteDateParameter.setInt(1, this.waitStartDateID);
            this.psDeleteDateParameter.setInt(2, cid);
            this.psDeleteDateParameter.executeUpdate();
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage());
        }
    }

    class IntervalChecker {
        private static final int DAYS = 1;
        private static final int MONTHS = 2;
        private int col = 0;
        private int type = 0;

        public IntervalChecker(String reference) {
            int size = reference.length();
            StringBuffer numberPart = new StringBuffer();
            StringBuffer charPart = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                char ch = reference.charAt(i);
                if (Character.isDigit(ch)) {
                    numberPart.append(ch);
                    continue;
                }
                charPart.append(ch);
            }
            this.col = Utils.parseInt((String)numberPart.toString(), (int)0);
            String typeDef = charPart.toString().trim();
            if (typeDef.equals("d")) {
                this.type = 1;
            } else if (typeDef.equals("m")) {
                this.type = 2;
            } else {
                ContractMonitor.this.getLogger().error("Incorrect interval type: " + typeDef + " must be d or m ");
            }
        }

        public boolean checkInterval(Calendar fromTime, Calendar toTime) {
            int delta = 0;
            switch (this.type) {
                case 1: {
                    delta = TimeUtils.daysDelta((Calendar)fromTime, (Calendar)toTime);
                    break;
                }
                case 2: {
                    delta = TimeUtils.monthsDelta((Calendar)fromTime, (Calendar)toTime);
                }
            }
            return delta >= this.col;
        }
    }
}

