/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.script.bean;

import bitel.billing.server.script.bean.FunctionManager;
import bsh.EvalError;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.script.common.ScriptFunctionModifiedEvent;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptInstance;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptLibraryManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.logging.BGNestedContext;

@Deprecated
public class ScriptMachineManager {
    private static final Logger logger = LogManager.getLogger();
    private static ScriptMachineManager manager;
    private ConcurrentHashMap<String, ScriptInstance> scriptLibraryCache = new ConcurrentHashMap();

    public static ScriptMachineManager getManager() {
        if (manager == null) {
            try {
                manager = new ScriptMachineManager();
            }
            catch (Throwable e) {
                manager = new ScriptMachineManager();
            }
        }
        return manager;
    }

    private ScriptMachineManager() {
        try {
            EventProcessor.getInstance().addListener(new EventListener<ScriptFunctionModifiedEvent>(){

                @Override
                public void notify(ScriptFunctionModifiedEvent e, EventListenerContext ctx) {
                    BGNestedContext.push((String)"script");
                    logger.info("Script event function  was modified. Flush function cache...");
                    ScriptMachineManager.this.flushCache();
                    BGNestedContext.pop();
                }
            }, ScriptFunctionModifiedEvent.class);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void flushCache() {
        this.scriptLibraryCache.clear();
        FunctionManager.resetFunctionCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptInstance getScriptForLibrary(String name) {
        ScriptInstance result = this.scriptLibraryCache.get(name);
        if (result == null) {
            Connection con = Setup.getSetup().getDBConnectionFromPool();
            try {
                ScriptInstance newResult = new ScriptInstance(new ScriptLibraryManager(con).getByName(name));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                PrintStream outPrintStream = new PrintStream(out);
                PrintStream errPrintStream = new PrintStream(err);
                newResult.eval(outPrintStream, errPrintStream, null);
                result = this.scriptLibraryCache.putIfAbsent(name, newResult);
                if (result == null) {
                    result = newResult;
                }
            }
            catch (BGException e) {
                logger.error("library \"" + name + "\" error", (Throwable)e);
            }
            catch (EvalError e) {
                logger.error("library \"" + name + "\" eval error", (Throwable)e);
            }
            finally {
                ServerUtils.closeConnection(con);
            }
        }
        return result;
    }
}

