/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util.captcha;

import bitel.billing.server.util.Config;
import com.jhlabs.image.MarbleFilter;
import com.jhlabs.image.RippleFilter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Random;
import javax.imageio.ImageIO;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class Captcha {
    private static final Random random;
    private static final SecureRandom secureRandom;
    private static final Font[] fonts;
    private static final char[] symbols;
    private static final char[] digits;
    private static final Color[] colors;

    private static BufferedImage render(String text) {
        Conf conf = Setup.getSetup().getConfig(0, Conf.class);
        BufferedImage result = Captcha.renderText(text, 0, 0, conf.lines, conf.rotate);
        if (conf.marble) {
            MarbleFilter marble = new MarbleFilter();
            marble.setAmount(conf.marbleAmout);
            marble.setTurbulence(conf.marbleTurbulence);
            result = marble.filter(result, null);
        }
        if (conf.ripple) {
            RippleFilter ripple = new RippleFilter();
            ripple.setWaveType(3);
            ripple.xAmplitude = conf.rippleXAmplitude;
            ripple.yAmplitude = conf.rippleYAmplitude;
            ripple.xWavelength = conf.rippleXWavelength;
            ripple.yWavelength = conf.rippleYWavelength;
            result = ripple.filter(result, null);
        }
        BufferedImage result2 = new BufferedImage(150, 45, 6);
        Graphics2D gfx = result2.createGraphics();
        gfx.drawImage(result, 0, 0, 150, 45, 35, 10, 195, 55, null);
        result = result2;
        return result;
    }

    private static BufferedImage renderText(String text, int width, int height, int lines, boolean rotate) {
        width = 200;
        height = 60;
        BufferedImage result = new BufferedImage(width, height, 6);
        Graphics2D gfx = result.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        gfx.setRenderingHints(hints);
        gfx.setBackground(Color.WHITE);
        gfx.clearRect(0, 0, width, height);
        Color clr = colors[random.nextInt(colors.length)];
        gfx.setColor(new Color(Math.min(255, clr.getRed() + 5), Math.min(255, clr.getGreen() + 5), Math.min(255, clr.getBlue() + 5)));
        block3: for (int i = random.nextInt(lines - 1) + 1; i >= 0; --i) {
            switch (random.nextInt(2)) {
                case 1: {
                    gfx.drawLine(random.nextInt(width / 4) + 10, random.nextInt(height - 20) + 10, random.nextInt(width / 4) + width - width / 4 - 10, random.nextInt(height - 20) + 10);
                    continue block3;
                }
                default: {
                    gfx.drawLine(random.nextInt(width - 20) + 10, random.nextInt(height - 20) + 10, random.nextInt(width - 20) + 10, random.nextInt(height - 20) + 10);
                }
            }
        }
        gfx.setColor(clr);
        char[] wc = text.toCharArray();
        FontRenderContext frc = gfx.getFontRenderContext();
        int startPosX = 40;
        AffineTransform oldTransform = gfx.getTransform();
        for (int i = 0; i < wc.length; ++i) {
            char[] itchar = new char[]{wc[i]};
            int choiceFont = random.nextInt(fonts.length);
            Font itFont = fonts[choiceFont];
            gfx.setFont(itFont);
            GlyphVector gv = itFont.createGlyphVector(frc, itchar);
            if (rotate) {
                AffineTransform tx = new AffineTransform();
                tx.rotate((double)(random.nextInt(9) - 4) / 10.0, (double)startPosX + gv.getVisualBounds().getCenterX(), 45.0 + gv.getVisualBounds().getCenterY());
                gfx.setTransform(tx);
            }
            gfx.drawChars(itchar, 0, itchar.length, startPosX, 45);
            startPosX = startPosX + (int)gv.getVisualBounds().getWidth() + 6;
        }
        gfx.setTransform(oldTransform);
        return result;
    }

    public static void captcha(HttpServletRequest request, HttpServletResponse response, HttpSession session, boolean save) {
        Captcha.captcha(request, response, session, save, false);
    }

    public static void captcha(HttpServletRequest request, HttpServletResponse response, HttpSession session, boolean save, boolean onlyDigits) {
        byte[] arr = null;
        if (save) {
            arr = (byte[])session.getAttribute("bitel.billing.util.captcha.Capthca.image");
        }
        char[] key = onlyDigits || Boolean.TRUE.equals(request.getSession().getAttribute("bitel.billing.util.captcha.Capthca.onlyDigits")) ? digits : symbols;
        try {
            ServletOutputStream out = response.getOutputStream();
            if (arr == null) {
                StringBuilder sb = new StringBuilder(6);
                for (int i = 0; i < 6; ++i) {
                    sb.append(key[secureRandom.nextInt(key.length)]);
                }
                String result = sb.toString();
                ByteArrayOutputStream bos = new ByteArrayOutputStream(4000);
                ImageIO.write((RenderedImage)Captcha.render(result), "png", bos);
                arr = bos.toByteArray();
                session.setAttribute("bitel.billing.util.captcha.Capthca", (Object)result);
                session.setAttribute("bitel.billing.util.captcha.Capthca.path", (Object)request.getPathInfo());
                session.setAttribute("bitel.billing.util.captcha.Capthca.action", (Object)request.getParameter("action"));
                if (save) {
                    session.setAttribute("bitel.billing.util.captcha.Capthca.image", new SoftReference<byte[]>(arr));
                }
            }
            request.setAttribute("contentType", (Object)"stream");
            response.setContentType("image/png");
            out.write(arr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean validate(String captcha, HttpSession session) {
        boolean result = false;
        if (session != null && Utils.notEmptyString((String)captcha)) {
            String savedCapthca = (String)session.getAttribute("bitel.billing.util.captcha.Capthca");
            result = savedCapthca != null && captcha.equalsIgnoreCase(savedCapthca);
            session.removeAttribute("bitel.billing.util.captcha.Capthca");
            session.removeAttribute("bitel.billing.util.captcha.Capthca.path");
            session.removeAttribute("bitel.billing.util.captcha.Capthca.action");
            session.removeAttribute("bitel.billing.util.captcha.Capthca.image");
            session.removeAttribute("bitel.billing.util.captcha.Capthca.onlyDigits");
        }
        return result;
    }

    public static boolean validate(String captcha, HttpServletRequest request, HttpSession session) {
        boolean result = false;
        if (session != null && Utils.notEmptyString((String)captcha)) {
            String savedCapthca = (String)session.getAttribute("bitel.billing.util.captcha.Capthca");
            result = savedCapthca != null && captcha.equalsIgnoreCase(savedCapthca);
            String path = (String)session.getAttribute("bitel.billing.util.captcha.Capthca.path");
            String action = (String)session.getAttribute("bitel.billing.util.captcha.Capthca.action");
            String path2 = request.getPathInfo();
            String action2 = request.getParameter("action");
            result = path == null ? (result &= path2 == null) : (result &= path.equals(path2));
            result = action == null ? (result &= action2 == null) : (result &= action.equals(action2));
            session.removeAttribute("bitel.billing.util.captcha.Capthca");
            session.removeAttribute("bitel.billing.util.captcha.Capthca.path");
            session.removeAttribute("bitel.billing.util.captcha.Capthca.action");
            session.removeAttribute("bitel.billing.util.captcha.Capthca.image");
            session.removeAttribute("bitel.billing.util.captcha.Capthca.onlyDigits");
        }
        return result;
    }

    static {
        Font[] _fonts;
        random = new Random();
        secureRandom = new SecureRandom();
        try {
            ArrayList<Font> fontList = new ArrayList<Font>();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (String s : ge.getAvailableFontFamilyNames()) {
                if ("Verdana".equalsIgnoreCase(s)) {
                    fontList.add(new Font("Verdana", 0, 30));
                    fontList.add(new Font("Verdana", 0, 26));
                } else if ("Courier".equalsIgnoreCase(s)) {
                    fontList.add(new Font("Courier", 1, 30));
                } else if ("Arial".equalsIgnoreCase(s)) {
                    fontList.add(new Font("Arial", 1, 30));
                } else if ("Lucida Sans Typewriter".equalsIgnoreCase(s)) {
                    new Font("Lucida Sans Typewriter", 0, 30);
                } else if ("Lucida Bright".equalsIgnoreCase(s)) {
                    new Font("Lucida Bright", 2, 30);
                } else if ("SansSerif".equalsIgnoreCase(s)) {
                    new Font("SansSerif", 0, 30);
                } else if ("Times New Roman".equalsIgnoreCase(s)) {
                    new Font("Times New Roman", 0, 30);
                } else if ("DejaVu LGC Sans".equalsIgnoreCase(s)) {
                    new Font("DejaVu LGC Sans", 0, 30);
                } else if ("DejaVu LGC Serif".equalsIgnoreCase(s)) {
                    new Font("DejaVu LGC Serif", 0, 30);
                }
                fontList.add(new Font("Dialog", 0, 30));
                fontList.add(new Font("Dialog", 0, 26));
            }
            _fonts = fontList.toArray(new Font[fontList.size()]);
        }
        catch (Throwable e) {
            _fonts = new Font[]{new Font("Arial", 1, 30), new Font("Courier", 1, 30), new Font("LucidaTypewriterBold", 0, 30), new Font("LucidaBrightItalic", 2, 30)};
            e.printStackTrace();
        }
        fonts = _fonts;
        symbols = new char[]{'0', '1', '2', '3', '4', '6', '7', '8', '9', 'A', 'B', 'C', 'E', 'F', 'K', 'L', 'M', 'N', 'P', 'R', 'T', 'U', 'X', 'H', 'W', 'Y', 'V'};
        digits = new char[]{'0', '1', '2', '3', '4', '6', '7', '8', '9'};
        colors = new Color[]{Color.red, new Color(0, 200, 0), Color.magenta, Color.orange};
    }

    private static class Conf
    extends Config {
        private final boolean marble;
        private final float marbleAmout;
        private final float marbleTurbulence;
        private final boolean ripple;
        private final float rippleXAmplitude;
        private final float rippleYAmplitude;
        private final float rippleXWavelength;
        private final float rippleYWavelength;
        private final boolean rotate;
        private final int lines;

        public Conf(int mid, ParameterMap moduleSetup, Setup serverSetup) {
            super(mid, moduleSetup, serverSetup);
            this.marble = serverSetup.getInt("captcha.marble", 1) > 0;
            this.ripple = serverSetup.getInt("captcha.ripple", 1) > 0;
            this.rotate = serverSetup.getInt("captcha.rotate", 1) > 0;
            this.marbleAmout = serverSetup.getFloat("captcha.marble.amount", 1.0f);
            this.marbleTurbulence = serverSetup.getFloat("captcha.marble.turbulence", 0.1f);
            this.rippleXAmplitude = serverSetup.getFloat("captcha.ripple.xamplitude", 6.0f);
            this.rippleYAmplitude = serverSetup.getFloat("captcha.ripple.yamplitude", 1.3f);
            this.rippleXWavelength = serverSetup.getFloat("captcha.ripple.xwavelength", 32.0f);
            this.rippleYWavelength = serverSetup.getFloat("captcha.ripple.ywavelength", 32.0f);
            this.lines = serverSetup.getInt("captcha.lines", 5);
        }
    }
}

