/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.RadioButtonTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.MenuItem;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.common.client.table.BGTableModel;

public class MenuPanel
extends BGUPanel {
    private ClientContext context;
    private int selectedId = -1;
    private UserService userService;
    private UserMenuTableModel userMenuTableModel = new UserMenuTableModel();
    private UserMenuTable userMenuTable = new UserMenuTable(this.userMenuTableModel);

    public MenuPanel() {
    }

    public MenuPanel(ClientContext context) {
        this.context = context;
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)((Object)this.userMenuTable)), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setData() {
        try {
            this.userMenuTableModel.setData(this.getUserService().userMenuList(true));
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private UserService getUserService() {
        if (this.userService == null) {
            this.userService = this.context == null ? (UserService)((ClientContext)this.getContext()).getPort(UserService.class) : (UserService)this.context.getPort(UserService.class);
        }
        return this.userService;
    }

    public void setSelected(int selectedId) {
        this.selectedId = selectedId;
    }

    public int getSelectedId() {
        return this.selectedId;
    }

    class UserMenuTableModel
    extends BGTableModel<MenuItem> {
        public UserMenuTableModel() {
            super(UserMenuTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("V", 50, 50, 50, "selected", false, (TableCellRenderer)new RadioButtonTableCellRenderer());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(MenuItem val, int column) throws BGException {
            String i = this.getIdentifier(column);
            if ("selected".equals(i)) {
                return val.getId() == MenuPanel.this.selectedId;
            }
            return super.getValue((Object)val, column);
        }
    }

    class UserMenuTable
    extends BGUTable {
        public UserMenuTable(final UserMenuTableModel model) {
            super((TableModel)((Object)model));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    int col;
                    super.mouseClicked(event);
                    if (UserMenuTable.this.isEnabled() && event.getClickCount() > 1 && (col = UserMenuTable.this.getSelectedColumn()) == 1) {
                        MenuPanel.this.selectedId = ((MenuItem)((Object)model.getSelectedRow())).getId();
                        MenuPanel.this.userMenuTableModel.fireTableDataChanged();
                    }
                }
            });
        }
    }
}

