/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractNoteDao
extends AbstractIdDao<ContractNote> {
    public ContractNoteDao(Connection con) {
        super(con, 0, "contract_comment");
    }

    protected ContractNote getFromRS(ResultSet rs) throws SQLException, BGException {
        return ContractNote.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setDateTime(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("dt"))).setUserId(rs.getInt("uid")).setTitle(rs.getString("subject")).setComment(rs.getString("comment")).setVisible(rs.getBoolean("visibled")).build();
    }

    protected void updateImpl(ContractNote note) throws BGException, SQLException {
        boolean update = note.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET subject=?, comment=?, uid=?, visibled=?, dt=?, cid=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, note.getTitle());
            ps.setString(index++, note.getComment());
            ps.setInt(index++, note.getUserId());
            ps.setBoolean(index++, note.isVisible());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)(note.getDateTime() == null ? LocalDateTime.now() : note.getDateTime())));
            ps.setInt(index++, note.getContractId());
            if (update) {
                ps.setInt(index++, note.getId());
            }
            ps.executeUpdate();
            if (!update) {
                note.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    public List<ContractNote> list(int contractId, boolean onlyForCustomer) throws BGException {
        return this.list("cid=? " + (onlyForCustomer ? " AND visibled=true" : ""), "dt DESC", new Object[]{contractId});
    }
}

