/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.base.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Optional;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractNoteService;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractSubPanel;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.table.BGTableModel;

public class ContractSubPanel_Note
extends ContractSubPanel {
    private ContractNote contractNote = null;
    private JPanel editPanel = new JPanel();
    private JCheckBox userVisible = new JCheckBox();
    private JTextArea noteComment = new JTextArea();
    private JSplitPane jSplitPane = new JSplitPane();
    private JTextField noteSubject = new JTextField();
    private ContractNoteService contractNoteService = null;
    private TableModel tableModel = new TableModel(TableModel.class.getName());
    protected BGUTable itemsTable = new BGUTable((javax.swing.table.TableModel)((Object)this.tableModel));
    private BGButtonPanelRestoreOkCancelHelp okCancelPanel = new BGButtonPanelRestoreOkCancelHelp();

    public ContractSubPanel_Note() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.itemsTable.setSelectionMode(0);
        this.itemsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    ContractSubPanel_Note.this.editItem();
                }
            }
        });
        this.okCancelPanel.addActionListener(e -> this.BGControlPanel_102_actionPerformed(e));
    }

    private void jbInit() throws Exception {
        this.userVisible.setText("\u043f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e");
        this.editPanel.setLayout(new GridBagLayout());
        this.editPanel.setVisible(false);
        this.editPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editPanel.add((Component)this.getSubjectPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.editPanel.add((Component)this.getCommentPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editPanel.add((Component)this.userVisible, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.editPanel.add((Component)this.okCancelPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setAutoscrolls(false);
        this.jSplitPane.setBorder(null);
        this.jSplitPane.setDividerSize(0);
        this.jSplitPane.add((Component)new JScrollPane((Component)this.itemsTable), "left");
        this.jSplitPane.add((Component)this.editPanel, "right");
        this.jSplitPane.setDividerLocation(100);
        this.setLayout(new GridBagLayout());
        this.add(this.jSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getSubjectPanel() {
        this.noteSubject.setMinimumSize(new Dimension(4, 24));
        this.noteSubject.setPreferredSize(new Dimension(4, 24));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0422\u0435\u043c\u0430 "));
        panel.add((Component)this.noteSubject, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getCommentPanel() {
        this.noteComment.setMargin(new Insets(3, 3, 3, 3));
        this.noteComment.setWrapStyleWord(true);
        this.noteComment.setLineWrap(true);
        this.noteComment.setRows(5);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0422\u0435\u043a\u0441\u0442 "));
        panel.add((Component)new JScrollPane(this.noteComment), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    public void setData() {
        try {
            this.tableModel.setData(this.getContractNoteService().contractNoteList(this.getContractId(), false));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void newItem() {
        this.contractNote = ContractNote.builder().setContractId(this.getContractId()).build();
        this.noteComment.setText("");
        this.noteSubject.setText("");
        this.userVisible.setSelected(false);
        this.editPanel.setVisible(true);
        this.jSplitPane.setDividerLocation(150);
        this.jSplitPane.setDividerSize(5);
    }

    public void editItem() {
        this.contractNote = (ContractNote)((Object)this.tableModel.getSelectedRow());
        if (this.contractNote != null) {
            try {
                this.contractNote = this.getContractNoteService().contractNoteGet(this.getContractId(), this.contractNote.getId());
                this.contractNote.setDateTime(null);
                this.noteSubject.setText(this.contractNote.getTitle());
                this.noteComment.setText(this.contractNote.getComment());
                this.userVisible.setSelected(this.contractNote.isVisible());
                this.editPanel.setVisible(true);
                this.jSplitPane.setDividerLocation(150);
                this.jSplitPane.setDividerSize(5);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    public void deleteItem() {
        if (!this.editPanel.isVisible()) {
            this.tableModel.optSelectedRow().ifPresent(c -> {
                if (ClientUtils.confirmDelete((Object)"\u043f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435")) {
                    try {
                        this.getContractNoteService().contractNoteDelete(this.getContractId(), c.getId());
                        this.setData();
                        EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            });
        }
    }

    private void BGControlPanel_102_actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.noteComment.setText("");
            this.noteSubject.setText("");
            this.userVisible.setSelected(false);
        } else if ("ok".equals(actionCommand)) {
            this.contractNote.setTitle(this.noteSubject.getText().trim());
            this.contractNote.setComment(this.noteComment.getText().trim());
            this.contractNote.setVisible(this.userVisible.isSelected());
            try {
                this.getContractNoteService().contractNoteUpdate(this.getContractId(), this.contractNote);
                this.jSplitPane.setDividerSize(0);
                this.editPanel.setVisible(false);
                this.setData();
                EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        } else if ("cancel".equals(actionCommand)) {
            this.jSplitPane.setDividerSize(0);
            this.editPanel.setVisible(false);
        }
    }

    private ContractNoteService getContractNoteService() {
        if (this.contractNoteService == null) {
            this.contractNoteService = (ContractNoteService)this.getContext().getPort(ContractNoteService.class);
        }
        return this.contractNoteService;
    }

    public class TableModel
    extends BGTableModel<ContractNote> {
        Directory<UserInfo> userInfoDirectory;

        public TableModel(String name) {
            super(name);
            this.userInfoDirectory = null;
            try {
                this.userInfoDirectory = ContractSubPanel_Note.this.getContext().getDirectory(UserInfo.class, 0);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        protected void initColumns() {
            this.addColumn("\u0422\u0435\u043c\u0430", 150, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("V", 30, 30, 30, "visible", true);
            this.addColumn("\u0414\u0430\u0442\u0430", 100, 150, 200, "dateTime", true, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 150, 170, 200, "userId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(ContractNote contractNote, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("userId".equals(identifier)) {
                return Optional.ofNullable(this.userInfoDirectory.get(contractNote.getUserId())).map(UserInfo::getName).orElse("??? [ID#" + contractNote.getUserId() + "]");
            }
            return super.getValue((Object)contractNote, column);
        }
    }
}

