/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.period.server.service;

import jakarta.jws.WebService;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.period.common.bean.ContractPeriod;
import ru.bitel.bgbilling.kernel.contract.period.common.service.ContractPeriodService;
import ru.bitel.bgbilling.kernel.contract.period.server.bean.ContractPeriodCloseEventJob;
import ru.bitel.bgbilling.kernel.contract.period.server.bean.ContractPeriodDao;
import ru.bitel.bgbilling.kernel.contract.period.server.event.ContractPeriodDeleteEvent;
import ru.bitel.bgbilling.kernel.contract.period.server.event.ContractPeriodUpdateEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.job.server.JobScheduler;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.period.common.service.ContractPeriodService")
public class ContractPeriodServiceImpl
extends AbstractService
implements ContractPeriodService {
    private static final String KEY_CLOSE_JOB_ENABLE = "contract.period.job.close.event.enable";
    private Setup setup = Setup.getSetup();

    @Override
    public SearchResult<ContractPeriod> contractPeriodSearch(int contractId, String[] sort, Page page) throws BGException, BGMessageException {
        SearchResult searchResult = new SearchResult();
        searchResult.setSort(sort);
        searchResult.setPage(page);
        try (ContractPeriodDao contractPeriodDao = new ContractPeriodDao(this.getConnection());){
            contractPeriodDao.searchContractPeriod((SearchResult<ContractPeriod>)searchResult, contractId);
        }
        return searchResult;
    }

    @Override
    public ContractPeriod contractPeriodGet(int id) throws BGException, BGMessageException {
        try (ContractPeriodDao contractPeriodDao = new ContractPeriodDao(this.getConnection());){
            ContractPeriod contractPeriod = (ContractPeriod)contractPeriodDao.get(id);
            return contractPeriod;
        }
    }

    @Override
    public ContractPeriod contractPeriodUpdate(ContractPeriod contractPeriod) throws BGException, BGMessageException {
        Objects.requireNonNull(contractPeriod);
        try (ContractPeriodDao contractPeriodDao = new ContractPeriodDao(this.getConnection());){
            ContractPeriod oldContractPeriod = contractPeriod.getId() < 1 ? null : (ContractPeriod)contractPeriodDao.get(contractPeriod.getId());
            contractPeriod.setUserId(this.userId);
            contractPeriodDao.update((Object)contractPeriod);
            EventProcessor.getInstance().publish(new ContractPeriodUpdateEvent(oldContractPeriod, contractPeriod, contractPeriod.getContractId(), this.userId));
            if (this.setup.getBoolean(KEY_CLOSE_JOB_ENABLE, false)) {
                long jobId;
                boolean dateToChange;
                LocalDateTime oldTo = oldContractPeriod == null ? null : oldContractPeriod.getPeriod().getLocalDateTimeTo();
                LocalDateTime newTo = contractPeriod.getPeriod().getLocalDateTimeTo();
                boolean bl = dateToChange = oldTo == null || newTo != null || oldTo != null && newTo != null && !oldTo.isEqual(newTo);
                if ((!contractPeriod.isGenerateCloseEvent() || dateToChange) && (jobId = oldContractPeriod.getJobId()) > 0L) {
                    JobScheduler.getInstance("contract_period", 0).cancel(jobId);
                }
                if (contractPeriod.isGenerateCloseEvent() && dateToChange) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("contractPeriodId", String.valueOf(contractPeriod.getId()));
                    long jobId2 = JobScheduler.getInstance("contract_period", 0).schedule(ContractPeriodCloseEventJob.class, (ParameterMap)new ParameterMap.DefaultParameterMap(params), contractPeriod.getPeriod().getDateTo());
                    contractPeriod.setJobId(jobId2);
                    contractPeriodDao.update((Object)contractPeriod);
                }
            }
        }
        return contractPeriod;
    }

    @Override
    public boolean contractPeriodDelete(int id) throws BGException, BGMessageException {
        try (ContractPeriodDao contractPeriodDao = new ContractPeriodDao(this.getConnection());){
            boolean result;
            long jobId;
            ContractPeriod oldContractPeriod = (ContractPeriod)contractPeriodDao.get(id);
            if (this.setup.getBoolean(KEY_CLOSE_JOB_ENABLE, false) && oldContractPeriod != null && (jobId = oldContractPeriod.getJobId()) > 0L) {
                JobScheduler.getInstance("contract_period", 0).cancel(jobId);
            }
            boolean bl = result = contractPeriodDao.delete(id) > 0;
            if (result) {
                EventProcessor.getInstance().publish(new ContractPeriodDeleteEvent(oldContractPeriod, this.userId));
            }
            boolean bl2 = result;
            return bl2;
        }
    }
}

