/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.client.account;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.RadioButtonTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerAccount;
import ru.bitel.bgbilling.kernel.customer.common.service.CustomerService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class CustomerAccountDialog {
    private int accountLength = 8;
    private long newCustomerAccount = 0L;
    private BGOptionPane optionPane;
    private ClientContext clientContext;
    private AccountTableModel accountTableModel = new AccountTableModel();
    private BGUTable table = new BGUTable((TableModel)((Object)this.accountTableModel));
    private JButton saveButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");

    public CustomerAccountDialog(ClientContext clientContext) {
        this.clientContext = clientContext;
        this.newCustomerAccount = clientContext.getCustomerAccount();
        this.accountLength = ClientSetup.getInstance().getInt("dbinfo.customer.account.length", this.accountLength);
        JButton cancelButton = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        this.optionPane = new BGOptionPane((Object)this.getPanel(), "\u041b\u0438\u0446\u0435\u0432\u043e\u0439 \u0441\u0447\u0435\u0442", new JButton[]{this.saveButton, cancelButton});
        this.saveButton.addActionListener(e -> {
            if (clientContext.getCustomerAccount() != this.newCustomerAccount) {
                this.setCustomerAccount();
            }
            this.getDialog().setVisible(false);
        });
        cancelButton.addActionListener(e -> this.getDialog().setVisible(false));
        this.getDialog().setVisible(true);
        this.getDialog().dispose();
    }

    private JPanel getPanel() {
        this.table.setRowHeight(18);
        this.table.setFont(this.table.getFont().deriveFont(1.1f * this.table.getFont().getSize2D()));
        this.table.setSelectionMode(0);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CustomerAccount customerAccount;
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && CustomerAccountDialog.this.table.convertColumnIndexToModel(CustomerAccountDialog.this.table.getSelectedColumn()) == 0 && (customerAccount = (CustomerAccount)CustomerAccountDialog.this.accountTableModel.getSelectedRow()) != null) {
                    CustomerAccountDialog.this.newCustomerAccount = customerAccount.getAccount();
                    CustomerAccountDialog.this.accountTableModel.fireTableDataChanged();
                }
            }
        });
        this.loadAccounts();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.table, (int)400, (int)200), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 5, 0), 0, 0));
        return panel;
    }

    private JPanel getButtonPanel() {
        JButton addAccountButton = new JButton(ClientUtils.getIcon((String)"add"));
        addAccountButton.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u043b\u0438\u0446\u0435\u0432\u043e\u0439 \u0441\u0447\u0435\u0442");
        addAccountButton.addActionListener(e -> {
            try {
                Account account = new Account();
                AddAccountDialog dialog = new AddAccountDialog("\u041d\u043e\u0432\u044b\u0439 \u0441\u0447\u0435\u0442", account);
                dialog.open();
                if (dialog.getData() != null) {
                    ((CustomerService)this.clientContext.getWebService(CustomerService.class, 0)).customerAccountAdd(this.clientContext.getCustomerId(), account.account);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.loadAccounts();
        });
        JButton removeAccountButton = new JButton(ClientUtils.getIcon((String)"delete"));
        removeAccountButton.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043b\u0438\u0446\u0435\u0432\u043e\u0439 \u0441\u0447\u0435\u0442");
        removeAccountButton.addActionListener(e -> {
            CustomerAccount customerAccount = (CustomerAccount)this.accountTableModel.getSelectedRow();
            if (customerAccount == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (customerAccount.getContractCount() > 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e. \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f");
                return;
            }
            if (ClientUtils.confirmDelete((Object)customerAccount.getAccount())) {
                try {
                    ((CustomerService)this.clientContext.getWebService(CustomerService.class, 0)).customerAccountDelete(this.clientContext.getCustomerId(), customerAccount.getAccount());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
                this.loadAccounts();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)addAccountButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)removeAccountButton, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JDialog getDialog() {
        return this.optionPane.getDialog();
    }

    private void loadAccounts() {
        try {
            this.accountTableModel.setData(((CustomerService)this.clientContext.getWebService(CustomerService.class, 0)).customerAccounts(this.clientContext.getCustomerId()));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void setCustomerAccount() {
        try {
            ((CustomerService)this.clientContext.getWebService(CustomerService.class, 0)).customerAccountSet(this.clientContext.getCustomerId(), this.clientContext.getContractId(), this.newCustomerAccount);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public class AccountTableModel
    extends BGTableModel<CustomerAccount> {
        private DecimalFormat decimalFormat;

        public AccountTableModel() {
            super(AccountTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("[X]", 30, 30, 30, "active", true, (TableCellRenderer)new RadioButtonTableCellRenderer());
            this.addColumn("\u041b\u0438\u0446\u0435\u0432\u043e\u0439 \u0441\u0447\u0435\u0442", 100, 200, -1, "account", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", 120, 120, 120, "contractCount", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
        }

        public Object getValueAt(CustomerAccount val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("active".equals(identifier)) {
                return CustomerAccountDialog.this.newCustomerAccount == val.getAccount();
            }
            if ("account".equals(identifier)) {
                return val.getAccount() > 0L ? this.getDecimalFormat().format(val.getAccount()) : "#".repeat(CustomerAccountDialog.this.accountLength);
            }
            return super.getValueAt((Object)val, column);
        }

        private DecimalFormat getDecimalFormat() {
            if (this.decimalFormat == null) {
                this.decimalFormat = new DecimalFormat("0".repeat(CustomerAccountDialog.this.accountLength));
            }
            return this.decimalFormat;
        }
    }

    class Account {
        long account = 0L;

        Account() {
        }
    }

    public class AddAccountDialog
    extends BGEditorDialog<Account> {
        private ButtonGroup buttonGroup;
        private JRadioButton autoAccount;
        private JRadioButton manualAccount;
        private JTextField account;

        public AddAccountDialog(String title, Account data) {
            super(title, (Object)data);
            this.buttonGroup = new ButtonGroup();
            this.autoAccount = new JRadioButton("\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c", true);
            this.manualAccount = new JRadioButton("\u0432\u0432\u0435\u0441\u0442\u0438 \u0432\u0440\u0443\u0447\u043d\u0443\u044e");
            this.account = new JTextField(25);
        }

        public void doDialogPanel() {
            this.autoAccount.setActionCommand("auto");
            this.buttonGroup.add(this.autoAccount);
            this.manualAccount.setActionCommand("manual");
            this.buttonGroup.add(this.manualAccount);
            this.account.setHorizontalAlignment(0);
            this.panel.add((Component)this.autoAccount, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.manualAccount, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.account, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean doApply() throws Exception {
            if ("manual".equals(this.buttonGroup.getSelection().getActionCommand())) {
                if (this.account.getText().matches("^\\d{1," + CustomerAccountDialog.this.accountLength + "}$")) {
                    ((Account)this.data).account = Utils.parseLong((String)this.account.getText());
                } else {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0441\u0447\u0435\u0442\u0430");
                    return false;
                }
            }
            return true;
        }

        public void doCancel() {
            this.data = null;
        }
    }
}

