/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import jakarta.xml.bind.JAXBException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.event.AbstractConsumer;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.common.worker.ThreadContext;

final class AcknowledgeConsumer
extends AbstractConsumer
implements MessageListener {
    private static final Logger logger = LogManager.getLogger();

    public AcknowledgeConsumer(EventProcessor eventProcessor, Session session, Class<? extends Event> clazz, EventType type, int moduleId, int pluginId, String destination, String query, boolean setMessageListener, boolean localSession) throws JMSException, JAXBException {
        super(eventProcessor, session, clazz, type, moduleId, pluginId, destination, query, setMessageListener, localSession);
    }

    public AcknowledgeConsumer(EventProcessor eventProcessor, Session session, int moduleId, int pluginId, String destination, String query, boolean queue, boolean noLocal, int deliveryMode, int priority, long timeToLive, boolean localSession, Class<?> ... clazz) throws JMSException, JAXBException {
        super(eventProcessor, session, moduleId, pluginId, destination, query, queue, noLocal, deliveryMode, priority, timeToLive, localSession, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        ThreadContext parentContext = ThreadContext.get();
        try {
            ThreadContext.set((ThreadContext)this.eventListenerContext);
            this.onMessage0(message, this.eventListenerContext, this);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (parentContext != null) {
                ThreadContext.set((ThreadContext)parentContext);
            }
            this.eventListenerContext.recycle();
        }
    }

    @Override
    protected boolean onMessage0(Message message, EventListenerContext ctx, EventListener<Event> listener) {
        try {
            Event e = (Event)this.parseMessage(message);
            e.setMessageID(message.getJMSMessageID());
            if (logger.isDebugEnabled()) {
                logger.debug("Caught " + message.getStringProperty("bg:app") + ":" + e);
            }
            listener.notify(e, ctx);
            ctx.commit();
            message.acknowledge();
            this.trySendReply(message, e, null);
            return true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            try {
                this.session.recover();
            }
            catch (JMSException ex2) {
                logger.error(ex2.getMessage(), (Throwable)ex2);
            }
            return false;
        }
    }
}

