/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.publish.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.publish.common.bean.MQServer;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class MQServerDao
extends AbstractIdDao<MQServer> {
    public MQServerDao(Connection con) {
        super(con, 0, "publish_event_server");
    }

    public SearchResult<MQServer> searchMQServerList(Page page) throws BGException {
        SearchResult searchResult = new SearchResult(page);
        searchResult.setList(this.list("", "title", new Object[0]));
        return searchResult;
    }

    protected MQServer getFromRS(ResultSet rs) throws SQLException, BGException {
        MQServer mqServer = new MQServer();
        mqServer.setId(rs.getInt("id"));
        mqServer.setTitle(rs.getString("title"));
        String data = rs.getString("data");
        if (data == null || data.isEmpty()) {
            data = "{}";
        }
        mqServer.setData(data);
        return mqServer;
    }

    protected void updateImpl(MQServer mqServer) throws BGException, SQLException {
        if (mqServer == null) {
            throw new BGException("mqServer is null!!!");
        }
        boolean insert = mqServer.getId() <= 0;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET title=?, data=?" + (insert ? "" : " WHERE id=?");
        PreparedStatement ps = this.con.prepareStatement(query, 1);
        JSONObject jsonObject = mqServer.toJson();
        int index = 1;
        ps.setString(index++, mqServer.getTitle());
        ps.setString(index++, jsonObject.toString());
        if (!insert) {
            ps.setInt(index++, mqServer.getId());
        }
        ps.executeUpdate();
        if (insert) {
            mqServer.setId(ServerUtils.lastInsertId(this.con));
        }
        ps.close();
    }
}

