/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.task;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.TimerEvent;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TimerEventGenerator
extends TaskBase {
    private int flag = 0;
    private String cids;
    private String gids;

    @Override
    public String getDescription() {
        return this.defaultDescription + "\u0417\u0430\u0434\u0430\u0447\u0430 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u043f\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0443. \u041a\u043e\u0434\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: " + this.cids + ". \u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: " + this.gids + ". \u0424\u043b\u0430\u0433: " + this.flag + ".";
    }

    @Override
    protected boolean initTask() {
        this.flag = this.taskSetup.getInt("flag", -1);
        if (this.flag <= 0) {
            this.getLogger().error("Param flag not defined!");
            return false;
        }
        this.cids = this.taskSetup.get("cids", null);
        this.gids = this.taskSetup.get("gids", null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask() {
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        try {
            Object query = "SELECT id FROM contract WHERE (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?)";
            if (Utils.notBlankString((String)this.cids)) {
                query = (String)query + " AND id IN  (" + this.cids + ")";
            }
            if (Utils.notBlankString((String)this.gids)) {
                query = (String)query + " AND (";
                for (String gid : this.gids.split(",")) {
                    query = (String)query + " gr&" + gid + "=" + gid + " OR";
                }
                query = (String)query + " 0=1 )";
            }
            PreparedStatement ps = conSlave.prepareStatement((String)query);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)this.getOperatingTime()));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)this.getOperatingTime()));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                EventProcessor.getInstance().publish(new TimerEvent(rs.getInt(1), this.flag));
            }
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection(conSlave);
        }
    }
}

