/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.table.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUserTable;
import ru.bitel.common.dao.AbstractDao;

public class BGUserTableDao
extends AbstractDao<BGUserTable> {
    public BGUserTableDao(Connection con) {
        super(con, 0, "user_tables");
    }

    public BGUserTable get(int userId, String module, String tableId) throws SQLException {
        BGUserTable userTable = null;
        String query = "SELECT * FROM user_tables WHERE user_id=? AND table_module=? AND table_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, userId);
            ps.setString(index++, module);
            ps.setString(index++, tableId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    userTable = this.getFromRS(rs);
                }
            }
        }
        return userTable;
    }

    public boolean delete(int userId, String module, String tableId) throws SQLException {
        String query = "DELETE FROM user_tables WHERE user_id=? AND table_module=? AND table_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, userId);
            ps.setString(2, module);
            ps.setString(3, tableId);
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
    }

    protected BGUserTable getFromRS(ResultSet rs) throws SQLException {
        return new BGUserTable().setUserId(rs.getInt("user_id")).setModule(rs.getString("table_module")).setTableId(rs.getString("table_id")).setWidths(rs.getString("widths")).setPositions(rs.getString("positions")).setHiddens(rs.getString("hiddens"));
    }

    protected void updateImpl(BGUserTable userTable) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE user_id=? AND table_module=? AND table_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, userTable.getUserId());
            ps.setString(2, userTable.getModule());
            ps.setString(3, userTable.getTableId());
            ps.executeUpdate();
        }
        query = "INSERT INTO " + this.tableName + " SET user_id=?, table_module=?, table_id=?, widths=?, positions=?, hiddens=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, userTable.getUserId());
            ps.setString(2, userTable.getModule());
            ps.setString(3, userTable.getTableId());
            ps.setString(4, userTable.getWidths());
            ps.setString(5, userTable.getPositions());
            ps.setString(6, userTable.getHiddens());
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }
}

