/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.server.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.util.AbstractPeriodItemSet;

public final class ContractTariffOptionList
extends AbstractPeriodItemSet<OptionItem> {
    private static final Logger logger = LogManager.getLogger();
    public static final String TARIFF_REQUEST_KEY = "tariffOptions";

    public ContractTariffOptionList(List<OptionItem> entryList) {
        super(OptionItem.class, entryList);
        if (logger.isDebugEnabled() && logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(160);
            sb.append("Create: \n");
            for (OptionItem item : (OptionItem[])this.entries) {
                item.toString(sb.append("\t\tContractTariffOption: ")).append("\n");
            }
            sb.setLength(sb.length() - 1);
            logger.debug(sb.toString());
        }
    }

    public ContractTariffOptionList(OptionItem[] entries) {
        super(OptionItem.class, (AbstractPeriodItemSet.PeriodItem[])entries);
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(160);
            sb.append("Create: \n");
            for (OptionItem item : entries) {
                item.toString(sb.append("\t\tContractTariffOption: ")).append("\n");
            }
            sb.setLength(sb.length() - 1);
            logger.debug(sb.toString());
        }
    }

    protected boolean containsMillis(OptionItem item, long millis) {
        return item.timeFrom <= millis && (item.timeTo == 0L || millis <= item.timeTo);
    }

    protected boolean isCoincide(OptionItem item, OptionItem other) {
        return other.contractOptionId.equals(item.contractOptionId) && other.timeFrom == item.timeFrom && other.id == item.id;
    }

    public long getTimeFrom(int contractOptionId) {
        int size = ((OptionItem[])this.entries).length;
        for (int i = 0; i < size; ++i) {
            OptionItem item = ((OptionItem[])this.entries)[i];
            if (contractOptionId != item.contractOptionId) continue;
            return item.timeFrom;
        }
        return 0L;
    }

    public Map<Integer, Integer> optionMap(long date1, long date2) {
        if (((OptionItem[])this.entries).length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Integer> options = new HashMap<Integer, Integer>(4);
        long[] intersection = new long[2];
        int size = ((OptionItem[])this.entries).length;
        for (int i = 0; i < size; ++i) {
            OptionItem item = ((OptionItem[])this.entries)[i];
            long[] period = RangeUtils.intersectionAnd((long[])intersection, (long)item.timeFrom, (long)item.timeTo, (long)date1, (long)date2);
            if (period == null) continue;
            options.put(item.id, item.contractOptionId);
        }
        if (options.size() > 0) {
            return options;
        }
        return Collections.emptyMap();
    }

    public ContractTariffOptionList add(int optionId, int contractOptionId, long timeFrom, long timeTo) {
        return new ContractTariffOptionList((OptionItem[])super.add((AbstractPeriodItemSet.PeriodItem)new OptionItem(optionId, contractOptionId, timeFrom, timeTo)));
    }

    public ContractTariffOptionList update(int optionId, int contractOptionId, long timeFrom, long timeTo) {
        return new ContractTariffOptionList((OptionItem[])super.update((AbstractPeriodItemSet.PeriodItem)new OptionItem(optionId, contractOptionId, timeFrom, timeTo)));
    }

    public ContractTariffOptionList remove(int optionId, int contractOptionId, long timeFrom, long timeTo) {
        return new ContractTariffOptionList((OptionItem[])super.remove((AbstractPeriodItemSet.PeriodItem)new OptionItem(optionId, contractOptionId, timeFrom, timeTo)));
    }

    public List<OptionItem> list(int optionId, long timeFrom, long timeTo) {
        long[] intersection = new long[2];
        OptionItem oneResult = null;
        ArrayList<OptionItem> result = null;
        int size = ((OptionItem[])this.entries).length;
        for (int i = 0; i < size; ++i) {
            long[] period;
            OptionItem item = ((OptionItem[])this.entries)[i];
            if (optionId != item.id || (period = RangeUtils.intersectionAnd((long[])intersection, (long)item.timeFrom, (long)item.timeTo, (long)timeFrom, (long)timeTo)) == null) continue;
            if (oneResult == null) {
                oneResult = item;
                continue;
            }
            if (result == null) {
                result = new ArrayList<OptionItem>(5);
                result.add(oneResult);
            }
            result.add(item);
        }
        if (result != null) {
            return result;
        }
        if (oneResult != null) {
            return Collections.singletonList(oneResult);
        }
        return Collections.emptyList();
    }

    public static final class OptionItem
    extends AbstractPeriodItemSet.PeriodItem {
        public final Integer contractOptionId;

        public OptionItem(int optionId, int contractOptionId, Date timeFrom, Date timeTo) {
            super(optionId, timeFrom, timeTo);
            this.contractOptionId = contractOptionId;
        }

        public OptionItem(int optionId, int contractOptionId, long timeFrom, long timeTo) {
            super(optionId, timeFrom, timeTo);
            this.contractOptionId = contractOptionId;
        }

        public String toString() {
            return this.toString(new StringBuilder(160).append("cto: ").append(this.contractOptionId).append('-')).toString();
        }
    }
}

