/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.math.BigDecimal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffVar;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.common.ParameterMap;

public class MultCostTariffTreeNode
extends DefaultTariffTreeNode<AbstractTariffRequest<?>, TariffContext> {
    private static final Logger logger = LogManager.getLogger();
    private final BigDecimal multiplicand;
    protected final String multMode;
    protected final int tariffVarId;

    public MultCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.multiplicand = parameterMap.getBigDecimal("value", BigDecimal.ONE);
        this.multMode = parameterMap.get("multMode", "const");
        this.tariffVarId = parameterMap.getInt("tariffVarId", 0);
        if (logger.isDebugEnabled()) {
            logger.debug("multiplicand = " + this.multiplicand + "; multMode = " + this.multMode + "; tariffVarId = " + this.tariffVarId);
        }
    }

    @Override
    public int executeImpl(Long treeNodeId, AbstractTariffRequest<?> tariffRequest, TariffContext tariffContext) {
        if (((ServiceCost)tariffRequest.serviceCost).cost != null) {
            ContractTariffVar contractTariffVar;
            BigDecimal inMultiplicand = this.multiplicand;
            if ("var".equals(this.multMode) && (contractTariffVar = tariffRequest.getContractTariffVar(this.tariffVarId)) != null) {
                String value = contractTariffVar.getValue();
                inMultiplicand = new BigDecimal(value == null ? contractTariffVar.getDefaultValue() : value);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("tariffRequest.serviceCost.cost(before) = " + ((ServiceCost)tariffRequest.serviceCost).cost);
            }
            ((ServiceCost)tariffRequest.serviceCost).cost = ((ServiceCost)tariffRequest.serviceCost).cost.multiply(inMultiplicand, tariffContext.mc);
            if (logger.isDebugEnabled()) {
                logger.debug("tariffRequest.serviceCost.cost(after) = " + ((ServiceCost)tariffRequest.serviceCost).cost);
            }
            return 1;
        }
        return 0;
    }
}

