/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.update.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.update.server.LibInfo;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class LibInfoUtil {
    private static final String SHA_256 = "SHA-256";
    private static final int STREAM_BUFFER_LENGTH = 1024;
    private static Map<String, LibInfo> clientLibInfos = null;
    private static Map<String, List<LibInfo>> appsLibInfos = null;
    private static Map<String, List<LibInfo>> appsFilesInfos = null;
    private static Set<String> appsTypesInfos = null;
    private static final Logger logger = LogManager.getLogger();

    public static Map<String, LibInfo> getClientLibInfos() {
        if (clientLibInfos == null) {
            clientLibInfos = new HashMap<String, LibInfo>();
            ArrayList<LibInfo> list = new ArrayList<LibInfo>();
            LibInfoUtil.doLibInfos(list, "lib/client");
            LibInfoUtil.doLibInfos(list, "lib/common");
            LibInfoUtil.doLibInfos(list, "lib/ext/client");
            LibInfoUtil.doLibInfos(list, "lib/ext/common");
            StringBuilder versions = new StringBuilder();
            Collections.sort(list, new LibInfo());
            for (LibInfo libInfo : list) {
                versions.append(libInfo.getHash());
            }
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(versions.toString().getBytes("UTF-8"));){
                String clientVersion = LibInfoUtil.sha256Hex(byteArrayInputStream);
                Setup.getSetup().set("bg.client.version", clientVersion);
                logger.debug("Set bg.client.version=" + clientVersion);
            }
            catch (Exception e) {
                logger.error("error calc bg.client.version", (Throwable)e);
            }
        }
        return clientLibInfos;
    }

    private static void doLibInfos(List<LibInfo> list, String dir) {
        Path libsDir;
        URI jars = null;
        try {
            jars = ClassLoader.getSystemResource(dir).toURI();
            logger.debug("lib dir: {} = {}", (Object)dir, (Object)jars);
        }
        catch (Exception e) {
            logger.warn("error get resource \"{}\" (not found?)", (Object)dir);
        }
        if (jars != null && Files.exists(libsDir = Paths.get(jars), new LinkOption[0]) && Files.isDirectory(libsDir, new LinkOption[0])) {
            for (File libFile : new File(jars).listFiles()) {
                LibInfo libInfo = new LibInfo();
                libInfo.setFile(libFile);
                libInfo.setName(LibInfoUtil.getLibName(libFile.getName()));
                libInfo.setHash(LibInfoUtil.sha256Hex(libFile.getPath()));
                clientLibInfos.put(libInfo.getName(), libInfo);
                list.add(libInfo);
                logger.debug("\t{}", (Object)libFile.getPath());
            }
        }
    }

    public static Map<String, List<LibInfo>> getAppsLibInfos() throws BGException {
        if (appsLibInfos == null) {
            appsLibInfos = new HashMap<String, List<LibInfo>>();
            Document appsDocument = LibInfoUtil.getAppsXmlDocument();
            for (Element apps : XMLUtils.selectElements((Node)appsDocument.getDocumentElement(), (String)"/data/apps")) {
                String type = apps.getAttribute("type");
                if (Utils.isBlankString((String)type)) {
                    throw new BGException("/data/apps.xml: missing \"type\"");
                }
                ArrayList list = new ArrayList();
                XMLUtils.selectElements((Node)apps, (String)"lib").forEach(e -> {
                    if ("*".equals(e.getAttribute("name"))) {
                        list.addAll(LibInfoUtil._addAppLib(e.getAttribute("type"), e.getAttribute("dir")));
                    } else {
                        list.add(LibInfo.builder().setType(e.getAttribute("type")).setName(e.getAttribute("name")).setDir(e.hasAttribute("dir") ? e.getAttribute("dir") : null).setToDir(e.hasAttribute("toDir") ? e.getAttribute("toDir") : null).build());
                    }
                });
                appsLibInfos.put(type, list);
            }
        }
        return appsLibInfos;
    }

    private static List<LibInfo> _addAppLib(String type, String subdir) {
        ArrayList<LibInfo> list = new ArrayList<LibInfo>();
        if (subdir == null) {
            return list;
        }
        String libDir = System.getProperty("lib.dir");
        try {
            File libAppDir = null;
            if (libDir != null) {
                libAppDir = new File(libDir + File.separator + "lib/" + subdir);
            } else {
                URL url = LibInfoUtil.class.getResource("/lib/" + subdir);
                if (url != null) {
                    libAppDir = new File(url.toURI());
                }
            }
            if (libAppDir != null) {
                for (File libAppFile : libAppDir.listFiles()) {
                    if (!libAppFile.exists() || !libAppFile.isFile() || !libAppFile.getName().endsWith(".jar")) continue;
                    String name = libAppFile.getName();
                    name = name.substring(0, name.length() - 4);
                    list.add(LibInfo.builder().setType(type).setName(name).setDir(subdir).build());
                }
            }
        }
        catch (URISyntaxException e) {
            logger.error("error process app lib", (Throwable)e);
        }
        return list;
    }

    private static String getLibName(String name) {
        int index;
        if (name.endsWith(".jar")) {
            name = name.substring(0, name.length() - 4);
        }
        if ((index = name.lastIndexOf(45)) > -1 && index + 1 < name.length() && Character.isDigit(name.charAt(index + 1))) {
            name = name.substring(0, index);
        }
        return name;
    }

    public static String sha256Hex(String fileName) {
        String string;
        block8: {
            InputStream is = Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);
            try {
                string = LibInfoUtil.sha256Hex(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    public static String sha256Hex(InputStream data) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(SHA_256);
        byte[] buffer = new byte[1024];
        int read = data.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = data.read(buffer, 0, 1024);
        }
        return Utils.bytesToHexString((byte[])digest.digest());
    }

    public static Map<String, List<LibInfo>> getAppsFilesInfos() throws BGException {
        if (appsFilesInfos == null) {
            appsFilesInfos = new HashMap<String, List<LibInfo>>();
            Document appsDocument = LibInfoUtil.getAppsXmlDocument();
            for (Element apps : XMLUtils.selectElements((Node)appsDocument, (String)"/data/apps")) {
                String appType = apps.getAttribute("type");
                if (Utils.isBlankString((String)appType)) {
                    throw new BGException("/data/apps.xml: missing \"type\"");
                }
                ArrayList<LibInfo> list = new ArrayList<LibInfo>();
                for (Element e : XMLUtils.selectElements((Node)apps, (String)"file")) {
                    String name = e.getAttribute("name");
                    if (Utils.isBlankString((String)name)) {
                        throw new BGException("/data/apps.xml: type=" + appType + ": missing \"name\"");
                    }
                    LibInfoUtil._addAppFiles(list, appType, name, e.getAttribute("toDir"));
                }
                appsFilesInfos.put(appType, list);
            }
        }
        return appsFilesInfos;
    }

    private static void _addAppFiles(List<LibInfo> list, String appType, String name, String toDir) throws BGException {
        int idx = name.lastIndexOf(47);
        if (idx == -1) {
            throw new BGException("/data/apps.xml: type=" + appType + ", name=" + name + ": error root path");
        }
        String fileDir = name.substring(0, idx);
        String fileFile = name.substring(idx + 1);
        if (fileDir.contains("*")) {
            throw new BGException("/data/apps.xml: type=" + appType + ", name=" + name + ": error wildcard in middle");
        }
        Path pfileDir = Paths.get(fileDir, new String[0]);
        LibInfoUtil._addAppFilesR(list, appType, pfileDir, fileFile, toDir);
    }

    private static void _addAppFilesR(List<LibInfo> list, String appType, Path dirPath, String fileName, String toDir) throws BGException {
        if (!Files.isDirectory(dirPath, new LinkOption[0]) || !Files.isReadable(dirPath)) {
            logger.warn("/data/apps.xml: type={}: error directory \"{}\" (not found? no directory?)", (Object)appType, (Object)dirPath);
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dirPath, fileName);){
            for (Path file : stream) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    LibInfoUtil._addAppFilesR(list, appType, file, "*", toDir);
                    continue;
                }
                if (!Files.isRegularFile(file, new LinkOption[0])) continue;
                LibInfo libInfo = new LibInfo();
                libInfo.setFile(file.toFile());
                libInfo.setName(file.toString());
                libInfo.setHash(LibInfoUtil.sha256Hex(file.toString()));
                libInfo.setType("file");
                libInfo.setToDir(toDir);
                list.add(libInfo);
            }
        }
        catch (IOException e) {
            throw new BGException("/data/apps.xml: type=" + appType + ": error directory " + dirPath + ": " + e.toString(), (Throwable)e);
        }
    }

    private static Document getAppsXmlDocument() throws BGException {
        try {
            return XMLUtils.parseDocument((InputSource)new InputSource(LibInfoUtil.class.getResourceAsStream("/data/apps.xml")), (XMLUtils.ErrorShowType)XMLUtils.ErrorShowType.EXCEPTION);
        }
        catch (Exception e) {
            throw new BGException("error parse /data/apps.xml: " + e.toString(), (Throwable)e);
        }
    }

    public static Set<String> getAppsTypes() throws BGException {
        if (appsTypesInfos == null) {
            appsTypesInfos = new HashSet<String>();
            Document appsDocument = LibInfoUtil.getAppsXmlDocument();
            for (Element apps : XMLUtils.selectElements((Node)appsDocument, (String)"/data/apps")) {
                String appType = apps.getAttribute("type");
                if (Utils.isBlankString((String)appType)) {
                    throw new BGException("/data/apps.xml: missing \"type\"");
                }
                appsTypesInfos.add(appType);
            }
        }
        return appsTypesInfos;
    }
}

