/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.worker.WorkerTask;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.event.AreaModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.event.CityModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.event.HouseModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.event.QuarterModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.event.StreetModifiedEvent;
import ru.bitel.oss.kernel.entity.common.bean.AbstractSpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrContract;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrHouse;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrInt;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrMultiList;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrText;
import ru.bitel.oss.kernel.entity.server.bean.ContractDaoSupport;
import ru.bitel.oss.kernel.entity.server.bean.ContractObjectDaoSupport;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrAddressDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrBooleanDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrContractDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDaoSupport;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDateDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrEmailDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrHouseDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrIntDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrListDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrMultiListDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrPhoneDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrServicingPersonDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrTextDao;

public abstract class AbstractEntityAttrDao<E extends Id>
extends AbstractIdDao<E> {
    protected static final EntityAttrDaoSupport ENTITY_SUPPORT = new EntityAttrDaoSupport();
    protected static final EntityAttrDaoSupport CONTRACT_SUPPORT = new ContractDaoSupport();
    protected static final EntityAttrDaoSupport CONTRACT_OBJECT_SUPPORT = new ContractObjectDaoSupport();
    final EntityAttrDaoSupport support;
    private EntityAttrTextDao textDao;
    private EntityAttrIntDao intDao;
    private EntityAttrListDao listDao;
    private EntityAttrDateDao dateDao;
    private EntityAttrHouseDao houseDao;
    private EntityAttrAddressDao addressDao;
    private EntityAttrMultiListDao multiListDao;
    private EntityAttrEmailDao emailDao;
    private EntityAttrContractDao contractDao;
    private EntityAttrBooleanDao booleanDao;
    private EntityAttrPhoneDao phoneDao;
    private EntityAttrServicingPersonDao servicingPersonDao;
    private PreparedStatement deleteAttributesPS = null;
    protected final int userId;
    protected final String entityTableSuffix;
    protected Directory<? extends EntitySpec> entitySpecDirectory;
    protected Directory<? extends AbstractSpecAttr> entitySpecAttrDirectory;
    protected static final Comparator<FilterEntityAttr> filterWeightComparator = new Comparator<FilterEntityAttr>(){

        private int getWeight(FilterEntityAttr o) {
            if (o instanceof FilterEntityAttrInt) {
                return 0;
            }
            if (o instanceof FilterEntityAttrHouse) {
                return 1;
            }
            if (o instanceof FilterEntityAttrContract) {
                return 2;
            }
            if (o instanceof FilterEntityAttrList) {
                return 3;
            }
            if (o instanceof FilterEntityAttrDate) {
                return 4;
            }
            if (o instanceof FilterEntityAttrText) {
                return 5;
            }
            if (o instanceof FilterEntityAttrAddress) {
                return 6;
            }
            if (o instanceof FilterEntityAttrEmail) {
                return 7;
            }
            if (o instanceof FilterEntityAttrBoolean) {
                return 8;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int compare(FilterEntityAttr o1, FilterEntityAttr o2) {
            return this.getWeight(o1) - this.getWeight(o2);
        }
    };
    private static final Executor executor = WorkerTask.newFixedThreadPool((String)"AddressUpdater", null, null, (int)1, (int)30, (RejectedExecutionHandler)new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                LogManager.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
    });

    public AbstractEntityAttrDao(Connection con, int moduleId, int userId, String tableName, String entityTableSuffix, EntityAttrDaoSupport support) {
        super(con, moduleId, tableName);
        this.userId = userId;
        this.support = support;
        this.entityTableSuffix = entityTableSuffix != null ? "_" + entityTableSuffix + (String)(moduleId > 0 ? "_" + moduleId : "") : "";
    }

    public AbstractEntityAttrDao(Connection con, int moduleId, int userId, String tableName) {
        super(con, moduleId, tableName);
        this.userId = userId;
        this.support = null;
        this.entityTableSuffix = null;
    }

    public String getEntityTableSuffix() {
        return this.entityTableSuffix;
    }

    public Directory<? extends Id> getEntitySpecDirectory() throws BGException {
        if (this.entitySpecDirectory == null) {
            this.entitySpecDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(EntitySpec.class, this.con, 0, true);
        }
        return this.entitySpecDirectory;
    }

    protected Directory<? extends Id> getEntitySpecAttrDirectory() throws BGException {
        if (this.entitySpecAttrDirectory == null) {
            this.entitySpecAttrDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(EntitySpecAttr.class, this.con, 0, true);
        }
        return this.entitySpecAttrDirectory;
    }

    protected EntityAttr getAttribute(int entityId, AbstractSpecAttr spec) throws BGException {
        switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)spec.getType()).get()) {
            case TEXT: {
                return this.getTextDao().get(entityId, spec.getId());
            }
            case INT: {
                return this.getIntDao().get(entityId, spec.getId());
            }
            case BOOLEAN: {
                return this.getBooleanDao().get(entityId, spec.getId());
            }
            case LIST: {
                return this.getListDao().get(entityId, spec.getId());
            }
            case DATE: {
                return this.getDateDao().get(entityId, spec.getId());
            }
            case HOUSE: {
                return this.getHouseDao().get(entityId, spec.getId());
            }
            case ADDRESS: {
                return this.getAddressDao().get(entityId, spec.getId());
            }
            case EMAIL: {
                return this.getEmailDao().get(entityId, spec.getId());
            }
            case CONTRACT: {
                return this.getContractDao().get(entityId, spec.getId());
            }
            case PHONE: {
                return this.getPhoneDao().get(entityId, spec.getId());
            }
            case MULTILIST: {
                return this.getMultiListDao().get(entityId, spec.getId());
            }
            case SERVICING_PERSON: {
                return this.getServicingPersonDao().get(entityId, spec.getId());
            }
            case SEPARATOR: {
                return null;
            }
        }
        this.getLogger().error("Unknown specAttrType={}", (Object)spec.getType());
        return null;
    }

    protected Map<Integer, EntityAttr> getEntityAttributes(int entitySpecId, int entityId, boolean fullMap) throws BGException {
        if (entitySpecId <= 0) {
            return null;
        }
        Directory<Id> dir = this.getEntitySpecDirectory();
        EntitySpec spec = (EntitySpec)dir.get(entitySpecId);
        if (spec == null) {
            return null;
        }
        LinkedHashMap<Integer, EntityAttr> result = new LinkedHashMap<Integer, EntityAttr>(spec.getAttributeList().size());
        for (AbstractSpecAttr sa : spec.getAttributeList()) {
            EntityAttr a = this.getAttribute(entityId, sa);
            if (a != null) {
                result.put(a.getEntitySpecAttrId(), a);
                continue;
            }
            if (!fullMap) continue;
            result.put(sa.getId(), EntityAttr.newInstance((int)sa.getType(), (int)entityId, (int)sa.getId()));
        }
        return result;
    }

    protected Map<Integer, EntityAttr> getEntityAttributes(int entityId, Set<Integer> entitySpecAttrIds) throws BGException {
        List<Id> list = this.getEntitySpecAttrDirectory().list();
        LinkedHashMap<Integer, EntityAttr> result = new LinkedHashMap<Integer, EntityAttr>(list.size());
        for (Id listItem : list) {
            EntityAttr entityAttr;
            if (!(listItem instanceof AbstractSpecAttr)) continue;
            AbstractSpecAttr abstractSpecAttr = (AbstractSpecAttr)listItem;
            if (entitySpecAttrIds != null && !entitySpecAttrIds.contains(abstractSpecAttr.getId()) || (entityAttr = this.getAttribute(entityId, abstractSpecAttr)) == null) continue;
            result.put(entityAttr.getEntitySpecAttrId(), entityAttr);
        }
        return result;
    }

    protected Map<Integer, EntityAttr> getAllEntityAttributes(int entityId, boolean fullMap) throws BGException {
        List<Id> list = this.getEntitySpecAttrDirectory().list();
        LinkedHashMap<Integer, EntityAttr> result = new LinkedHashMap<Integer, EntityAttr>(list.size());
        for (Id listItem : list) {
            if (!(listItem instanceof EntitySpecAttr)) continue;
            EntitySpecAttr entitySpecAttr = (EntitySpecAttr)listItem;
            EntityAttr entityAttr = this.getAttribute(entityId, (AbstractSpecAttr)entitySpecAttr);
            if (entityAttr != null) {
                result.put(entityAttr.getEntitySpecAttrId(), entityAttr);
                continue;
            }
            if (!fullMap) continue;
            result.put(entitySpecAttr.getId(), EntityAttr.newInstance((int)entitySpecAttr.getType(), (int)entityId, (int)entitySpecAttr.getId()));
        }
        return result;
    }

    protected Map<Integer, String> getEntityValueForIds(int entityId, Set<Integer> ids) throws BGException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        List<Id> list = this.getEntitySpecAttrDirectory().list();
        for (Integer id : ids) {
            String value = "";
            for (Id listItem : list) {
                EntityAttr entityAttr;
                AbstractSpecAttr entitySpecAttr;
                if (!(listItem instanceof AbstractSpecAttr) || (entitySpecAttr = (AbstractSpecAttr)listItem).getId() != id.intValue() || (entityAttr = this.getAttribute(entityId, entitySpecAttr)) == null) continue;
                value = entityAttr.toString();
                break;
            }
            result.put(id, value);
        }
        return result;
    }

    protected EntityAttr getEntityAttribute(int entityId, int entityAttrId) throws BGException {
        if (entityAttrId <= 0) {
            return null;
        }
        Directory<Id> dir = this.getEntitySpecAttrDirectory();
        AbstractSpecAttr specAttr = (AbstractSpecAttr)dir.get(entityAttrId);
        if (specAttr == null) {
            return null;
        }
        return this.getAttribute(entityId, specAttr);
    }

    protected Optional<EntityAttr> optEntityAttribute(int entityId, int entityAttrId) throws BGException {
        return Optional.ofNullable(this.getEntityAttribute(entityId, entityAttrId));
    }

    protected boolean updateEntityAttribute(int entityId, EntityAttr entityAttr) throws SQLException, BGException {
        Directory<Id> dir = this.getEntitySpecAttrDirectory();
        AbstractSpecAttr entitySpecAttr = (AbstractSpecAttr)dir.get(entityAttr.getEntitySpecAttrId());
        if (entitySpecAttr != null) {
            switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)entitySpecAttr.getType()).get()) {
                case TEXT: {
                    return this.getTextDao().update(entityId, entitySpecAttr, entityAttr);
                }
                case INT: {
                    return this.getIntDao().update(entityId, entitySpecAttr, entityAttr);
                }
                case BOOLEAN: {
                    return this.getBooleanDao().update(entityId, entitySpecAttr, entityAttr);
                }
                case LIST: {
                    return this.getListDao().update(entityId, entitySpecAttr, entityAttr);
                }
                case DATE: {
                    return this.getDateDao().update(entityId, entitySpecAttr, entityAttr);
                }
                case HOUSE: {
                    return this.getHouseDao().update(entityId, entitySpecAttr, entityAttr);
                }
                case ADDRESS: {
                    return this.getAddressDao().update(entityId, entitySpecAttr, entityAttr);
                }
                case EMAIL: {
                    return this.getEmailDao().update(entityId, entitySpecAttr, entityAttr);
                }
                case CONTRACT: {
                    return this.getContractDao().update(entityId, entitySpecAttr, entityAttr);
                }
                case PHONE: {
                    return this.getPhoneDao().update(entityId, entitySpecAttr, entityAttr);
                }
                case MULTILIST: {
                    return this.getMultiListDao().update(entityId, entitySpecAttr, entityAttr);
                }
                case SERVICING_PERSON: {
                    return this.getServicingPersonDao().update(entityId, entitySpecAttr, entityAttr);
                }
            }
            throw new IllegalArgumentException();
        }
        return false;
    }

    public boolean deleteEntityAttribute(int entityId, int entitySpecAttrId) throws BGException {
        Directory<Id> dir = this.getEntitySpecAttrDirectory();
        AbstractSpecAttr entitySpecAttr = (AbstractSpecAttr)dir.get(entitySpecAttrId);
        if (entitySpecAttr != null) {
            switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)entitySpecAttr.getType()).get()) {
                case TEXT: {
                    return this.getTextDao().delete(entityId, entitySpecAttr);
                }
                case INT: {
                    return this.getIntDao().delete(entityId, entitySpecAttr);
                }
                case BOOLEAN: {
                    return this.getBooleanDao().delete(entityId, entitySpecAttr);
                }
                case LIST: {
                    return this.getListDao().delete(entityId, entitySpecAttr);
                }
                case DATE: {
                    return this.getDateDao().delete(entityId, entitySpecAttr);
                }
                case HOUSE: {
                    return this.getHouseDao().delete(entityId, entitySpecAttr);
                }
                case ADDRESS: {
                    return this.getAddressDao().delete(entityId, entitySpecAttr);
                }
                case EMAIL: {
                    return this.getEmailDao().delete(entityId, entitySpecAttr);
                }
                case CONTRACT: {
                    return this.getContractDao().delete(entityId, entitySpecAttr);
                }
                case PHONE: {
                    return this.getPhoneDao().delete(entityId, entitySpecAttr);
                }
                case MULTILIST: {
                    return this.getMultiListDao().delete(entityId, entitySpecAttr);
                }
                case SERVICING_PERSON: {
                    return this.getServicingPersonDao().delete(entityId, entitySpecAttr);
                }
            }
            throw new IllegalArgumentException();
        }
        return false;
    }

    public boolean checkEntitySpecAttrDelete(int entitySpecAttrId) throws BGException {
        Directory<Id> dir = this.getEntitySpecAttrDirectory();
        EntitySpecAttr entitySpecAttr = (EntitySpecAttr)dir.get(entitySpecAttrId);
        try {
            switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)entitySpecAttr.getType()).get()) {
                case TEXT: {
                    return this.getTextDao().checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case INT: {
                    return this.getIntDao().checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case BOOLEAN: {
                    return this.getBooleanDao().checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case LIST: {
                    return this.getListDao().checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case DATE: {
                    return this.getDateDao().checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case HOUSE: {
                    return this.getHouseDao().checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case ADDRESS: {
                    return this.getAddressDao().checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case EMAIL: {
                    return this.getEmailDao().checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case CONTRACT: {
                    return this.getContractDao().checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case PHONE: {
                    return this.getPhoneDao().checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case MULTILIST: {
                    return this.getMultiListDao().checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case SERVICING_PERSON: {
                    return this.getServicingPersonDao().checkEntitySpecAttrDelete(entitySpecAttrId);
                }
            }
            throw new IllegalArgumentException();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected void updateEntityAttributes(int entityId, Map<Integer, EntityAttr> entityAttributes) throws BGException, SQLException {
        this.deleteEntityAttributes(entityId);
        if (entityAttributes == null || entityAttributes.size() == 0) {
            return;
        }
        Directory<Id> dir = this.getEntitySpecAttrDirectory();
        block13: for (EntityAttr entityAttr : entityAttributes.values()) {
            EntitySpecAttr entitySpecAttr = (EntitySpecAttr)dir.get(entityAttr.getEntitySpecAttrId());
            switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)entitySpecAttr.getType()).get()) {
                case TEXT: {
                    this.getTextDao().insert(entityId, entityAttr);
                    continue block13;
                }
                case INT: {
                    this.getIntDao().insert(entityId, entityAttr);
                    continue block13;
                }
                case LIST: {
                    this.getListDao().insert(entityId, entityAttr);
                    continue block13;
                }
                case DATE: {
                    this.getDateDao().insert(entityId, entityAttr);
                    continue block13;
                }
                case HOUSE: {
                    this.getHouseDao().insert(entityId, entityAttr);
                    continue block13;
                }
                case ADDRESS: {
                    this.getAddressDao().insert(entityId, entityAttr);
                    continue block13;
                }
                case EMAIL: {
                    this.getEmailDao().insert(entityId, entityAttr);
                    continue block13;
                }
                case CONTRACT: {
                    this.getContractDao().insert(entityId, entityAttr);
                    continue block13;
                }
                case PHONE: {
                    this.getPhoneDao().insert(entityId, entityAttr);
                    continue block13;
                }
                case MULTILIST: {
                    this.getMultiListDao().insert(entityId, entityAttr);
                    continue block13;
                }
                case SERVICING_PERSON: {
                    this.getServicingPersonDao().insert(entityId, entityAttr);
                    continue block13;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    protected void deleteEntityAttributes(int entityId) throws BGException, SQLException {
        PreparedStatement ps = this.deleteAttributesPS;
        if (ps == null) {
            StringBuilder query = new StringBuilder(100);
            query.append("DELETE FROM ").append(this.getTextDao().table).append(", ");
            if (this.getIntDao() != null) {
                query.append(this.getIntDao().table).append(", ");
            }
            if (this.getBooleanDao() != null) {
                query.append(this.getBooleanDao().table).append(", ");
            }
            if (this.getListDao() != null) {
                query.append(this.getListDao().table).append(", ");
            }
            if (this.getHouseDao() != null) {
                query.append(this.getHouseDao().table).append(", ");
            }
            if (this.getAddressDao() != null) {
                query.append(this.getAddressDao().table).append(", ");
            }
            if (this.getContractDao() != null) {
                query.append(this.getContractDao().table).append(", ");
            }
            query.append(this.getDateDao().table);
            query.append(" USING ").append(this.tableName);
            String tableNameDotBeanId = this.tableName + "." + this.support.beanIdName();
            String dotIdDotTableNameDotBeanId = "." + this.support.idName() + "=" + this.tableName + "." + this.support.beanIdName();
            query.append(" LEFT JOIN ").append(this.getTextDao().table).append(" ON ").append(this.getTextDao().table).append(dotIdDotTableNameDotBeanId);
            if (this.getIntDao() != null) {
                query.append(" LEFT JOIN ").append(this.getIntDao().table).append(" ON ").append(this.getIntDao().table).append(dotIdDotTableNameDotBeanId);
            }
            if (this.getListDao() != null) {
                query.append(" LEFT JOIN ").append(this.getListDao().table).append(" ON ").append(this.getListDao().table).append(dotIdDotTableNameDotBeanId);
            }
            if (this.getContractDao() != null) {
                query.append(" LEFT JOIN ").append(this.getContractDao().table).append(" ON ").append(this.getContractDao().table).append(dotIdDotTableNameDotBeanId);
            }
            if (this.getHouseDao() != null) {
                query.append(" LEFT JOIN ").append(this.getHouseDao().table).append(" ON ").append(this.getHouseDao().table).append(dotIdDotTableNameDotBeanId);
            }
            if (this.getAddressDao() != null) {
                query.append(" LEFT JOIN ").append(this.getAddressDao().table).append(" ON ").append(this.getAddressDao().table).append(dotIdDotTableNameDotBeanId);
            }
            query.append(" LEFT JOIN ").append(this.getDateDao().table).append(" ON ").append(this.getDateDao().table).append(dotIdDotTableNameDotBeanId);
            query.append(" WHERE ").append(tableNameDotBeanId).append("=?");
            ps = this.deleteAttributesPS = this.con.prepareStatement(query.toString());
        }
        ps.setInt(1, entityId);
        ps.executeUpdate();
    }

    protected List<E> list(boolean loadAttributes, Page page, String what, String join, List<FilterEntityAttr> entityFilter, String filter, String groupBy, String orderBy, Object ... params) throws BGException {
        try {
            if (Setup.getSetup().getBoolean("contract.search.order.title.length", false)) {
                orderBy = what == null ? "titleLength" + (String)(orderBy != null ? ", " + orderBy : "") : orderBy;
                what = "DISTINCT SQL_CALC_FOUND_ROWS " + (String)(what == null ? this.tableName + ".*, LENGTH(" + this.tableName + ".title) as titleLength" : what);
            } else {
                what = "DISTINCT SQL_CALC_FOUND_ROWS " + (String)(what == null ? this.tableName + ".*" : what);
            }
            List<E> result = this.listImpl(loadAttributes, page, (String)what, join, null, entityFilter, filter, groupBy, orderBy, params);
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            return result;
        }
        catch (SQLException e) {
            this.processException(e);
            return Collections.emptyList();
        }
    }

    public List<FilterEntityAttr> filterInit(List<FilterEntityAttr> entityFilter) {
        if (entityFilter == null) {
            entityFilter = Collections.emptyList();
        } else if (entityFilter.size() > 1) {
            if (!(entityFilter instanceof ArrayList)) {
                entityFilter = new ArrayList<FilterEntityAttr>(entityFilter);
            }
            Collections.sort(entityFilter, filterWeightComparator);
        }
        return entityFilter;
    }

    protected String getEntityTableName() {
        return this.tableName;
    }

    protected List<E> listImpl(boolean loadAttributes, Page page, String what, String join1, String join2, List<FilterEntityAttr> entityFilter, String filter, String groupBy, String orderBy, Object ... params) throws BGException {
        ArrayList<E> arrayList;
        block26: {
            StringBuilder query = new StringBuilder(128);
            entityFilter = this.filterInit(entityFilter);
            query.append("SELECT ").append(what).append(" FROM ").append(this.tableName);
            if (join1 != null) {
                query.append('\n').append(join1);
            }
            if (join2 != null) {
                query.append('\n').append(join2);
            }
            StringBuilder where = new StringBuilder(64);
            this.filterJoin(query, "", where, entityFilter);
            if (filter != null && filter.length() > 0 || where.length() > 0) {
                query.append("\n WHERE ");
                if (filter != null && filter.length() > 0) {
                    query.append(filter);
                    if (where.length() > 0) {
                        query.append("\n AND");
                    }
                }
                query.append((CharSequence)where);
            }
            if (groupBy != null && groupBy.length() > 0) {
                query.append("\n GROUP BY ").append(groupBy);
            }
            if (orderBy != null && orderBy.length() > 0) {
                if (!orderByPattern.matcher(orderBy).matches()) {
                    throw new BGException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441");
                }
                query.append("\n ORDER BY ").append(orderBy);
            }
            if (page != null && page.getPageSize() > 0) {
                query.append(page.sqlLimit());
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            try {
                int idx = 0;
                for (int i = 0; i < params.length; ++i) {
                    AbstractEntityAttrDao.setStatementParam((PreparedStatement)ps, (int)(++idx), (Object)params[i]);
                }
                idx = this.filterToPS(ps, idx, entityFilter);
                ArrayList<E> result = new ArrayList<E>();
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result.add(this.getFromRS(rs, loadAttributes));
                    }
                }
                arrayList = result;
                if (ps == null) break block26;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.getLogger().error(query.toString());
                    throw new BGException((Throwable)e);
                }
            }
            ps.close();
        }
        return arrayList;
    }

    protected E getFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getFromRS(rs, true);
    }

    protected abstract E getFromRS(ResultSet var1, boolean var2) throws SQLException, BGException;

    public void filterJoin(StringBuilder query, String wherePrefix, StringBuilder where, List<FilterEntityAttr> entityFilter) {
        int tableId = 0;
        int whereLength = where.length();
        int size = entityFilter.size();
        for (int i = 0; i < size; ++i) {
            String tableName;
            FilterEntityAttr a = entityFilter.get(i);
            ++tableId;
            query.append("\n INNER JOIN ");
            if (i == 0) {
                where.append(wherePrefix);
            }
            where.append(" (");
            String addressHouseTableName = null;
            String addressStreetTableName = null;
            if (a instanceof FilterEntityAttrText) {
                tableName = this.getTextDao().table + "_" + tableId;
                query.append(this.getTextDao().table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append(this.support.defaultValueName());
                switch (((FilterEntityAttrText)a).getMode()) {
                    case 1: {
                        where.append(" LIKE ?");
                        break;
                    }
                    case 2: {
                        where.append(" REGEXP ?");
                        break;
                    }
                    default: {
                        where.append("=?");
                        break;
                    }
                }
            } else if (a instanceof FilterEntityAttrInt) {
                tableName = this.getIntDao().table + "_" + tableId;
                query.append(this.getIntDao().table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append(this.support.defaultValueName()).append("=?");
            } else if (a instanceof FilterEntityAttrBoolean) {
                tableName = this.getBooleanDao().table + "_" + tableId;
                query.append(this.getBooleanDao().table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append(this.support.defaultValueName()).append("=?");
            } else if (a instanceof FilterEntityAttrMultiList) {
                tableName = this.getMultiListDao().itemTable + "_" + tableId;
                query.append(this.getMultiListDao().itemTable).append(" AS ").append(tableName);
                where.append(tableName).append('.').append(this.support.typeName()).append("=?");
            } else if (a instanceof FilterEntityAttrList) {
                tableName = this.getListDao().table + "_" + tableId;
                query.append(this.getListDao().table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append(this.support.typeName()).append("=?");
            } else if (a instanceof FilterEntityAttrDate) {
                tableName = this.getDateDao().table + "_" + tableId;
                query.append(this.getDateDao().table).append(" AS ").append(tableName);
                FilterEntityAttrDate period = (FilterEntityAttrDate)a;
                if (period.getPeriodFrom() != null && period.getPeriodTo() != null && period.getPeriodFrom().equals(period.getPeriodTo())) {
                    where.append(tableName).append('.').append(this.support.defaultValueName()).append("=?");
                } else {
                    where.append(tableName).append('.').append(this.support.defaultValueName()).append(">=? OR ? IS NULL) AND (").append(tableName).append('.').append(this.support.defaultValueName()).append("<=? OR ? IS NULL");
                }
            } else if (a instanceof FilterEntityAttrHouse) {
                tableName = this.getHouseDao().table + "_" + tableId;
                query.append(this.getHouseDao().table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append(this.support.defaultValueName()).append("=?");
            } else if (a instanceof FilterEntityAttrAddress) {
                tableName = this.getAddressDao().table + "_" + tableId;
                addressHouseTableName = "address_house_" + tableId;
                addressStreetTableName = "address_street_" + tableId;
                query.append(this.getAddressDao().table).append(" AS ").append(tableName);
                where.append(" (? OR ").append(addressStreetTableName).append('.').append("cityid=?)");
                where.append(" AND (? OR ").append(addressHouseTableName).append('.').append("streetid=?)");
                where.append(" AND (? OR ").append(addressHouseTableName).append('.').append("house=?)");
                where.append(" AND (? OR ").append(addressHouseTableName).append('.').append("frac=?)");
                where.append(" AND (? OR ").append(tableName).append('.').append("pod=?)");
                where.append(" AND (? OR ").append(tableName).append('.').append("flat=?)");
                where.append(" AND (? OR ").append(tableName).append('.').append("room=?)");
            } else if (a instanceof FilterEntityAttrEmail) {
                tableName = this.getEmailDao().table + "_" + tableId;
                query.append(this.getEmailDao().table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append("email");
                switch (((FilterEntityAttrEmail)a).getMode()) {
                    case 1: {
                        where.append(" LIKE ?");
                        break;
                    }
                    case 2: {
                        where.append(" REGEXP ?");
                        break;
                    }
                    default: {
                        where.append(" REGEXP ?");
                        break;
                    }
                }
            } else if (a instanceof FilterEntityAttrContract) {
                tableName = this.getContractDao().table + "_" + tableId;
                query.append(this.getContractDao().table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append(this.support.typeName()).append("=?");
            } else if (a instanceof FilterEntityAttrPhone) {
                tableName = this.getPhoneDao().itemTable + "_" + tableId;
                query.append(this.getPhoneDao().itemTable).append(" AS ").append(tableName);
                where.append(tableName).append('.').append("phone");
                switch (((FilterEntityAttrPhone)a).getMode()) {
                    case 1: {
                        where.append(" LIKE ?");
                        break;
                    }
                    case 2: {
                        where.append(" REGEXP ?");
                        break;
                    }
                    default: {
                        where.append("=?");
                        break;
                    }
                }
            } else {
                throw new IllegalArgumentException();
            }
            query.append(" ON ").append(tableName).append('.').append(this.support.idName()).append('=').append(this.getEntityTableName()).append('.').append(this.support.beanIdName());
            query.append(" AND ").append(tableName).append('.');
            if (a instanceof FilterEntityAttrList) {
                query.append(this.support.defaultValueName());
            } else {
                query.append(this.support.typeName());
            }
            if (a.getEntitySpecAttrIds() != null && a.getEntitySpecAttrIds().size() > 0) {
                query.append(" IN (").append(Utils.toString((Iterable)a.getEntitySpecAttrIds())).append(")");
            }
            if (a instanceof FilterEntityAttrAddress) {
                query.append("\n LEFT JOIN address_house AS ").append(addressHouseTableName);
                query.append(" ON ").append(addressHouseTableName).append(".id=").append(tableName).append('.').append(this.getAddressDao().addressHouseIdName);
                query.append("\n LEFT JOIN address_street AS ").append(addressStreetTableName);
                query.append(" ON ").append(addressStreetTableName).append(".id=").append(addressHouseTableName).append('.').append("streetid");
            }
            where.append(")\n AND");
        }
        if (where.length() > whereLength) {
            where.setLength(where.length() - 5);
        }
    }

    public int filterToPS(PreparedStatement ps, int idx, List<FilterEntityAttr> entityFilter) throws SQLException {
        int size = entityFilter.size();
        block10: for (int i = 0; i < size; ++i) {
            FilterEntityAttr a = entityFilter.get(i);
            if (a instanceof FilterEntityAttrText) {
                FilterEntityAttrText attrText = (FilterEntityAttrText)a;
                switch (attrText.getMode()) {
                    case 1: {
                        ps.setString(++idx, "%" + attrText.getValue() + "%");
                        break;
                    }
                    default: {
                        ps.setString(++idx, attrText.getValue());
                        break;
                    }
                }
                continue;
            }
            if (a instanceof FilterEntityAttrInt) {
                FilterEntityAttrInt attrInt = (FilterEntityAttrInt)a;
                ps.setInt(++idx, attrInt.getValue());
                continue;
            }
            if (a instanceof FilterEntityAttrList) {
                FilterEntityAttrList attrList = (FilterEntityAttrList)a;
                ps.setInt(++idx, attrList.getValue());
                continue;
            }
            if (a instanceof FilterEntityAttrHouse) {
                FilterEntityAttrHouse attrHouse = (FilterEntityAttrHouse)a;
                ps.setInt(++idx, attrHouse.getValue());
                continue;
            }
            if (a instanceof FilterEntityAttrDate) {
                FilterEntityAttrDate attrDate = (FilterEntityAttrDate)a;
                if (attrDate.getPeriodFrom() != null && attrDate.getPeriodTo() != null && attrDate.getPeriodFrom().equals(attrDate.getPeriodTo())) {
                    ps.setDate(++idx, TimeUtils.convertDateToSqlDate((java.util.Date)attrDate.getPeriodFrom()));
                    continue;
                }
                Date periodFrom = TimeUtils.convertDateToSqlDate((java.util.Date)attrDate.getPeriodFrom());
                Date periodTo = TimeUtils.convertDateToSqlDate((java.util.Date)attrDate.getPeriodTo());
                ps.setDate(++idx, periodFrom);
                ps.setDate(++idx, periodFrom);
                ps.setDate(++idx, periodTo);
                ps.setDate(++idx, periodTo);
                continue;
            }
            if (a instanceof FilterEntityAttrAddress) {
                FilterEntityAttrAddress attrAddress = (FilterEntityAttrAddress)a;
                ps.setBoolean(++idx, attrAddress.getCityId() <= 0);
                ps.setInt(++idx, attrAddress.getCityId());
                ps.setBoolean(++idx, attrAddress.getStreetId() <= 0);
                ps.setInt(++idx, attrAddress.getStreetId());
                ps.setBoolean(++idx, Utils.isBlankString((String)attrAddress.getHouse()));
                ps.setString(++idx, attrAddress.getHouse());
                ps.setBoolean(++idx, Utils.isBlankString((String)attrAddress.getFrac()));
                ps.setString(++idx, attrAddress.getFrac());
                ps.setBoolean(++idx, attrAddress.getPod() <= 0);
                ps.setInt(++idx, attrAddress.getPod());
                ps.setBoolean(++idx, Utils.isBlankString((String)attrAddress.getFlat()));
                ps.setString(++idx, attrAddress.getFlat());
                ps.setBoolean(++idx, Utils.isBlankString((String)attrAddress.getRoom()));
                ps.setString(++idx, attrAddress.getRoom());
                continue;
            }
            if (a instanceof FilterEntityAttrEmail) {
                FilterEntityAttrEmail attrEmail = (FilterEntityAttrEmail)a;
                switch (attrEmail.getMode()) {
                    case 1: {
                        ps.setString(++idx, "%" + attrEmail.getValue() + "%");
                        break;
                    }
                    case 2: {
                        ps.setString(++idx, attrEmail.getValue());
                        break;
                    }
                    default: {
                        ps.setString(++idx, "[[:<:]]" + attrEmail.getValue() + "[[:>:]]");
                        break;
                    }
                }
                continue;
            }
            if (a instanceof FilterEntityAttrContract) {
                FilterEntityAttrContract attrContract = (FilterEntityAttrContract)a;
                ps.setInt(++idx, attrContract.getValue());
                continue;
            }
            if (!(a instanceof FilterEntityAttrPhone)) continue;
            FilterEntityAttrPhone attrPhone = (FilterEntityAttrPhone)a;
            switch (attrPhone.getMode()) {
                case 1: {
                    ps.setString(++idx, "%" + attrPhone.getValue() + "%");
                    continue block10;
                }
                default: {
                    ps.setString(++idx, attrPhone.getValue());
                }
            }
        }
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAddressItemUpdate(ServerContext context, Class<?> clazz, int id) throws SQLException, BGException {
        Class<AbstractEntityAttrDao> clazz2 = AbstractEntityAttrDao.class;
        synchronized (AbstractEntityAttrDao.class) {
            this.getAddressDao().onUpdate(context, clazz, id);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected void checkEntityAttribute(EntityAttr entityAttr) throws BGException {
        Directory<Id> dir = this.getEntitySpecAttrDirectory();
        AbstractSpecAttr entitySpecAttr = (AbstractSpecAttr)dir.get(entityAttr.getEntitySpecAttrId());
        if (entitySpecAttr != null) {
            switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)entitySpecAttr.getType()).get()) {
                case EMAIL: {
                    EntityAttrEmail.check((EntityAttrEmail)((EntityAttrEmail)entityAttr));
                    break;
                }
                case PHONE: {
                    EntityAttrPhoneDao.check((EntityAttrPhone)entityAttr, false);
                    break;
                }
            }
        }
    }

    private EntityAttrTextDao getTextDao() {
        if (this.textDao == null) {
            this.textDao = this.support.newTextDao(this.con, this);
        }
        return this.textDao;
    }

    private EntityAttrIntDao getIntDao() {
        if (this.intDao == null) {
            this.intDao = this.support.newIntDao(this.con, this);
        }
        return this.intDao;
    }

    private EntityAttrListDao getListDao() {
        if (this.listDao == null) {
            this.listDao = this.support.newListDao(this.con, this);
        }
        return this.listDao;
    }

    private EntityAttrDateDao getDateDao() {
        if (this.dateDao == null) {
            this.dateDao = this.support.newDateDao(this.con, this);
        }
        return this.dateDao;
    }

    private EntityAttrHouseDao getHouseDao() {
        if (this.houseDao == null) {
            this.houseDao = this.support.newHouseDao(this.con, this);
        }
        return this.houseDao;
    }

    private EntityAttrAddressDao getAddressDao() {
        if (this.addressDao == null) {
            this.addressDao = this.support.newAddressDao(this.con, this);
        }
        return this.addressDao;
    }

    private EntityAttrMultiListDao getMultiListDao() {
        if (this.multiListDao == null) {
            this.multiListDao = this.support.newMultiListDao(this.con, this);
        }
        return this.multiListDao;
    }

    private EntityAttrEmailDao getEmailDao() {
        if (this.emailDao == null) {
            this.emailDao = this.support.newEmailDao(this.con, this);
        }
        return this.emailDao;
    }

    private EntityAttrContractDao getContractDao() {
        if (this.contractDao == null) {
            this.contractDao = this.support.newContractDao(this.con, this);
        }
        return this.contractDao;
    }

    private EntityAttrBooleanDao getBooleanDao() {
        if (this.booleanDao == null) {
            this.booleanDao = this.support.newBooleanDao(this.con, this);
        }
        return this.booleanDao;
    }

    private EntityAttrPhoneDao getPhoneDao() {
        if (this.phoneDao == null) {
            this.phoneDao = this.support.newPhoneDao(this.con, this);
        }
        return this.phoneDao;
    }

    private EntityAttrServicingPersonDao getServicingPersonDao() {
        if (this.servicingPersonDao == null) {
            this.servicingPersonDao = this.support.newServicingPersonDao(this.con, this);
        }
        return this.servicingPersonDao;
    }

    protected static abstract class AddressItemModifiedEventListener
    implements EventListener<Event> {
        public AddressItemModifiedEventListener() throws BGException {
            new Thread("AddressItemModifiedEventListener-init"){

                @Override
                public void run() {
                    try {
                        EventProcessor ep = EventProcessor.getInstance();
                        ep.addListener(this, CityModifiedEvent.class);
                        ep.addListener(this, AreaModifiedEvent.class);
                        ep.addListener(this, StreetModifiedEvent.class);
                        ep.addListener(this, QuarterModifiedEvent.class);
                        ep.addListener(this, HouseModifiedEvent.class);
                    }
                    catch (BGException ex) {
                        LogManager.getLogger().error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }.start();
        }

        protected abstract AbstractEntityAttrDao<?> newDao(ServerContext var1);

        @Override
        public void notify(Event e, EventListenerContext ctx) throws BGException {
            Id id;
            Class<City> clazz;
            if (e instanceof CityModifiedEvent) {
                clazz = City.class;
                id = (Id)((CityModifiedEvent)e).getNewItem();
            } else if (e instanceof AreaModifiedEvent) {
                clazz = Area.class;
                id = (Id)((AreaModifiedEvent)e).getNewItem();
            } else if (e instanceof StreetModifiedEvent) {
                clazz = Street.class;
                id = (Id)((StreetModifiedEvent)e).getNewItem();
            } else if (e instanceof QuarterModifiedEvent) {
                clazz = Quarter.class;
                id = (Id)((QuarterModifiedEvent)e).getNewItem();
            } else if (e instanceof HouseModifiedEvent) {
                clazz = House.class;
                id = (Id)((HouseModifiedEvent)e).getNewItem();
            } else {
                return;
            }
            if (id == null) {
                return;
            }
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ServerContext context = new ServerContext(Setup.getSetup(), 0, 0);
                    context.init();
                    try {
                        AbstractEntityAttrDao<?> dao = this.newDao(context);
                        dao.onAddressItemUpdate(context, clazz, id.getId());
                        context.commit();
                    }
                    catch (Exception e) {
                        LogManager.getLogger().error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        context.destroy();
                    }
                }
            });
        }
    }
}

