/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrDateDao
extends EntityAttrDefaultDao<EntityAttrDate> {
    public EntityAttrDateDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String dateTable) {
        super(con, entityAttrDao, dateTable);
    }

    @Override
    protected void createTable() {
        try (Statement createStatement = this.con.createStatement();){
            createStatement.execute("CREATE TABLE IF NOT EXISTS `" + this.table + "` ( `entityId` int(11) NOT NULL DEFAULT 0, `entitySpecAttrId` int(11) NOT NULL DEFAULT 0, `value` date NULL DEFAULT NULL, PRIMARY KEY (`entityId`,`entitySpecAttrId`) )");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public EntityAttrDate get(int entityId, int attrSpecId) throws BGException {
        EntityAttrDate result = null;
        try (PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = new EntityAttrDate(entityId, attrSpecId, (Date)rs.getDate(1));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws SQLException {
        try (PreparedStatement ps = this.getInsertPS(entityId, a.getEntitySpecAttrId());){
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)((EntityAttrDate)a).getValue()));
            ps.executeUpdate();
        }
    }

    @Override
    protected boolean updateImpl(int entityId, EntityAttrDate attr) throws SQLException {
        PreparedStatement ps;
        java.sql.Date oldValue = null;
        try (PreparedStatement ps2 = this.getSelectPS(entityId, attr.getEntitySpecAttrId());
             ResultSet rs = ps2.executeQuery();){
            if (rs.next()) {
                oldValue = rs.getDate(1);
            }
        }
        if (attr.getValue() == null) {
            ps2 = this.getDeletePS(entityId, attr.getEntitySpecAttrId());
            try {
                ps2.executeUpdate();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
        }
        boolean update = false;
        if (oldValue != null) {
            ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());
            try {
                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)attr.getValue()));
                update = ps.executeUpdate() > 0;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        if (!update) {
            ps = this.getDeletePS(entityId, attr.getEntitySpecAttrId());
            try {
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            try {
                ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)attr.getValue()));
                ps.executeUpdate();
                boolean bl = true;
                return bl;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        return !TimeUtils.dateEqual((Date)attr.getValue(), (Date)oldValue);
    }

    @Override
    protected void insertHistory(int contractId, int entitySpecAttrId, EntityAttrDate attr) throws SQLException {
        try (PreparedStatement ps = this.getInsertHistiryPS();){
            ps.setInt(1, contractId);
            ps.setInt(2, entitySpecAttrId);
            ps.setDate(3, attr != null ? TimeUtils.convertDateToSqlDate((Date)attr.getValue()) : null);
            ps.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
            ps.setInt(5, this.entityAttrDao.userId);
            ps.executeUpdate();
        }
    }
}

