/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Id;

public abstract class AbstractIdDao<B extends Id>
extends AbstractDao<B> {
    public AbstractIdDao(Connection con, int moduleId, String tableName, Date date) {
        super(con, moduleId, tableName, date);
    }

    public AbstractIdDao(Connection con, int moduleId, String tableName) {
        super(con, moduleId, tableName);
    }

    public B get(int id) throws BGException {
        try {
            return (B)((Id)this.getImpl(id));
        }
        catch (SQLException e) {
            this.processException(e);
            return null;
        }
    }

    public Optional<B> opt(int id) {
        try {
            return Optional.ofNullable(this.get(id));
        }
        catch (Exception ex) {
            this.getLogger().error((Object)ex);
            return Optional.empty();
        }
    }

    public int delete(int id) throws BGException {
        try {
            return this.deleteImpl(id);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public B getAndUpdate(B b) throws BGException {
        B old = ((Id)b).getId() > 0 ? (B)this.get(((Id)b).getId()) : null;
        this.update(b);
        return old;
    }

    public B getAndDelete(int id) throws BGException {
        B old = this.get(id);
        this.delete(id);
        return old;
    }

    protected int executeUpdate(Id id, int index, PreparedStatement ps) throws SQLException {
        if (id.getId() > 0) {
            ps.setInt(index++, id.getId());
        }
        ps.executeUpdate();
        if (id.getId() < 1) {
            id.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        return index;
    }
}

