/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.model;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.common.TimeUtils;

public class Period
implements Comparable<Period> {
    private LocalDate localDateFrom;
    private LocalDate localDateTo;

    public Period() {
    }

    public Period(Date fromDate, Date toDate) {
        this.setDateFrom(fromDate);
        this.setDateTo(toDate);
    }

    public Period(LocalDate localDateFrom, LocalDate localDateTo) {
        this.setLocalDateFrom(localDateFrom);
        this.setLocalDateTo(localDateTo);
    }

    public Period(long startEpoch, long stopEpoch) {
        this.setLocalDateFrom(TimeUtils.convertSecEpochToLocalDateTime(startEpoch).toLocalDate());
        this.setLocalDateTo(TimeUtils.convertSecEpochToLocalDateTime(stopEpoch).toLocalDate());
    }

    public Period(int year, int month, int dayFrom, int dayTo) {
        LocalDate localDate = LocalDate.of(year, month + 1, 1);
        int maxday = localDate.lengthOfMonth();
        this.setLocalDateFrom(localDate.withDayOfMonth(dayFrom < 1 ? 1 : (dayFrom > maxday ? maxday : dayFrom)));
        this.setLocalDateTo(localDate.withDayOfMonth(dayTo < 1 ? 1 : (dayTo > maxday ? maxday : dayTo)));
    }

    @XmlAttribute
    public Date getDateFrom() {
        return TimeUtils.convertLocalDateToDate(this.localDateFrom);
    }

    public void setDateFrom(Date date) {
        this.localDateFrom = TimeUtils.convertDateToLocalDate(date);
    }

    @XmlAttribute
    public LocalDate getLocalDateFrom() {
        return this.localDateFrom;
    }

    public void setLocalDateFrom(LocalDate localDate) {
        this.localDateFrom = localDate;
    }

    public int getMonthFrom() {
        int month = -1;
        if (this.localDateFrom != null) {
            month = this.localDateFrom.getMonthValue();
        }
        return month;
    }

    public int getYearFrom() {
        int year = -1;
        if (this.localDateFrom != null) {
            year = this.localDateFrom.getYear();
        }
        return year;
    }

    @XmlAttribute
    public Date getDateTo() {
        return TimeUtils.convertLocalDateToDate(this.localDateTo);
    }

    public void setDateTo(Date date) {
        this.localDateTo = TimeUtils.convertDateToLocalDate(date);
    }

    @XmlAttribute
    public LocalDate getLocalDateTo() {
        return this.localDateTo;
    }

    public void setLocalDateTo(LocalDate localDate) {
        this.localDateTo = localDate;
    }

    public Calendar getDateFromCalendar() {
        return TimeUtils.convertLocalDateToCalendar(this.localDateFrom);
    }

    public Calendar getDateToCalendar() {
        return TimeUtils.convertLocalDateToCalendar(this.localDateTo);
    }

    public String toString() {
        return TimeUtils.formatPeriod(this);
    }

    @Override
    public int compareTo(Period period) {
        LocalDate periodDateTo;
        int result = 0;
        LocalDate periodDateFrom = period != null && period.getLocalDateFrom() != null ? period.getLocalDateFrom() : null;
        LocalDate localDate = periodDateTo = period != null && period.getLocalDateTo() != null ? period.getLocalDateTo() : null;
        result = this.localDateFrom == null ? (periodDateFrom == null ? (this.localDateTo == null ? (periodDateTo == null ? 0 : -1) : this.localDateTo.compareTo(periodDateTo)) : -1) : (periodDateFrom == null ? 1 : (this.localDateFrom.equals(periodDateFrom) ? (this.localDateTo == null ? (periodDateTo == null ? 0 : -1) : this.localDateTo.compareTo(periodDateTo)) : this.localDateFrom.compareTo(periodDateFrom)));
        return result;
    }

    public Period copy() {
        return new Period(this.getLocalDateFrom(), this.getLocalDateTo());
    }
}

