/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.ModelPeriod;
import java.awt.Insets;
import java.time.LocalDate;
import java.util.Calendar;
import javax.swing.JButton;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;

class BGNavButton
extends JButton {
    protected Calendar dateFrom;
    protected Calendar dateTo;
    protected final ModelPeriod model;
    protected boolean forward;
    protected String propertyName;

    public BGNavButton(ModelPeriod model) {
        this.model = model;
        this.setMargin(new Insets(0, 5, 0, 5));
        this.dateFrom = Calendar.getInstance();
        this.dateTo = Calendar.getInstance();
        this.jbInit();
    }

    public void setDateFrom(Calendar dateFrom) {
        this.dateFrom = dateFrom;
    }

    public void setDateTo(Calendar dateTo) {
        this.dateTo = dateTo;
    }

    public LocalDate getDateFrom() {
        return this.dateFrom != null ? TimeUtils.convertDateToLocalDate(this.dateFrom.getTime()) : null;
    }

    public LocalDate getDateTo() {
        return this.dateTo != null ? TimeUtils.convertDateToLocalDate(this.dateTo.getTime()) : null;
    }

    protected void jbInit() {
        this.addActionListener(e -> {
            try {
                switch (this.model.getMode()) {
                    case 0: {
                        int delta = TimeUtils.daysDelta(this.dateFrom, this.dateTo) + 1;
                        this.dateFrom = this.model.daysOperation(this.dateFrom, this.forward, delta);
                        this.dateTo = this.model.daysOperation(this.dateTo, this.forward, delta);
                        break;
                    }
                    case 1: {
                        this.dateFrom = this.model.getDateToMode(this.dateFrom, this.forward, true);
                        this.dateTo = this.model.getDateToMode(this.dateTo, this.forward, false);
                        break;
                    }
                    case 2: {
                        this.dateFrom = this.model.getDateToMode(this.dateFrom, this.forward, true);
                        this.dateTo = this.model.getDateToMode(this.dateTo, this.forward, false);
                        break;
                    }
                    case 3: {
                        this.dateFrom = this.model.getDateToMode(this.dateFrom, this.forward, true);
                        this.dateTo = this.model.getDateToMode(this.dateTo, this.forward, false);
                    }
                }
                this.firePropertyChange(this.propertyName, true, false);
            }
            catch (BGException ex) {
                ex.printStackTrace();
            }
        });
    }
}

