/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.contract.RuleEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractGroupService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;

public class DeleteContractEditor
extends BGPanel
implements ActionListener {
    private BGButtonPanelRestoreOkCancelHelp bGControlPanel_02 = new BGButtonPanelRestoreOkCancelHelp();
    private JComboBox<ComboBoxItem> servicesBox = new JComboBox();
    private DefaultTableModel model = new DefaultTableModel();
    private BGTable tableDeleteTime = new BGTable();
    private BGTable tableDeleteMoney = new BGTable();
    private RuleEditor serviceConditionEditor = new RuleEditor();
    private JPanel topPanel = new JPanel(new GridBagLayout());
    private JPanel editorPanel = new JPanel(new GridBagLayout());
    private BGDialogToolBar dialogToolBar = new BGDialogToolBar();
    private JScrollPane jScrollPane = new JScrollPane(this.tableDeleteTime);
    private BGSplitPaneNoBorder tableAndEditorSplit = new BGSplitPaneNoBorder(0, this.jScrollPane, (Component)this.editorPanel, 300L);
    private ContractGroupService contractGroupService = null;
    private ContractStatusService contractStatusService = null;

    public DeleteContractEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dialogToolBar.setDefaultButtons(this, BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.COPY_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM, BGDialogToolBar.ButtonData.SEPARATOR, BGDialogToolBar.ButtonData.REFRESH, BGDialogToolBar.ButtonData.SEPARATOR);
        this.dialogToolBar.setOrientation(0);
        this.servicesBox.addItem(new ComboBoxItem("1", "\u043f\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438"));
        this.servicesBox.addItem(new ComboBoxItem("2", "\u043f\u043e \u0441\u0443\u043c\u043c\u0435"));
        this.servicesBox.setEnabled(true);
        this.tableDeleteTime.setHeader(this.rb_name, this.moduleDoc, "rule_delete_time");
        this.tableDeleteMoney.setHeader(this.rb_name, this.moduleDoc, "rule_delete_money");
        this.editorPanel.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.setSize(500, 400);
        this.setLayout(new GridBagLayout());
        this.bGControlPanel_02.addActionListener(e -> this.bGControlPanel_02_actionPerformed(e));
        this.servicesBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DeleteContractEditor.this.servicesBox_itemStateChanged(e);
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) == 0) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    DeleteContractEditor.this.editItem();
                }
            }
        };
        this.tableDeleteTime.addMouseListener(mouseAdapter);
        this.tableDeleteMoney.addMouseListener(mouseAdapter);
        this.topPanel.add((Component)this.dialogToolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.topPanel.add((Component)new JLabel("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0442\u0438\u043f\u0443:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 50, 0, 0), 15, 0));
        this.topPanel.add(this.servicesBox, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 1), 0, 0));
        this.editorPanel.add((Component)this.serviceConditionEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.editorPanel.add((Component)this.bGControlPanel_02, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.tableAndEditorSplit, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetRuleTime");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.tableDeleteTime.updateData(XMLUtils.selectNode(doc, "//table"));
        }
        request = new Request();
        request.setModule(this.module);
        request.setAction("GetRuleMoney");
        doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.tableDeleteMoney.updateData(XMLUtils.selectNode(doc, "//table"));
        }
        try {
            this.serviceConditionEditor.getGroupCheckList().setData(this.getContractGroupService().contractGroupList(false, "title"));
            this.serviceConditionEditor.getStatusCheckList().setData(this.getContractStatusService().getStatusList(false));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("newItem".equals(actionCommand)) {
            this.newItem();
        } else if ("copyItem".equals(actionCommand)) {
            this.copyItem();
        } else if ("editItem".equals(actionCommand)) {
            this.editItem();
        } else if ("deleteItem".equals(actionCommand)) {
            this.deleteItem();
        }
    }

    @Override
    public void newItem() {
        int type = this.servicesBox.getSelectedIndex() + 1;
        this.serviceConditionEditor.init("new", type);
        this.serviceConditionEditor.refresh();
        this.editorPanel.setVisible(true);
        this.servicesBox.setEnabled(false);
        this.serviceConditionEditor.getGroupCheckList().clearSelection();
        this.revalidateSplit();
    }

    @Override
    public void editItem() {
        this.selectTableModel();
        int type = this.servicesBox.getSelectedIndex() + 1;
        int selRow = -1;
        String id = null;
        if (type == 1) {
            selRow = this.tableDeleteTime.getSelectedRow();
            id = ClientUtils.getRowId(this.tableDeleteTime, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u043e \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", null);
        } else if (type == 2) {
            selRow = this.tableDeleteMoney.getSelectedRow();
            id = ClientUtils.getRowId(this.tableDeleteMoney, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u043e \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", null);
        }
        if (id == null) {
            return;
        }
        Vector row = this.model.getDataVector().get(selRow);
        this.serviceConditionEditor.init((String)row.get(0), type);
        this.serviceConditionEditor.edit(type, row);
        this.editorPanel.setVisible(true);
        this.servicesBox.setEnabled(false);
        this.revalidateSplit();
    }

    @Override
    public void deleteItem() {
        String tcid = null;
        int type = this.servicesBox.getSelectedIndex() + 1;
        int selRow = -1;
        if (type == 1) {
            selRow = this.tableDeleteTime.getSelectedRow();
            tcid = ClientUtils.getRowId(this.tableDeleteTime, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u043e \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", null);
            if (tcid == null) {
                return;
            }
        } else if (type == 2) {
            selRow = this.tableDeleteMoney.getSelectedRow();
            tcid = ClientUtils.getRowId(this.tableDeleteMoney, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u043e \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", null);
            if (tcid == null) {
                return;
            }
        }
        if (selRow != -1 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u043e?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u0430", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction(type == 1 ? "DeleteRuleTime" : "DeleteRuleMoney");
            request.setAttribute("id", tcid);
            this.getDocument(request);
            this.setData();
        }
        selRow = -1;
        this.serviceConditionEditor.setVisible(false);
    }

    private void servicesBox_itemStateChanged(ItemEvent e) {
        this.selectTableModel();
        this.jScrollPane.getViewport().removeAll();
        int type = this.servicesBox.getSelectedIndex() + 1;
        this.jScrollPane.getViewport().add((Component)(type == 1 ? this.tableDeleteTime : this.tableDeleteMoney), null);
        if (type == 1) {
            this.jScrollPane.getViewport().add((Component)this.tableDeleteTime, null);
        } else if (type == 2) {
            this.jScrollPane.getViewport().add((Component)this.tableDeleteMoney, null);
        }
    }

    private void selectTableModel() {
        int type = this.servicesBox.getSelectedIndex() + 1;
        if (type == 1) {
            this.model = (DefaultTableModel)this.tableDeleteTime.getModel();
        } else if (type == 2) {
            this.model = (DefaultTableModel)this.tableDeleteMoney.getModel();
        }
    }

    private void bGControlPanel_02_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            int type = this.servicesBox.getSelectedIndex() + 1;
            int selRow = type == 1 ? this.tableDeleteTime.getSelectedRow() : this.tableDeleteMoney.getSelectedRow();
            this.serviceConditionEditor.edit(type, this.model.getDataVector().get(selRow));
        } else if ("ok".equals(actionCommand)) {
            int type = this.servicesBox.getSelectedIndex() + 1;
            if (this.serviceConditionEditor.okButtonClick(Integer.toString(type))) {
                this.setData();
            }
            this.editorPanel.setVisible(false);
            this.servicesBox.setEnabled(true);
        } else if ("cancel".equals(actionCommand)) {
            this.servicesBox.setEnabled(true);
            this.editorPanel.setVisible(false);
        }
    }

    private void revalidateSplit() {
        this.tableAndEditorSplit.setDividerSize(5);
        this.tableAndEditorSplit.setDividerLocation(0.7);
        this.tableAndEditorSplit.revalidate();
    }

    private ContractGroupService getContractGroupService() {
        if (this.contractGroupService == null) {
            this.contractGroupService = this.getContext().getPort(ContractGroupService.class, 0);
        }
        return this.contractGroupService;
    }

    private ContractStatusService getContractStatusService() {
        if (this.contractStatusService == null) {
            this.contractStatusService = this.getContext().getPort(ContractStatusService.class, 0);
        }
        return this.contractStatusService;
    }
}

