/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.common.BGFrame;
import bitel.billing.module.common.DBInfoManager;
import bitel.billing.module.common.ServerCommandWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.BGClientInit;
import ru.bitel.bgbilling.client.about.client.AboutDialog;
import ru.bitel.bgbilling.client.common.BGClientToolBar;
import ru.bitel.bgbilling.client.common.BGMenuBar;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.ClosedTabs;
import ru.bitel.bgbilling.client.event.UpdateMenuTolbarEvent;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractTabbedPane;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.client.inpoint.OnDestroyClient;
import ru.bitel.bgbilling.kernel.plugin.client.inpoint.OnInitClient;
import ru.bitel.bgbilling.kernel.plugin.client.inpoint.OnStart;
import ru.bitel.bgbilling.kernel.plugin.client.inpoint.OnStop;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.LookAndFeelUtils;

public class BGClientBase
extends BGFrame {
    private JPanel bottomPanel = null;
    protected BGMenuBar menuBar;
    protected BGClientToolBar toolBar;
    protected ContractTabbedPane tabbedPane;
    protected DBInfoManager dbInfoManager;
    protected static BGClientBase shellFrame;
    protected static Map<String, FontUIResource> defaultUIFontMap;
    private static final String HOT_KEY_GLOBAL_ADD = "hotkey.global.add";
    private static final String HOT_KEY_GLOBAL_EDIT = "hotkey.global.edit";
    private static final String HOT_KEY_GLOBAL_DELETE = "hotkey.global.delete";

    protected BGClientBase() {
        shellFrame = this;
        JOptionPane.setRootFrame(this);
        UIManager.put("OptionPane.yesButtonText", "\u0414\u0430");
        UIManager.put("OptionPane.noButtonText", "\u041d\u0435\u0442");
        UIManager.put("OptionPane.cancelButtonText", "\u041e\u0442\u043c\u0435\u043d\u0430");
        UIManager.put("OptionPane.okButtonText", "\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        this.setup = ClientSetup.getInstance();
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            defaultUIFontMap.put((String)key, (FontUIResource)value);
        }
        String fontConfig = this.setup.getUserConfig().get("client.ui.fonts");
        if (fontConfig != null) {
            JSONArray fontArray = new JSONArray(fontConfig);
            for (int index = 0; index < fontArray.length(); ++index) {
                JSONObject json = fontArray.getJSONObject(index);
                UIManager.put(json.getString("key"), new FontUIResource(json.getString("name"), json.getInt("style"), json.getInt("size")));
            }
        }
        this.dbInfoManager = DBInfoManager.getManager();
    }

    protected void init1(boolean showAboutDialog) {
        AboutDialog dialog = null;
        try {
            if (showAboutDialog) {
                dialog = new AboutDialog(false);
            }
            BGPluginManagerClient.init();
            Document doc = XMLUtils.newDocument();
            XMLUtils.createElement(doc, "data");
            this.setup.putObject("doc", doc);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setup.getUserConfig().set(LookAndFeelUtils.class.getName() + ".laf", this.setup.get("look.and.feel.default", System.getProperty("look.and.feel.default", "javax.swing.plaf.metal.MetalLookAndFeel")));
            this.setup.getUserConfig().set(LookAndFeelUtils.class.getName() + ".lafTheme", this.setup.get("look.and.feel.default.theme", System.getProperty("look.and.feel.default.theme", "")));
            this.setup.saveUserConfig();
            ClientUtils.showErrorMessageDialog("\u041f\u0440\u0438 \u0437\u0430\u043f\u0443\u0441\u043a\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430.\n\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0432\u0438\u0434 \u0438 \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e. \u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a.");
        }
        if (dialog != null) {
            dialog.dispose();
        }
        BGClientInit.init_UncaughtExceptionHandler();
        this.loadFrameGeometry();
        this.pack();
        this.setVisible(true);
        for (OnInitClient p : BGPluginManagerClient.getManager().getInvokeables(OnInitClient.class, false)) {
            p.onInitClient();
        }
    }

    protected void init2() {
        this.subcribeEvents();
        System.setProperty("java.protocol.handler.pkgs", "bitel.billing.common.protocol");
        List<Integer> contractIdsList = Utils.toIntegerList(System.getProperty("client.start.open.contractIds", this.setup.get("client.start.open.contractIds", null)));
        for (Integer cid : contractIdsList) {
            this.getTabbedPane().addContractEditorTab(cid);
        }
    }

    protected void jbInit() throws Exception {
    }

    protected void jbInit(boolean showBottomPanel) throws Exception {
        try {
            this.menuBar = new BGMenuBar();
            this.toolBar = new BGClientToolBar();
            this.toolBar.setFloatable(false);
            this.toolBar.setVisible(false);
            this.tabbedPane = new ContractTabbedPane();
            this.setHotkeys();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e.getMessage());
            e.printStackTrace();
        }
        this.setTitle("BGBillingClient (\u0432\u0435\u0440. ???)");
        this.setJMenuBar(this.menuBar);
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        if (showBottomPanel) {
            this.getContentPane().add((Component)this.getBottomPanel(), "South");
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BGClientBase.this.onShellFrameClosing(false);
            }
        });
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (e.getOppositeWindow() == null) {
                    ServerCommandWorker.doCommands(BGClientBase.getFrame(), BGClientBase.this.dbInfoManager);
                }
            }
        });
    }

    public DBInfo auth(DBInfo dbInfo) {
        DBInfo active = this.dbInfoManager.getActiveDBInfo();
        if (active != null) {
            this.dbInfoManager.saveTabs(active);
        }
        return null;
    }

    protected DBInfo auth5(DBInfo dbInfo) {
        this.addjustFrame(this.dbInfoManager, dbInfo);
        for (OnStart p : BGPluginManagerClient.getManager().getInvokeables(OnStart.class, false)) {
            p.onStart();
        }
        return null;
    }

    public ContractTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void switchServer(DBInfo dbInfo) {
        DBInfo active = this.dbInfoManager.getActiveDBInfo();
        if (active != null && active.getDbServerKey().equals(dbInfo.getDbServerKey())) {
            this.setBarData(dbInfo);
        } else {
            if (this.dbInfoManager.getActiveDBInfo() != null) {
                for (OnStop onStop : BGPluginManagerClient.getManager().getInvokeables(OnStop.class, false)) {
                    onStop.onStop();
                }
            }
            BGPluginManagerClient.getManager().setPluginsOnServer(this.dbInfoManager.getServerPluginSet());
            BGClientBase.getFrame().getTabbedPane().removeAll();
            this.dbInfoManager.setActiveDBInfo(dbInfo);
            this.addjustFrame(this.dbInfoManager, dbInfo);
            for (OnStart onStart : BGPluginManagerClient.getManager().getInvokeables(OnStart.class, false)) {
                onStart.onStart();
            }
        }
    }

    protected void setBarData(DBInfo dbInfo) {
        if (dbInfo != null) {
            TimeZone.setDefault(dbInfo.getTimeZone());
            this.menuBar.setData(dbInfo.getMenuBarNode());
            this.toolBar.setToolData(dbInfo.getToolBarNode());
        }
        this.toolBar.setVisible(true);
        this.toolBar.repaint();
    }

    protected void subcribeEvents() {
        EventBus.subscribeStrongly(UpdateMenuTolbarEvent.class, (EventSubscriber)new EventSubscriber<UpdateMenuTolbarEvent>(){

            public void onEvent(UpdateMenuTolbarEvent e) {
                DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
                DBInfoManager.getManager().setMenuToolBarData(dbInfo);
                BGClientBase.this.setBarData(dbInfo);
            }
        });
    }

    protected void saveFrameGeometry() {
        this.setup.getUserConfig().set("shellframe_state", String.valueOf(this.getExtendedState()));
        this.setup.getUserConfig().set("shellframe_x", String.valueOf(this.getLocation().x));
        this.setup.getUserConfig().set("shellframe_y", String.valueOf(this.getLocation().y));
        this.setup.getUserConfig().set("shellframe_width", String.valueOf(this.getSize().width));
        this.setup.getUserConfig().set("shellframe_height", String.valueOf(this.getSize().height));
    }

    protected static void loadUserEmail(DBInfo dbInfo) {
        String email = null;
        try {
            email = new ClientContext("kernel", 0, 0, null, null).getPort(UserService.class).getCurrentUserEmail();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
        if (Utils.notBlankString(email)) {
            dbInfo.setDbServerEmail(email);
        }
    }

    protected void loadFrameGeometry() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        DisplayMode mode = device.getDisplayMode();
        Insets scrIns = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        for (GraphicsDevice gd : ge.getScreenDevices()) {
            System.out.println("GraphicsDevice: " + gd.getIDstring() + (gd.equals(device) ? " (default)" : ""));
            DisplayMode dm = gd.getDisplayMode();
            Insets si = Toolkit.getDefaultToolkit().getScreenInsets(gd.getDefaultConfiguration());
            System.out.println(String.format("\tDisplayMode: %sx%sx%sx%s", dm.getWidth(), dm.getHeight(), dm.getBitDepth(), dm.getRefreshRate()));
            System.out.println(String.format("\tScreenInsets: top=%s,left=%s,bottom=%s,right=%s", si.top, si.left, si.bottom, si.right));
        }
        System.out.println(String.format("ScreenInsets(def): top=%s,left=%s,bottom=%s,right=%s", scrIns.top, scrIns.left, scrIns.bottom, scrIns.right));
        int scr_width = mode.getWidth();
        int scr_height = mode.getHeight();
        int work_area_x = 0 + scrIns.left;
        int work_area_y = 0 + scrIns.top;
        int work_area_width = scr_width - scrIns.left - scrIns.right;
        int work_area_height = scr_height - scrIns.bottom - scrIns.top;
        int padding = BGClientInit.isMacOs() ? 20 : 5;
        boolean isMaximizedGlitch = Arrays.asList("gnome-shell", "gnome", "mate").contains(System.getenv("DESKTOP_SESSION"));
        int default_x = work_area_x + padding;
        int default_y = work_area_y + padding;
        int default_width = work_area_width - padding * 2;
        int default_height = work_area_height - padding * 2;
        int default_state = this.getToolkit().isFrameStateSupported(6) && !isMaximizedGlitch ? 6 : 0;
        int x = this.setup.getUserConfig().getInt("shellframe_x", default_x);
        int y = this.setup.getUserConfig().getInt("shellframe_y", default_y);
        int width = this.setup.getUserConfig().getInt("shellframe_width", default_width);
        int height = this.setup.getUserConfig().getInt("shellframe_height", default_height);
        int state = this.setup.getUserConfig().getInt("shellframe_state", default_state);
        if (BGClientInit.isMacOs() && state == 6) {
            x = default_x;
            y = default_y;
            width = default_width;
            height = default_height;
        }
        this.setLocation(x, y);
        this.setSize(new Dimension(width, height));
        this.setPreferredSize(this.getSize());
        this.setExtendedState(state);
    }

    public static BGClientBase getFrame() {
        return shellFrame;
    }

    protected void onShellFrameClosing(boolean update) {
        for (OnDestroyClient p : BGPluginManagerClient.getManager().getInvokeables(OnDestroyClient.class, false)) {
            p.onDestroyClient();
        }
        this.saveFrameGeometry();
        ClientSetup.getInstance().saveUserConfig();
    }

    protected void setHotkeys() {
        BGSwingUtilites.bindMenuKeyStrokes(ClientSetup.getInstance(), this.getRootPane(), this.menuBar, this.tabbedPane);
        KeyStroke keyStroke = null;
        ActionMap actionMap = this.tabbedPane.getActionMap();
        InputMap inputMap = this.tabbedPane.getInputMap(2);
        AbstractAction addAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component selectedTab = BGClientBase.this.tabbedPane.getSelectedTab();
                if (selectedTab != null) {
                    if (selectedTab instanceof BGTabPanel) {
                        ((BGTabPanel)selectedTab).newItem();
                    } else {
                        ((BGUTabPanel)selectedTab).performAction("new");
                    }
                }
            }
        };
        keyStroke = BGClientBase.getKeystrokeFromUserConfig(HOT_KEY_GLOBAL_ADD, KeyStroke.getKeyStroke(78, 512));
        inputMap.put(keyStroke, "global.add");
        actionMap.put("global.add", addAction);
        AbstractAction editAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component selectedTab = BGClientBase.this.tabbedPane.getSelectedTab();
                if (selectedTab != null) {
                    if (selectedTab instanceof BGTabPanel) {
                        ((BGTabPanel)selectedTab).editItem();
                    } else {
                        ((BGUTabPanel)selectedTab).performAction("edit");
                    }
                }
            }
        };
        keyStroke = BGClientBase.getKeystrokeFromUserConfig(HOT_KEY_GLOBAL_EDIT, KeyStroke.getKeyStroke(69, 512));
        inputMap.put(keyStroke, "global.edit");
        actionMap.put("global.edit", editAction);
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component selectedTab = BGClientBase.this.tabbedPane.getSelectedTab();
                if (selectedTab != null) {
                    if (selectedTab instanceof BGTabPanel) {
                        ((BGTabPanel)selectedTab).deleteItem();
                    } else {
                        ((BGUTabPanel)selectedTab).performAction("delete");
                    }
                }
            }
        };
        keyStroke = BGClientBase.getKeystrokeFromUserConfig(HOT_KEY_GLOBAL_DELETE, KeyStroke.getKeyStroke(68, 512));
        inputMap.put(keyStroke, "global.delete");
        actionMap.put("global.delete", deleteAction);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Point tp = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(tp, BGClientBase.this.tabbedPane);
                Object offset = "";
                for (Component c = BGClientBase.this.tabbedPane.findComponentAt(tp); c != null; c = c.getParent()) {
                    String packeg = c.getClass().getPackage().getName();
                    String name = c.getClass().getSimpleName();
                    if (packeg.indexOf("bitel") <= -1 || name.indexOf("BGClient") != -1) continue;
                    System.out.printf((String)offset + "%s.%s(%s:%s)%n", c.getClass().getName(), "", c.getClass().getSimpleName() + ".java", "1");
                    offset = (String)offset + "   ";
                }
            }
        };
        String sCodes = System.getProperty("shortCodeForSearchOfClasses", this.setup.get("shortCodeForSearchOfClasses", null));
        if (sCodes != null && sCodes.indexOf(",") != -1) {
            List<Integer> list = Utils.toIntegerList(sCodes);
            int modifiers = list.size() > 2 ? list.get(1) | list.get(2) : list.get(1);
            keyStroke = KeyStroke.getKeyStroke(list.get(0), modifiers);
        } else {
            keyStroke = KeyStroke.getKeyStroke(88, 640);
        }
        inputMap.put(keyStroke, keyStroke.toString());
        actionMap.put(keyStroke.toString(), action);
        KeyStroke switchTabToLeft = KeyStroke.getKeyStroke(37, 128);
        inputMap.put(switchTabToLeft, switchTabToLeft.toString());
        actionMap.put(switchTabToLeft.toString(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGClientBase.this.switchTab(true);
            }
        });
        KeyStroke switchTabToRight = KeyStroke.getKeyStroke(39, 128);
        inputMap.put(switchTabToRight, switchTabToRight.toString());
        actionMap.put(switchTabToRight.toString(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGClientBase.this.switchTab(false);
            }
        });
        KeyStroke openLastClosedTab = KeyStroke.getKeyStroke(89, 192);
        inputMap.put(openLastClosedTab, openLastClosedTab.toString());
        actionMap.put(openLastClosedTab.toString(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClosedTabs.getInstance().openLastClosedTab();
            }
        });
        KeyStroke openLastClosedTabsDialog = KeyStroke.getKeyStroke(84, 192);
        inputMap.put(openLastClosedTabsDialog, openLastClosedTabsDialog.toString());
        actionMap.put(openLastClosedTabsDialog.toString(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClosedTabs.getInstance().showClosedTabsDialog();
            }
        });
        for (Map.Entry entry : UIManager.getLookAndFeelDefaults().entrySet()) {
            InputMap map;
            if (entry.getKey().toString().lastIndexOf("focusInputMap") <= -1 || entry.getKey().toString().lastIndexOf("focusInputMap.") != -1 || (map = (InputMap)UIManager.get(entry.getKey())) == null) continue;
            map.put(keyStroke, keyStroke.toString());
        }
        if (BGClientInit.isMacOs()) {
            InputMap[] imMass;
            for (InputMap map : imMass = new InputMap[]{(InputMap)UIManager.get("TextField.focusInputMap"), (InputMap)UIManager.get("TextArea.focusInputMap"), (InputMap)UIManager.get("TextPane.focusInputMap"), (InputMap)UIManager.get("EditorPane.focusInputMap"), (InputMap)UIManager.get("PasswordField.focusInputMap")}) {
                int modif = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
                if (map == null) continue;
                map.put(KeyStroke.getKeyStroke(67, modif), "copy-to-clipboard");
                map.put(KeyStroke.getKeyStroke(86, modif), "paste-from-clipboard");
                map.put(KeyStroke.getKeyStroke(88, modif), "cut-to-clipboard");
                map.put(KeyStroke.getKeyStroke(65, modif), "select-all");
                map.put(KeyStroke.getKeyStroke(37, modif), "caret-begin-line");
                map.put(KeyStroke.getKeyStroke(39, modif), "caret-end-line");
                map.put(KeyStroke.getKeyStroke(38, modif), "caret-begin");
                map.put(KeyStroke.getKeyStroke(40, modif), "caret-end");
                map.put(KeyStroke.getKeyStroke(37, modif | 0x40), "selection-begin-line");
                map.put(KeyStroke.getKeyStroke(39, modif | 0x40), "selection-end-line");
                map.put(KeyStroke.getKeyStroke(38, modif | 0x40), "selection-begin");
                map.put(KeyStroke.getKeyStroke(40, modif | 0x40), "selection-end");
            }
        }
    }

    private void switchTab(boolean toLeft) {
        JPanel selectedTab = (JPanel)this.tabbedPane.getSelectedTab();
        if (selectedTab != null) {
            List<JPanel> tabs = this.tabbedPane.getTabList();
            int selectedIndex = tabs.indexOf(selectedTab);
            JPanel newTab = null;
            if (toLeft && selectedIndex - 1 >= 0) {
                newTab = tabs.get(--selectedIndex);
            } else if (!toLeft && selectedIndex + 1 < tabs.size()) {
                newTab = tabs.get(++selectedIndex);
            }
            if (newTab != null) {
                this.tabbedPane.setSelectedIndex(selectedIndex);
                this.tabbedPane.revalidate();
                this.tabbedPane.repaint();
            }
        }
    }

    protected static KeyStroke getKeystrokeFromUserConfig(String key, KeyStroke defaultKeyStroke) {
        KeyStroke keyStroke = defaultKeyStroke;
        String conf = ClientSetup.getInstance().get(key, "");
        if (Utils.notBlankString(conf)) {
            keyStroke = KeyStroke.getKeyStroke(conf);
        }
        return keyStroke;
    }

    protected void setFrameTitle(DBInfo dbInfo) {
        String frameTitle = this.getTitle();
        int pos = frameTitle.indexOf(")");
        if (pos > 0) {
            this.setTitle(frameTitle.substring(0, pos + 1) + " " + (dbInfo != null ? dbInfo.getFirmTitle() : ""));
        }
    }

    protected void addjustFrame(DBInfoManager dbInfoManager, DBInfo dbInfo) {
        this.setBarData(dbInfo);
        this.setFrameTitle(dbInfo);
        dbInfoManager.loadTabs(dbInfo);
        for (BGPlugInElement extension : BGPluginManagerClient.getManager().getExtensions(BGClientBase.class.getCanonicalName(), false)) {
            try {
                for (Element element : XMLUtils.elements(extension.getElement().getChildNodes())) {
                    String className;
                    if (!"executorService".equals(element.getNodeName()) || (className = XMLUtils.getAttribute(element, "className", null)) == null) continue;
                    try {
                        Object object = Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                        int nThreads = Utils.parseInt(XMLUtils.getAttribute(element, "nThreads", "1"), 1);
                        ExecutorService messageForUserExecutorService = Executors.newFixedThreadPool(nThreads);
                        messageForUserExecutorService.submit((Runnable)object);
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430! " + ex.getMessage());
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected static void restartShellFrame() {
        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430  \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0430.", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0);
        BGClientBase.close(true);
    }

    public static void close() {
        BGClientBase.close(false);
    }

    public static void close(boolean update) {
        shellFrame.onShellFrameClosing(update);
        System.exit(0);
    }

    protected JPanel getBottomPanel() {
        JLabel label = new JLabel("<html>\u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415! \u0412\u0435\u0440\u0441\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0433\u043e \u041f\u041e \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430. \u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043b\u0438\u0435\u043d\u0442.</html>");
        label.setFont(new Font("Dialog", 1, 17));
        label.setHorizontalAlignment(0);
        label.setForeground(Color.WHITE);
        JButton quitButton = new JButton("\u0412\u044b\u0439\u0442\u0438 \u0438\u0437 \u043a\u043b\u0438\u0435\u043d\u0442\u0430");
        quitButton.addActionListener(e -> BGClientBase.close());
        this.bottomPanel = new JPanel(new GridBagLayout());
        this.bottomPanel.setVisible(false);
        this.bottomPanel.setBackground(Color.RED);
        this.bottomPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(15, 50, 15, 50), 0, 0));
        this.bottomPanel.add((Component)quitButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(15, 50, 15, 50), 0, 0));
        return this.bottomPanel;
    }

    public void checkClientVersion(String serverVersion) {
        String clientVersion = BGClientInit.getClientVersion();
        if (Utils.notEmptyString(clientVersion) && this.bottomPanel != null && !this.bottomPanel.isVisible() && !clientVersion.equals(serverVersion)) {
            this.bottomPanel.setVisible(true);
        }
    }

    public Map<String, FontUIResource> getDefaultUIFontMap() {
        return defaultUIFontMap;
    }

    static {
        defaultUIFontMap = new HashMap<String, FontUIResource>();
    }
}

