/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.RadioButtonTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.RowData;

public class StatusMatrixPanel
extends BGUPanel {
    private JPopupMenu popupMenu = null;
    private List<Status> statusList = new ArrayList<Status>();
    private List<Integer> statusIds = new ArrayList<Integer>();
    private BGUTable matrixTable = null;
    private BGUTable defaultMatrixTable = null;
    private MatrixTableModel matrixTableModel = null;
    private DefaultMatrixTableModel defaultMatrixTableModel = null;
    private ContractStatusService contractStatusService = null;
    private final StatusMatrix statusMatrix;
    private final String entityTitle;

    public StatusMatrixPanel(StatusMatrix statusMatrix, String entityTitle) {
        this.statusMatrix = statusMatrix;
        this.entityTitle = entityTitle;
    }

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getDefaultMatrixPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.getMatrixPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected JPanel getDefaultMatrixPanel() {
        this.defaultMatrixTable = new BGUTable(null);
        Font font = this.defaultMatrixTable.getFont();
        font = font.deriveFont((float)font.getSize() + 5.0f);
        this.defaultMatrixTable.setFont(font);
        this.defaultMatrixTable.setRowHeight(this.getFontMetrics(font).getHeight() + 5);
        this.defaultMatrixTable.setRowSelectionAllowed(false);
        this.defaultMatrixTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JSONObject jsonObject;
                    String statusId = StatusMatrixPanel.this.defaultMatrixTableModel.getIdentifier(StatusMatrixPanel.this.defaultMatrixTable.convertColumnIndexToModel(StatusMatrixPanel.this.defaultMatrixTable.getSelectedColumn()));
                    jsonObject.put(statusId, !(jsonObject = ((RowData)StatusMatrixPanel.this.defaultMatrixTableModel.getSelectedRow()).getJson()).getBoolean(statusId));
                    Boolean[][] values = new Boolean[1][StatusMatrixPanel.this.statusList.size()];
                    int s = 0;
                    for (Status status : StatusMatrixPanel.this.statusList) {
                        values[0][s++] = jsonObject.getBoolean(String.valueOf(status.getId()));
                    }
                    try {
                        StatusMatrixPanel.this.statusMatrix.valuesUpdate(Arrays.asList(0), StatusMatrixPanel.this.statusIds, values);
                        StatusMatrixPanel.this.setData();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                } else {
                    super.mouseClicked(mouseEvent);
                }
            }
        });
        Dimension dimension = new Dimension(100, 50);
        JScrollPane scrollPane = new JScrollPane(this.defaultMatrixTable);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getMatrixPanel() {
        this.matrixTable = new BGUTable(null);
        this.matrixTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && !StatusMatrixPanel.this.matrixTableModel.getSelectedRows().isEmpty()) {
                    StatusMatrixPanel.this.openMatrixEditor();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    StatusMatrixPanel.this.getPopupMenu().show(StatusMatrixPanel.this.matrixTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0422\u0435\u043a\u0443\u0449\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.matrixTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
            menuItem.addActionListener(e -> this.openMatrixEditor());
            this.popupMenu.add(menuItem);
        }
        return this.popupMenu;
    }

    public void openMatrixEditor() {
        List<RowData> selectedRows = this.matrixTableModel.getSelectedRows();
        if (selectedRows.isEmpty()) {
            ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0438");
        } else {
            new MatrixEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043c\u0430\u0442\u0440\u0438\u0446\u044b", selectedRows).open();
            this.matrixTableModel.fireTableDataChanged();
        }
    }

    private ContractStatusService getContractStatusService() {
        if (this.contractStatusService == null) {
            this.contractStatusService = ((ClientContext)this.getContext()).getPort(ContractStatusService.class, 0);
        }
        return this.contractStatusService;
    }

    public void setData() {
        try {
            this.statusList = this.getContractStatusService().getStatusList(false);
            this.statusIds = this.statusList.stream().map(a -> a.getId()).collect(Collectors.toList());
            this.matrixTableModel = new MatrixTableModel(this.entityTitle);
            this.matrixTable.setModel(this.matrixTableModel);
            this.defaultMatrixTableModel = new DefaultMatrixTableModel();
            this.defaultMatrixTable.setModel(this.defaultMatrixTableModel);
            List<IdTitle> services = this.statusMatrix.list();
            Boolean[][] values = this.statusMatrix.valuesGet(services.stream().map(a -> a.getId()).collect(Collectors.toList()), this.statusIds, false);
            int r = 0;
            ArrayList<RowData> rows = new ArrayList<RowData>();
            for (IdTitle service : services) {
                JSONObject rowJsonObject = new JSONObject();
                rowJsonObject.put("serviceId", service.getId());
                rowJsonObject.put("serviceTitle", (Object)service.getTitle());
                if (this.statusList != null) {
                    int c = 0;
                    for (Status status : this.statusList) {
                        rowJsonObject.put(String.valueOf(status.getId()), (Object)values[r][c++]);
                    }
                }
                rows.add(new RowData(rowJsonObject));
                ++r;
            }
            this.matrixTableModel.setData(rows);
            Boolean[][] defaultValues = this.statusMatrix.valuesGet(Arrays.asList(0), this.statusIds, false);
            rows = new ArrayList();
            JSONObject rowJsonObject = new JSONObject();
            rowJsonObject.put("serviceId", 0);
            if (this.statusList != null) {
                int c = 0;
                for (Status status : this.statusList) {
                    Boolean value = defaultValues[0][c++];
                    rowJsonObject.put(String.valueOf(status.getId()), value != null ? value : false);
                }
            }
            rows.add(new RowData(rowJsonObject));
            this.defaultMatrixTableModel.setData(rows);
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    public void editItem() {
        this.openMatrixEditor();
    }

    class MatrixTableModel
    extends BGTableModel<RowData> {
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_SERVIC_TITLE = "serviceTitle";
        public static final String VALUE_ON = "\u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c";
        public static final String VALUE_OFF = "\u043d\u0435 \u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c";
        public static final String VALUE_DEFAULT = "\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e";

        public MatrixTableModel(String title) {
            super(MatrixTableModel.class.getName());
            this.addColumn(title, 200, 400, -1, COLUMN_SERVIC_TITLE, true, HorizontalAlignmentTableCellRenderer.LEFT());
            if (StatusMatrixPanel.this.statusList != null) {
                for (Status status : StatusMatrixPanel.this.statusList) {
                    this.addColumn(status.getTitle(), 100, 200, -1, String.valueOf(status.getId()), true, new MyRenderer());
                }
            }
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
        }

        @Override
        public Object getValue(RowData rowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            JSONObject rowJsonObject = rowData.getJson();
            switch (identifier) {
                case "id": {
                    return rowJsonObject.optInt("serviceId");
                }
                case "serviceTitle": {
                    return rowJsonObject.optString(identifier);
                }
            }
            boolean def = !rowJsonObject.has(identifier);
            JSONObject defJson = ((RowData)StatusMatrixPanel.this.defaultMatrixTableModel.getRows().get(0)).getJson();
            return new CellData(def, !def ? (rowJsonObject.optBoolean(identifier) ? VALUE_ON : VALUE_OFF) : (defJson.optBoolean(identifier) ? VALUE_ON : VALUE_OFF));
        }
    }

    class DefaultMatrixTableModel
    extends BGTableModel<RowData> {
        public DefaultMatrixTableModel() {
            super(DefaultMatrixTableModel.class.getName());
            if (StatusMatrixPanel.this.statusList != null) {
                for (Status status : StatusMatrixPanel.this.statusList) {
                    this.addColumn(status.getTitle(), 100, 200, -1, String.valueOf(status.getId()), true, new MyRenderer());
                }
            }
        }

        @Override
        protected void initColumns() {
        }

        @Override
        public Object getValue(RowData rowData, int column) throws BGException {
            return new CellData(false, rowData.getJson().optBoolean(this.getIdentifier(column)) ? "\u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c" : "\u043d\u0435 \u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c");
        }
    }

    public static interface StatusMatrix {
        public List<IdTitle> list() throws BGException;

        public Boolean[][] valuesGet(List<Integer> var1, List<Integer> var2, boolean var3) throws BGException;

        public void valuesUpdate(List<Integer> var1, List<Integer> var2, Boolean[][] var3) throws BGException;
    }

    class MatrixEditor
    extends BGEditorDialog<List<RowData>> {
        private EditorTableModel editorTableModel;

        public MatrixEditor(String title, List<RowData> data) {
            super(title, data);
            this.editorTableModel = new EditorTableModel();
        }

        @Override
        public void doDialogPanel() {
            int gridy = 0;
            this.panel.add((Component)new JLabel("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            final BGUTable table = new BGUTable(this.editorTableModel);
            table.setSelectionMode(0);
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        String value = MatrixEditor.this.editorTableModel.getIdentifier(table.convertColumnIndexToModel(table.getSelectedColumn()));
                        ((RowData)MatrixEditor.this.editorTableModel.getSelectedRow()).getJson().put("value", (Object)value);
                        MatrixEditor.this.editorTableModel.fireTableDataChanged();
                    } else {
                        super.mouseClicked(mouseEvent);
                    }
                }
            });
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane(table, 700, 200), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add(Box.createGlue(), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
            ArrayList<RowData> datas = new ArrayList<RowData>();
            for (Status status : StatusMatrixPanel.this.statusList) {
                String statusId = String.valueOf(status.getId());
                String value = null;
                for (RowData rowData : (List)this.data) {
                    JSONObject json = rowData.getJson();
                    String statusValue = String.valueOf(json.has(statusId) ? Boolean.valueOf(json.optBoolean(statusId, false)) : "default");
                    if (value == null) {
                        value = statusValue;
                        continue;
                    }
                    if (value.equals(statusValue)) continue;
                    value = "current";
                    break;
                }
                if (value == null) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", status.getId());
                jsonObject.put("title", (Object)status.getTitle());
                jsonObject.put("value", (Object)value);
                datas.add(new RowData(jsonObject));
            }
            this.editorTableModel.setData(datas);
        }

        @Override
        public boolean doApply() throws Exception {
            if (this.data != null) {
                Boolean[][] values = new Boolean[((List)this.data).size()][StatusMatrixPanel.this.statusList.size()];
                int r = 0;
                for (RowData rowData : (List)this.data) {
                    int s = 0;
                    JSONObject rowJsonObject = rowData.getJson();
                    for (RowData status : this.editorTableModel.getRows()) {
                        String statusId = String.valueOf(status.getJson().getInt("id"));
                        String statusValue = status.getJson().getString("value");
                        if ("default".equals(statusValue)) {
                            rowJsonObject.remove(statusId);
                        } else if (!"current".equals(statusValue)) {
                            rowJsonObject.put(statusId, (Object)statusValue);
                        }
                        values[r][s++] = rowJsonObject.has(statusId) ? Boolean.valueOf(rowJsonObject.optBoolean(statusId)) : null;
                    }
                    ++r;
                }
                StatusMatrixPanel.this.statusMatrix.valuesUpdate(((List)this.data).stream().map(a -> a.getJson().optInt("serviceId")).collect(Collectors.toList()), StatusMatrixPanel.this.statusIds, values);
            }
            return true;
        }
    }

    class CellData {
        private boolean def;
        private String title;

        public CellData(boolean def, String title) {
            this.def = def;
            this.title = title;
        }

        public boolean isDef() {
            return this.def;
        }

        public String toString() {
            return this.title;
        }
    }

    class MyRenderer
    extends HorizontalAlignmentTableCellRenderer {
        private Color defaultColor;

        public MyRenderer() {
            super(0);
            this.defaultColor = this.getBackground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                Color color = this.defaultColor;
                if (value instanceof CellData && !((CellData)value).isDef()) {
                    color = "\u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c".equals(value.toString()) ? Color.GREEN : new Color(255, 192, 192);
                }
                component.setBackground(color);
            }
            return component;
        }
    }

    class EditorTableModel
    extends BGTableModel<RowData> {
        public EditorTableModel() {
            super(EditorTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 200, -1, "title", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c", 100, 100, 100, "true", false, new RadioButtonTableCellRenderer());
            this.addColumn("\u041d\u0435 \u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c", 100, 100, 100, "false", false, new RadioButtonTableCellRenderer());
            this.addColumn("\u0422\u0435\u043a\u0443\u0449\u0435\u0435", 100, 100, 100, "current", false, new RadioButtonTableCellRenderer());
            this.addColumn("\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e", 100, 100, 100, "default", false, new RadioButtonTableCellRenderer());
        }

        @Override
        public Object getValue(RowData val, int column) throws BGException {
            String i = this.getIdentifier(column);
            if ("title".equals(i)) {
                return val.getJson().optString(i);
            }
            return i.equals(val.getJson().optString("value"));
        }
    }

    class TitleLabel
    extends JLabel {
        public TitleLabel(String text) {
            super(text);
            this.setHorizontalAlignment(0);
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
        }
    }
}

