/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.label.client;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTreeCellRenderer;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelType;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.model.Id;

public class ContractLabelTree
extends JTree
implements Autoscroll {
    private boolean ctrlDown = true;
    private int margin = 12;
    private JPopupMenu popupMenu = null;
    private boolean singleSelection = false;
    private NodeSelectionListener listener = new NodeSelectionListener();
    private ContractLabelService contractLabelService;

    public ContractLabelTree(boolean checkedTree, boolean singleSelection, boolean withComment) {
        this();
        if (!singleSelection) {
            this.getSelectionModel().setSelectionMode(4);
        }
        boolean bl = this.singleSelection = this.getSelectionModel().getSelectionMode() == 1;
        if (!checkedTree) {
            this.setCellRenderer(new ContractLabelTreeCellRenderer(false, false, withComment));
        }
    }

    public ContractLabelTree(ClientContext context) throws BGException {
        this();
        if (context == null) {
            throw new BGException("ClientContext is null in ContractLabelTree!");
        }
        this.loadLabels(context.getPort(ContractLabelService.class, 0));
    }

    public ContractLabelTree() {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setCellRenderer(new ContractLabelTreeCellRenderer(true, false, false));
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.getSelectionModel().setSelectionMode(1);
        this.onNodeSelectionListener();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                TreePath treePath;
                if (ContractLabelTree.this.isEnabled() && event.getButton() == 3 && (treePath = ContractLabelTree.this.getSelectionPath()) != null) {
                    Point point = event.getPoint();
                    Rectangle rectangle = ContractLabelTree.this.getPathBounds(treePath);
                    if (rectangle != null && rectangle.contains(point) && ContractLabelTree.this.popupMenu != null) {
                        ContractLabelTree.this.popupMenu.show(event.getComponent(), point.x, rectangle.y + rectangle.height + 1);
                    }
                }
            }
        });
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(new JMenuItem(new BGUAction("selectParent", "\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0435\u0445 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u0435\u0439"){

            @Override
            public void actionPerformed(ActionEvent event) {
                JMenuItem menuItem = (JMenuItem)event.getSource();
                ContractLabelTree tree = (ContractLabelTree)((JPopupMenu)menuItem.getParent()).getInvoker();
                Object selectedObject = tree.getLastSelectedPathComponent();
                if (selectedObject instanceof DefaultMutableTreeNode) {
                    for (DefaultMutableTreeNode tariffLabelTreeNode = (DefaultMutableTreeNode)selectedObject; tariffLabelTreeNode != null; tariffLabelTreeNode = (DefaultMutableTreeNode)tariffLabelTreeNode.getParent()) {
                        Object userObject = tariffLabelTreeNode.getUserObject();
                        if (!(userObject instanceof ContractLabelItem)) continue;
                        ((ContractLabelItem)userObject).setSelected(true);
                        ((DefaultTreeModel)tree.getModel()).nodeChanged(tariffLabelTreeNode);
                    }
                }
                tree.firePropertyChange("changeSelected", false, true);
            }
        }));
        this.popupMenu.add(new JMenuItem(new BGUAction("selectChildren", "\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0435 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0435"){

            @Override
            public void actionPerformed(ActionEvent event) {
                JMenuItem menuItem = (JMenuItem)event.getSource();
                ContractLabelTree tree = (ContractLabelTree)((JPopupMenu)menuItem.getParent()).getInvoker();
                Object selectedObject = tree.getLastSelectedPathComponent();
                if (selectedObject instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode contractLabelTreeNode = (DefaultMutableTreeNode)selectedObject;
                    int selectNodeLevel = contractLabelTreeNode.getLevel();
                    while (contractLabelTreeNode != null) {
                        Object userObject = contractLabelTreeNode.getUserObject();
                        if (userObject instanceof ContractLabelItem) {
                            ((ContractLabelItem)userObject).setSelected(true);
                            ((DefaultTreeModel)tree.getModel()).nodeChanged(contractLabelTreeNode);
                        }
                        if ((contractLabelTreeNode = contractLabelTreeNode.getNextNode()) == null || contractLabelTreeNode.getLevel() > selectNodeLevel) continue;
                        break;
                    }
                }
                tree.firePropertyChange("changeSelected", false, true);
            }
        }));
        this.popupMenu.add(new JMenuItem(new BGUAction("selectReset", "\u0421\u0431\u0440\u043e\u0441 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u044f"){

            @Override
            public void actionPerformed(ActionEvent event) {
                JMenuItem menuItem = (JMenuItem)event.getSource();
                ContractLabelTree tree = (ContractLabelTree)((JPopupMenu)menuItem.getParent()).getInvoker();
                for (DefaultMutableTreeNode node = ((DefaultMutableTreeNode)tree.getModel().getRoot()).getNextNode(); node != null; node = node.getNextNode()) {
                    Object userObject = node.getUserObject();
                    if (!(userObject instanceof ContractLabelItem)) continue;
                    ((ContractLabelItem)userObject).setSelected(false);
                    ((DefaultTreeModel)tree.getModel()).nodeChanged(node);
                }
                tree.firePropertyChange("changeSelected", false, true);
            }
        }));
    }

    public void setCtrlDown(boolean ctrlDown) {
        this.ctrlDown = ctrlDown;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public void loadLabels(ContractLabelService contractLabelService) throws BGException {
        if (contractLabelService == null) {
            throw new BGException("ContractLabelService is null!");
        }
        this.contractLabelService = contractLabelService;
        this.setData(contractLabelService.getContractLabelTreeItemList(-1, false));
    }

    public void setData(List<ContractLabelItem> contractLabelItemList) {
        DefaultMutableTreeNode rootNode;
        this.setModel(new DefaultTreeModel(rootNode));
        this.buildContractLabelTree(rootNode, contractLabelItemList, 0);
        for (rootNode = new DefaultMutableTreeNode(new ContractLabelItem(){
            {
                this.setTitle("\u041a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442");
            }
        }); rootNode != null; rootNode = rootNode.getNextNode()) {
            this.expandPath(new TreePath(rootNode.getPath()));
        }
    }

    public void switchVisibleIdLabels() {
        ContractLabelTreeCellRenderer renderer = (ContractLabelTreeCellRenderer)this.getCellRenderer();
        this.setCellRenderer(new ContractLabelTreeCellRenderer(renderer.checkBoxVisibility(), !renderer.idLabelsVisibility(), renderer.isCommentVisible()));
        this.revalidate();
        this.repaint();
    }

    public ContractLabelItem getLabelItemById(int labelItemId) {
        return this.getAllItemsInTree().stream().filter(i -> i.getId() == labelItemId).findFirst().orElse(null);
    }

    public ContractLabelItem getSelectedItem() {
        return Utils.isEmptyCollection(this.getSelectedItems()) ? null : this.getSelectedItems().get(0);
    }

    public List<ContractLabelItem> getSelectedItemsWithoutForbidden() {
        return this.getAllItemsInTree().stream().filter(i -> i.isSelected() && !i.isForbiddenEdit()).collect(Collectors.toList());
    }

    public List<ContractLabelItem> getSelectedItems() {
        return this.getAllItemsInTree().stream().filter(ContractLabelItem::isSelected).collect(Collectors.toList());
    }

    public List<ContractLabelItem> getSelectedItems0(boolean withParents) {
        Set<Integer> selectedItems = this.getSelectedItems(withParents);
        return this.getAllItemsInTree().stream().filter(i -> selectedItems.contains(i.getId())).collect(Collectors.toList());
    }

    public Set<Integer> getSelectedItems(boolean withParent) {
        if (!withParent) {
            return new HashSet<Integer>(this.getSelectedIds());
        }
        HashSet<Integer> selectedIds = new HashSet<Integer>();
        for (ContractLabelItem item : this.getSelectedItems()) {
            if (item.getContractLabelType().equals((Object)ContractLabelType.GROUP) || item.getContractLabelType().equals((Object)ContractLabelType.LABEL)) {
                selectedIds.addAll(this.getAllItemsInTree().stream().filter(child -> child.getParentId() == item.getId() && !child.isForbiddenEdit()).mapToInt(Id::getId).boxed().toList());
                selectedIds.add(item.getId());
                this.addParents(item, selectedIds);
                continue;
            }
            if (selectedIds.contains(item.getId())) continue;
            selectedIds.add(item.getId());
            this.addParents(item, selectedIds);
        }
        return selectedIds;
    }

    public void addParents(ContractLabelItem item, Set<Integer> items) {
        if (item.getParentId() > 0) {
            this.getAllItemsInTree().stream().filter(i -> i.getId() == item.getParentId()).findFirst().ifPresent(parent -> {
                items.add(parent.getId());
                this.addParents((ContractLabelItem)parent, items);
            });
        }
    }

    public List<Integer> getSelectedIds() {
        return this.getSelectedItems().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList());
    }

    public void setSelectedIds(Collection<Integer> ids) {
        this.getAllItemsInTree().forEach(item -> item.setSelected(ids != null && ids.contains(item.getId())));
    }

    private void buildContractLabelTree(DefaultMutableTreeNode currentNode, List<ContractLabelItem> contractLabelItemList, int parentContractItemId) {
        for (ContractLabelItem contractLabelItem : contractLabelItemList) {
            if (contractLabelItem.getParentId() != parentContractItemId) continue;
            DefaultMutableTreeNode labelTreeNode = new DefaultMutableTreeNode();
            labelTreeNode.setUserObject(contractLabelItem);
            currentNode.add(labelTreeNode);
            this.buildContractLabelTree(labelTreeNode, contractLabelItemList, contractLabelItem.getId());
        }
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String text = super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof DefaultMutableTreeNode) {
            ContractLabelItem contractLabelItem;
            Object userObject;
            DefaultMutableTreeNode contractLabelTreeNode = (DefaultMutableTreeNode)value;
            if (!this.isEditable() && (userObject = contractLabelTreeNode.getUserObject()) instanceof ContractLabelItem && (contractLabelItem = (ContractLabelItem)userObject).getContractLinkCount() > 0) {
                text = text.concat(" [").concat(String.valueOf(contractLabelItem.getContractLinkCount())).concat("]");
            }
        }
        return text;
    }

    @Override
    public void clearSelection() {
        this.clearAllSelectedItems();
        super.clearSelection();
    }

    private void clearAllSelectedItems() {
        this.getAllItemsInTree().forEach(item -> item.setSelected(false));
    }

    public List<ContractLabelItem> getAllItemsInTree() {
        TreeModel treeModel = this.getModel();
        if (treeModel != null) {
            ArrayList<ContractLabelItem> allItems = new ArrayList<ContractLabelItem>();
            Object root = treeModel.getRoot();
            if (root != null) {
                for (DefaultMutableTreeNode rootNode = ((DefaultMutableTreeNode)root).getNextNode(); rootNode != null; rootNode = rootNode.getNextNode()) {
                    Object userObject = rootNode.getUserObject();
                    if (!(userObject instanceof ContractLabelItem)) continue;
                    allItems.add((ContractLabelItem)userObject);
                }
            }
            return allItems;
        }
        return Collections.emptyList();
    }

    public void onNodeSelectionListener() {
        boolean fl = true;
        for (MouseListener mouseListener : this.getMouseListeners()) {
            if (mouseListener != this.listener) continue;
            fl = false;
            break;
        }
        if (fl) {
            this.addMouseListener(this.listener);
        }
        fl = true;
        for (EventListener eventListener : this.getKeyListeners()) {
            if (eventListener != this.listener) continue;
            fl = false;
            break;
        }
        if (fl) {
            this.addKeyListener(this.listener);
        }
    }

    public void removeNodeSelectionListener() {
        this.removeMouseListener(this.listener);
        this.removeKeyListener(this.listener);
    }

    private void switchSelectionOnNode(DefaultMutableTreeNode node, int childCount, boolean isSelect) {
        for (int x = 0; x < childCount; ++x) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(x);
            ContractLabelItem child = (ContractLabelItem)childNode.getUserObject();
            child.setSelected(isSelect);
            if (childNode.getChildCount() <= 0) continue;
            this.switchSelectionOnNode(childNode, childNode.getChildCount(), isSelect);
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle outer = this.getBounds();
        Rectangle inner = this.getParent().getBounds();
        return new Insets(inner.y - outer.y + this.margin, inner.x - outer.x + this.margin, outer.height - inner.height - inner.y + outer.y + this.margin, outer.width - inner.width - inner.x + outer.x + this.margin);
    }

    @Override
    public void autoscroll(Point p) {
        int realrow = this.getRowForLocation(p.x, p.y);
        Rectangle outer = this.getBounds();
        realrow = p.y + outer.y <= this.margin ? (realrow < 1 ? 0 : realrow - 1) : (realrow < this.getRowCount() - 1 ? realrow + 1 : realrow);
        this.scrollRowToVisible(realrow);
    }

    public void enableSortableDnD(ContractLabelService contractLabelService) throws BGException {
        if (contractLabelService == null) {
            throw new BGException("ContractLabelService is null!");
        }
        this.contractLabelService = contractLabelService;
        new TreeDragSource(this, 3);
        new TreeDropTarget(this);
    }

    private void resorting(ContractLabelItem oldItem, ContractLabelItem nextItem) {
        int oldSortPosition = oldItem.getSortPosition();
        int newSortPosition = nextItem.getSortPosition();
        List<ContractLabelItem> allItems = this.getAllItemsInTree().stream().filter(item -> item.getContractLabelType().equals((Object)ContractLabelType.LABEL_ITEM)).sorted().collect(Collectors.toList());
        if (newSortPosition >= oldSortPosition) {
            ((ContractLabelItem)allItems.get(oldSortPosition)).setSortPosition(newSortPosition);
            for (i = newSortPosition; i > oldSortPosition; --i) {
                ContractLabelItem first = (ContractLabelItem)allItems.get(i);
                ContractLabelItem second = (ContractLabelItem)allItems.get(i - 1);
                first.setSortPosition(i - 1 == oldSortPosition ? oldSortPosition : second.getSortPosition());
            }
        } else {
            ((ContractLabelItem)allItems.get(oldSortPosition)).setSortPosition(newSortPosition);
            for (i = newSortPosition; i < oldSortPosition; ++i) {
                if (newSortPosition - oldSortPosition >= 0) continue;
                ContractLabelItem first = (ContractLabelItem)allItems.get(i);
                ContractLabelItem second = allItems.get(i + 1);
                first.setSortPosition(i + 1 == oldSortPosition ? oldSortPosition : second.getSortPosition());
            }
        }
        if (oldSortPosition != newSortPosition && this.contractLabelService != null) {
            try {
                this.contractLabelService.updateContractLabelTreeItems(allItems);
                this.setData(this.contractLabelService.getContractLabelTreeItemList(-1, false));
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }
    }

    private final class NodeSelectionListener
    extends MouseAdapter
    implements KeyListener {
        private NodeSelectionListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Object selectedObject;
            int y;
            int x;
            int row;
            TreePath path;
            Object source = mouseEvent.getSource();
            if (source instanceof ContractLabelTree && ((ContractLabelTree)source).isEnabled() && (path = ContractLabelTree.this.getPathForRow(row = ContractLabelTree.this.getRowForLocation(x = mouseEvent.getX(), y = mouseEvent.getY()))) != null && SwingUtilities.isLeftMouseButton(mouseEvent) && (selectedObject = ContractLabelTree.this.getLastSelectedPathComponent()) instanceof DefaultMutableTreeNode) {
                boolean ctrl = (mouseEvent.getModifiersEx() & 0x80) == 128;
                this.action((DefaultMutableTreeNode)selectedObject, ctrl | ContractLabelTree.this.ctrlDown);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            int i = keyEvent.getKeyCode();
            if (i == 32 || i == 10) {
                boolean ctrl = (keyEvent.getModifiersEx() & 0x80) == 128;
                this.action((DefaultMutableTreeNode)ContractLabelTree.this.getLastSelectedPathComponent(), ctrl | ContractLabelTree.this.ctrlDown);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        private void action(DefaultMutableTreeNode node, boolean ctrl) {
            Object userObject;
            if (node == null) {
                return;
            }
            if (ContractLabelTree.this.singleSelection) {
                ContractLabelTree.this.clearAllSelectedItems();
            }
            ContractLabelType contractLabelType = ((ContractLabelItem)node.getUserObject()).getContractLabelType();
            if (!ctrl && (contractLabelType.equals((Object)ContractLabelType.GROUP_ITEM) || contractLabelType.equals((Object)ContractLabelType.LABEL_ITEM))) {
                for (DefaultMutableTreeNode node1 = ((DefaultMutableTreeNode)ContractLabelTree.this.getModel().getRoot()).getNextNode(); node1 != null; node1 = node1.getNextNode()) {
                    ContractLabelItem contractLabelItem;
                    userObject = node1.getUserObject();
                    if (!(userObject instanceof ContractLabelItem) || !(contractLabelItem = (ContractLabelItem)userObject).isSelected() || node.equals(node1)) continue;
                    contractLabelItem.setSelected(false);
                    ContractLabelTree.this.firePropertyChange("changeSelected", true, false);
                }
            }
            if ((userObject = node.getUserObject()) instanceof ContractLabelItem) {
                ContractLabelItem contractLabelItem;
                contractLabelItem.setSelected(!(contractLabelItem = (ContractLabelItem)userObject).isSelected());
                int childCount = node.getChildCount();
                ContractLabelTree.this.switchSelectionOnNode(node, childCount, contractLabelItem.isSelected());
                ContractLabelTree.this.firePropertyChange("changeSelected", !contractLabelItem.isSelected(), contractLabelItem.isSelected());
                ContractLabelTree.this.repaint();
            }
        }
    }

    private static class TreeDragSource
    implements DragSourceListener,
    DragGestureListener {
        private DragSource source;
        private Transferable transferable;
        private JTree sourceTree;

        public TreeDragSource(JTree tree, int actions) {
            this.sourceTree = tree;
            this.source = new DragSource();
            this.source.createDefaultDragGestureRecognizer(this.sourceTree, actions, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            TreePath path = this.sourceTree.getSelectionPath();
            if (path == null || path.getPathCount() <= 1) {
                return;
            }
            DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (oldNode != null && oldNode.getUserObject() instanceof ContractLabelItem) {
                this.transferable = new ContractLabelItemTransferable((ContractLabelItem)oldNode.getUserObject());
            }
            this.source.startDrag(dge, DragSource.DefaultMoveNoDrop, this.transferable, this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }
    }

    private class TreeDropTarget
    implements DropTargetListener {
        public TreeDropTarget(JTree tree) {
            new DropTarget(tree, this);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            TreeNode node = this.getNodeForEvent(dtde);
            if (node.isLeaf()) {
                dtde.rejectDrag();
            } else {
                dtde.acceptDrag(dtde.getDropAction());
            }
        }

        private TreeNode getNodeForEvent(DropTargetDragEvent dtde) {
            Point p = dtde.getLocation();
            DropTargetContext dtc = dtde.getDropTargetContext();
            JTree tree = (JTree)dtc.getComponent();
            TreePath path = tree.getClosestPathForLocation(p.x, p.y);
            return (TreeNode)path.getLastPathComponent();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            dtde.acceptDrag(dtde.getDropAction());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Point point = dtde.getLocation();
            DropTargetContext dropTargetContext = dtde.getDropTargetContext();
            JTree tree = (JTree)dropTargetContext.getComponent();
            TreePath parentPath = tree.getClosestPathForLocation(point.x, point.y);
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
            Object newObject = parent.getUserObject();
            if (newObject instanceof ContractLabelItem) {
                ContractLabelItem itemToDrop = (ContractLabelItem)newObject;
                if (itemToDrop.getParentId() == 1 || itemToDrop.getContractLabelType().equals((Object)ContractLabelType.GROUP) || itemToDrop.getContractLabelType().equals((Object)ContractLabelType.GROUP_ITEM)) {
                    ClientUtils.showErrorMessageDialog("\u041d\u0435\u043b\u044c\u0437\u044f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u044b \u0438\u043b\u0438 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0438\u0442\u044c \u043c\u0435\u0442\u043a\u0438 \u0432 \u0433\u0440\u0443\u043f\u043f\u044b");
                    return;
                }
                try {
                    Transferable transferable = dtde.getTransferable();
                    DataFlavor[] flavors = transferable.getTransferDataFlavors();
                    if (flavors != null && flavors.length > 0 && transferable.isDataFlavorSupported(flavors[0])) {
                        dtde.acceptDrop(dtde.getDropAction());
                        Object o = transferable.getTransferData(flavors[0]);
                        ContractLabelItem itemToDrag = (ContractLabelItem)o;
                        ContractLabelTree.this.resorting(itemToDrag, itemToDrop);
                        dtde.dropComplete(true);
                        return;
                    }
                    dtde.rejectDrop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    dtde.rejectDrop();
                }
            }
        }
    }

    private static class ContractLabelItemTransferable
    implements Transferable {
        public static DataFlavor DATA_FLAVOR = new DataFlavor(ContractLabelItem.class, "ContractLabelItem");
        ContractLabelItem contractLabelItem;

        ContractLabelItemTransferable(ContractLabelItem contractLabelItem) {
            this.contractLabelItem = contractLabelItem;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DATA_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(DATA_FLAVOR);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.contractLabelItem;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

