/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.search.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.search.common.SearchImplementation;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractSearchableDao
extends AbstractIdDao<SearchImplementation> {
    public ContractSearchableDao(Connection con) {
        this(con, 0, "contract_search_implementation", null);
    }

    public ContractSearchableDao(Connection con, int moduleId, String tableName, Date date) {
        super(con, moduleId, tableName, date);
    }

    public List<SearchImplementation> getList() throws BGException {
        ArrayList<SearchImplementation> result = new ArrayList<SearchImplementation>();
        String query = "SELECT  *  FROM " + this.tableName;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    @Override
    protected SearchImplementation getFromRS(ResultSet rs) throws SQLException, BGException {
        return SearchImplementation.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setPathToImplClass(rs.getString("implClass")).setModuleTitle(rs.getString("moduleTitle")).setModuleId(rs.getInt("moduleId")).setEnable(rs.getInt("enable") == 1).build();
    }

    @Override
    protected void updateImpl(SearchImplementation searchImplementation) throws BGException, SQLException {
        boolean update = searchImplementation.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, implClass=?, moduleTitle=?, moduleId=?, enable=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, searchImplementation.getTitle());
            ps.setString(index++, searchImplementation.getPathToImplClass());
            ps.setString(index++, searchImplementation.getModuleTitle());
            ps.setInt(index++, searchImplementation.getModuleId());
            ps.setInt(index++, searchImplementation.isEnable() ? 1 : 0);
            if (update) {
                ps.setInt(index, searchImplementation.getId());
            }
            ps.executeUpdate();
            if (!update) {
                searchImplementation.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }
}

