/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.contract.status.server.WebStatusChangeRules;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class StatusCache {
    private static Logger log = LogManager.getLogger();
    private static StatusCache instance = new StatusCache();
    public static final String DEFAULT_STATUS_LIST = "0:\u0410\u043a\u0442\u0438\u0432\u0435\u043d;1:\u0412 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438;2:\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d;3:\u0417\u0430\u043a\u0440\u044b\u0442;4:\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d;5:\u0412 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438";
    private volatile Map<Integer, String> statusTitleMap;
    private volatile List<Status> usingStatusList;
    private volatile List<Status> manualStatusList;
    private volatile WebStatusChangeRules webChangeRules;
    private volatile Map<Integer, Set<Integer>> modulesActiveCodes = new ConcurrentHashMap<Integer, Set<Integer>>();
    private volatile Map<Integer, Set<Integer>> modulesSuspendCodes = new ConcurrentHashMap<Integer, Set<Integer>>();
    private volatile int defaultStatus = 0;

    public static final StatusCache getInstance() {
        return instance;
    }

    private StatusCache() {
        this.reloadStatusList();
        try {
            EventProcessor.getInstance().addListener(new EventListener<ModuleConfigModifiedEvent>(){

                @Override
                public void notify(ModuleConfigModifiedEvent e, EventListenerContext ctx) {
                    if (e.getModuleId() == 0) {
                        log.info("Reload contract status list...");
                        StatusCache.this.reloadStatusList();
                    } else {
                        log.info("Reload module " + e.getModuleId() + " active status codes...");
                        StatusCache.this.modulesActiveCodes.remove(e.getModuleId());
                        StatusCache.this.modulesSuspendCodes.remove(e.getModuleId());
                    }
                }
            }, ModuleConfigModifiedEvent.class);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void reloadStatusList() {
        Setup setup = Setup.getSetup();
        HashMap<Integer, String> statusTitleMap = new HashMap<Integer, String>();
        ArrayList<Status> usingStatusList = new ArrayList<Status>();
        ArrayList<Status> manualStatusList = new ArrayList<Status>();
        Set<Integer> deprecatedStatusSet = Utils.toIntegerSet(setup.get("contract.status.deprecated", setup.get("contract.status.deprected", "")));
        Set<Integer> noManualStatus = Utils.toIntegerSet(setup.get("contract.status.no.manual.set", "1,5"));
        String statusListString = setup.get("contract.status.list", DEFAULT_STATUS_LIST);
        StringTokenizer st = new StringTokenizer(statusListString, ";");
        while (st.hasMoreTokens()) {
            String[] id_title = st.nextToken().split(":");
            if (id_title.length != 2) continue;
            Status status = new Status(Utils.parseInt(id_title[0]), id_title[1]);
            statusTitleMap.put(status.getId(), status.getTitle());
            if (!deprecatedStatusSet.contains(status.getId())) {
                usingStatusList.add(status);
            }
            if (noManualStatus.contains(status.getId())) continue;
            manualStatusList.add(status);
        }
        this.statusTitleMap = statusTitleMap;
        this.usingStatusList = usingStatusList;
        this.manualStatusList = manualStatusList;
        this.webChangeRules = new WebStatusChangeRules((Preferences)setup);
        this.defaultStatus = setup.getInt("contract.status.default", 0);
    }

    public String getStatusTitle(int id) {
        if (this.statusTitleMap.containsKey(id)) {
            return this.statusTitleMap.get(id);
        }
        return "??? (" + id + ")";
    }

    public int getDefaultStatus() {
        return this.defaultStatus;
    }

    public List<Status> getStatusList() {
        return this.usingStatusList;
    }

    public List<Status> getManualStatusList() {
        return this.manualStatusList;
    }

    public Set<Integer> getModuleActiveStatusSet(int moduleId) {
        return this.getCodes(this.modulesActiveCodes, moduleId, "contract.status.active.codes", "0");
    }

    public Set<Integer> getModuleSuspendStatusSet(int moduleId) {
        return this.getCodes(this.modulesSuspendCodes, moduleId, "contract.status.suspend.codes", "3,4");
    }

    public Set<Integer> getModuleSuspendStatusSet(int moduleId, String def) {
        return this.getCodes(this.modulesSuspendCodes, moduleId, "contract.status.suspend.codes", def);
    }

    private Set<Integer> getCodes(Map<Integer, Set<Integer>> codesMap, int moduleId, String key, String defaultCodes) {
        Set<Integer> result = codesMap.get(moduleId);
        if (result == null) {
            Pattern patternComma = Pattern.compile("\\s*,\\s*");
            result = new HashSet<Integer>();
            String valuesStr = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)).get(key, defaultCodes);
            if (Utils.notBlankString(valuesStr)) {
                String[] values;
                for (String value : values = patternComma.split(valuesStr)) {
                    int status = Utils.parseInt(value.trim(), -1);
                    if (status >= 0) {
                        result.add(status);
                        continue;
                    }
                    log.error("Error value contract.status.suspend.codes=" + valuesStr);
                }
            }
            codesMap.put(moduleId, result);
        }
        return result;
    }

    public boolean isModuleActiveStatus(int moduleId, int id) {
        return this.getModuleActiveStatusSet(moduleId).contains(id);
    }

    public WebStatusChangeRules getWebStatusChangeRules() {
        return this.webChangeRules;
    }
}

