/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.map.kernel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.OSMTileFactoryInfo;
import org.jxmapviewer.VirtualEarthTileFactoryInfo;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.TileFactoryInfo;
import ru.bitel.bgbilling.kernel.map.kernel.DefaultMapViewer;
import ru.bitel.common.client.BGSwingUtilites;

public class MapViewerFrame {
    private final JFrame frame;
    private final DefaultMapViewer mapViewer;
    private final JPanel rootPanel = new JPanel(new BorderLayout());
    private final SelectTileFactoryPanel selectTileFactoryPanel = new SelectTileFactoryPanel();

    public MapViewerFrame() {
        this("MapViewer", false);
    }

    public MapViewerFrame(boolean isVisible) {
        this("MapViewer", isVisible);
    }

    public MapViewerFrame(String title, boolean isVisible) {
        this.mapViewer = new DefaultMapViewer();
        this.frame = this.initFrame(title);
        this.setVisible(isVisible);
        this.initPropertyChangeListener();
    }

    private void initPropertyChangeListener() {
        this.mapViewer.addPropertyChangeListener("zoom", evt -> this.updateWindowTitle(this.frame, this.mapViewer));
        this.mapViewer.addPropertyChangeListener("center", evt -> this.updateWindowTitle(this.frame, this.mapViewer));
    }

    private void updateWindowTitle(JFrame frame, JXMapViewer mapViewer) {
        frame.setTitle(String.format("MapViewer(%.2f / %.2f) - Zoom: %d", mapViewer.getCenterPosition().getLatitude(), mapViewer.getCenterPosition().getLongitude(), mapViewer.getZoom()));
    }

    public void setFocusOnItem(GeoPosition focusPosition) {
        if (focusPosition != null) {
            this.mapViewer.setAddressLocation(focusPosition);
        }
    }

    public void setVisible(boolean visible) {
        this.frame.setVisible(visible);
    }

    private JFrame initFrame(String frameTitle) {
        this.rootPanel.add((Component)this.selectTileFactoryPanel, "North");
        this.rootPanel.add((Component)((Object)this.mapViewer), "Center");
        JFrame frame = new JFrame(frameTitle);
        frame.getContentPane().add(this.rootPanel);
        frame.setSize(1000, 600);
        frame.setDefaultCloseOperation(1);
        frame.setLocationRelativeTo(null);
        return frame;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public DefaultMapViewer getMapViewer() {
        return this.mapViewer;
    }

    public JPanel getRootPanel() {
        return this.rootPanel;
    }

    private final class SelectTileFactoryPanel
    extends JPanel {
        private final List<TileFactory> factories = new ArrayList<DefaultTileFactory>(List.of(new DefaultTileFactory((TileFactoryInfo)new OSMTileFactoryInfo()), new DefaultTileFactory((TileFactoryInfo)new VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.MAP)), new DefaultTileFactory((TileFactoryInfo)new VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.HYBRID))));
        private final JComboBox<String> factoriesComboBox;

        public SelectTileFactoryPanel() {
            this.setLayout(new GridLayout());
            this.add(new JLabel("\u0420\u0435\u0436\u0438\u043c \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f:"));
            this.factoriesComboBox = new JComboBox<String>(new String[]{"OpenStreetMap", "VirtualEarth", "VirtualEarth (Hybrid)"});
            this.add(this.factoriesComboBox);
            this.factoriesComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        TileFactory factory = SelectTileFactoryPanel.this.factories.get(SelectTileFactoryPanel.this.factoriesComboBox.getSelectedIndex());
                        if (factory == null) {
                            return;
                        }
                        int zoom = MapViewerFrame.this.mapViewer.getZoom();
                        factory.getInfo().setDefaultZoomLevel(zoom);
                        MapViewerFrame.this.mapViewer.setTileFactory(factory);
                        MapViewerFrame.this.mapViewer.setZoom(zoom);
                        MapViewerFrame.this.mapViewer.revalidate();
                        MapViewerFrame.this.mapViewer.repaint();
                    }
                }
            });
            this.factoriesComboBox.setSelectedIndex(0);
            BGSwingUtilites.wrapEmptyBorder(this);
        }
    }
}

