/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.service;

import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffVarDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.tariff.common.service.TariffService")
public class TariffServiceImpl
extends AbstractService
implements TariffService {
    @Override
    public SearchResult<TariffPlan> searchTariffPlans(List<Integer> labelIds, List<Integer> moduleIds, int showUsed, Page page) throws BGException {
        SearchResult<TariffPlan> searchResult = new SearchResult<TariffPlan>();
        searchResult.setPage(page);
        try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.getConnection());){
            tariffPlanDao.searchTariffPlans(searchResult, showUsed, moduleIds, labelIds, "");
        }
        return searchResult;
    }

    @Override
    public List<TariffPlan> tariffPlanList(List<Integer> contractLabelIds, Integer personType, String title) throws BGException {
        if ((contractLabelIds == null || contractLabelIds.isEmpty()) && (personType == null || personType < 0) && Utils.isEmptyString(title)) {
            return this.context.newDirectory(TariffPlan.class, 0).list();
        }
        try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.getConnection());){
            List<TariffPlan> list = tariffPlanDao.getTariffPlanList(0, contractLabelIds, personType, title);
            return list;
        }
    }

    @Override
    public List<IdTitle> tariffPlanTitles() throws BGException, BGMessageException {
        return this.context.getDirectory(TariffPlan.class, 0).list().stream().map(IdTitle::toIdTitle).toList();
    }

    @Override
    public TariffPlan tariffPlanGet(int id) throws BGException {
        return this.context.getDirectory(TariffPlan.class, 0).get(id);
    }

    @Override
    public void tariffPlanDelete(int id) throws BGException {
        this.context.newDirectory(TariffPlan.class, 0).delete(id);
    }

    @Override
    public int tariffPlanUpdate(TariffPlan tariffPlan) throws BGException {
        this.context.getDirectory(TariffPlan.class, 0).update(tariffPlan);
        return tariffPlan.getId();
    }

    @Override
    public TariffGroup tariffGroupGet(int id) throws BGException {
        return this.context.getDirectory(TariffGroup.class, 0).get(id);
    }

    @Override
    public void tariffGroupDelete(int id) throws BGException {
        this.context.getDirectory(TariffGroup.class, 0).delete(id);
    }

    @Override
    public int tariffGroupUpdate(TariffGroup tariffGroup) throws BGException {
        this.context.newDirectory(TariffGroup.class, 0).update(tariffGroup);
        return tariffGroup.getId();
    }

    @Override
    public List<TariffGroup> tariffGroupList() throws BGException {
        return this.context.newDirectory(TariffGroup.class, 0).list();
    }

    @Override
    public List<TariffVar> tariffVars(TariffVarType tariffVarType, List<Integer> tariffPlanIds) throws BGException {
        try (TariffVarDao tariffVarDao = new TariffVarDao(this.getConnection());){
            List<TariffVar> list = tariffVarDao.list(tariffVarType, tariffPlanIds);
            return list;
        }
    }

    @Override
    public TariffVar tariffVarGet(int tariffVarId) throws BGException {
        try (TariffVarDao tariffVarDao = new TariffVarDao(this.getConnection());){
            TariffVar tariffVar = (TariffVar)tariffVarDao.get(tariffVarId);
            return tariffVar;
        }
    }

    @Override
    public int tariffVarUpdate(TariffVar tariffVar) throws BGException {
        try (TariffVarDao tariffVarDao = new TariffVarDao(this.getConnection());){
            int n = tariffVarDao.updateTariffVar(tariffVar);
            return n;
        }
    }

    @Override
    public int tariffVarDelete(int tariffVarId) throws BGException {
        try (TariffVarDao tariffVarDao = new TariffVarDao(this.getConnection());){
            int n = tariffVarDao.delete(tariffVarId);
            return n;
        }
    }

    @Override
    public List<IdTitle> tariffVarListItems(int moduleId, String varTypeCode) throws BGException, BGMessageException {
        Map<String, Object> resultMap;
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        if ("inet_option".equals(varTypeCode) && !(resultMap = EventProcessor.getInstance().doCrossComponentQuery(null, moduleId, "tariffVarListOptionItems", moduleId)).isEmpty()) {
            resultMap.values().forEach(a -> result.addAll((List)a));
        }
        return result;
    }
}

