/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client.device;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.tree.BGUCheckTree;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.client.filter.FilterEntityAttrAddressPanel;
import ru.bitel.oss.kernel.entity.client.filter.FilterPanel;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrAddress;
import ru.bitel.oss.systems.inventory.resource.client.device.DevicePanel;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceGroup;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;

public class DeviceFilter<D extends Device<D, T>, T extends DeviceType>
extends FilterPanel {
    private final DevicePanel<D, T> devicePanel;
    private FilterEntityAttrAddressPanel addressFilter;
    DeviceFilterMain mainFilter = new DeviceFilterMain();

    public DeviceFilter(DevicePanel<D, T> devicePanel, ClientContext clientContext) {
        super(clientContext);
        this.devicePanel = devicePanel;
    }

    public List<FilterEntityAttr> getFilters() {
        ArrayList<FilterEntityAttr> result = new ArrayList<FilterEntityAttr>();
        FilterEntityAttrAddress filter = this.addressFilter.getFilter();
        if (filter != null) {
            result.add((FilterEntityAttr)filter);
        }
        return result;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {});
        (AbstractBGUPanel)this.new AbstractBGUPanel.BGDefaultAction("clear", "X", e -> {
            this.mainFilter.clearFilter();
            this.addressFilter.clearFilter();
        });
        (AbstractBGUPanel)this.new AbstractBGUPanel.BGDefaultAction("find", "\u041d\u0430\u0439\u0442\u0438", e -> this.devicePanel.getActionMap().get("refresh").actionPerformed(e));
    }

    public void setDeviceGroupIds(Set<Integer> ids) {
        try {
            this.mainFilter.deviceGroup.setChecked(ids);
            this.mainFilter.deviceGroup.expand();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void jbInit() throws Exception {
        super.jbInit();
        this.addressFilter = new FilterEntityAttrAddressPanel(this.getEntitySpecAttrMap());
        this.tabbedPane.addTab("\u041e\u0431\u0449\u0435\u0435", this.mainFilter);
        this.tabbedPane.addTab("\u0410\u0434\u0440\u0435\u0441", this.addressFilter);
        this.tabbedPane.addChangeListener(e -> {
            Component component = this.tabbedPane.getSelectedComponent();
            if (component instanceof BGUPanel) {
                BGUPanel panel = (BGUPanel)component;
                panel.performAction("refresh");
            }
        });
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(10, 128), "find");
        inputMap.put(KeyStroke.getKeyStroke(8, 128), "clear");
    }

    class DeviceFilterMain
    extends BGUPanel {
        BGTextField host;
        BGTextField comment;
        BGTextField deviceId;
        BGTextField identifier;
        BGUComboBox<IdTitle> deviceType;
        BGUComboBox<IdTitle> deviceActive;
        BGUCheckTree<DeviceGroup> deviceGroup;

        public DeviceFilterMain() {
            super(new BorderLayout());
            this.host = new BGTextField();
            this.comment = new BGTextField();
            this.deviceId = new BGTextField();
            this.identifier = new BGTextField();
            this.deviceType = new BGUComboBox();
            this.deviceActive = new BGUComboBox();
            this.deviceGroup = new BGUCheckTree<DeviceGroup>(DeviceGroup.class);
        }

        @Override
        protected void jbInit() throws BGException {
            JPanel panel = new JPanel(new GridBagLayout());
            BGSwingUtilites.wrapEmptyBorder(panel);
            this.addFilter(panel, "ID:", this.deviceId);
            this.addFilter(panel, "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440:", this.identifier);
            this.addFilter(panel, "\u0425\u043e\u0441\u0442/\u043f\u043e\u0440\u0442:", this.host);
            this.addFilter(panel, "\u0422\u0438\u043f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430:", this.deviceType);
            this.addFilter(panel, "\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430:", this.deviceActive);
            panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u044b \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane(this.deviceGroup), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
            this.add((Component)panel, "Center");
            this.deviceActive.setData(Arrays.asList(new IdTitle(0, "\u041b\u044e\u0431\u043e\u0439"), new IdTitle(1, "\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0439"), new IdTitle(2, "\u041d\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439")));
            Async.of(() -> {
                ArrayList deviceTypeList = new ArrayList(((ClientContext)this.getContext()).getDirectory(DeviceFilter.this.devicePanel.getDeviceTypeClass()).list());
                int pos = 0;
                if (DeviceFilter.this.devicePanel.mode == 2) {
                    deviceTypeList.add(pos++, new IdTitle(-2, "\u041f\u043e \u0442\u0438\u043f\u0443 \u0441\u0435\u0440\u0432\u0438\u0441\u0430"));
                    deviceTypeList.add(pos++, new IdTitle(-100, "-----"));
                }
                deviceTypeList.add(pos++, new IdTitle(-100, "---"));
                deviceTypeList.add(pos++, new IdTitle(-1, "\u041f\u0430\u043f\u043a\u0430"));
                deviceTypeList.add(pos++, new IdTitle(-100, "-----"));
                return deviceTypeList;
            }).thenSwing(deviceTypeList -> this.deviceType.setData((List<IdTitle>)deviceTypeList));
            Async.of(() -> DeviceFilter.this.devicePanel.getWs().deviceGroupRoot()).thenSwing(a -> {
                this.deviceGroup.setData((DeviceGroup)a);
                this.deviceGroup.expand();
            });
        }

        private void addFilter(JPanel panel, String labelText, JComponent component) {
            if (component instanceof BGTextField) {
                ((BGTextField)component).setHorizontalAlignment(0);
            }
            panel.add((Component)new JLabel(labelText), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
            panel.add((Component)component, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        }

        public void clearFilter() {
            this.deviceId.setText("");
            this.identifier.setText("");
            this.host.setText("");
            this.comment.setText("");
            this.deviceType.setSelectedIndex(0);
            this.deviceActive.setSelectedIndex(0);
            this.deviceGroup.setChecked(Collections.emptySet());
            this.deviceGroup.expand();
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh(e -> {});
        }
    }
}

