/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mangooffice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoFee;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class MangoFeeDao
extends AbstractIdDao<MangoFee> {
    public MangoFeeDao(Connection con, int moduleId, Date date) {
        super(con, moduleId, "mango_fee", date);
    }

    public void checkAndCreateTable(Setup setup) {
        String createQuery = "CREATE TABLE " + this.tableName + " ( id INT UNSIGNED NOT NULL,control VARCHAR(20) NOT NULL,productId INT NOT NULL,serviceId INT NOT NULL,date DATETIME NOT NULL,sum DECIMAL(10,2) NOT NULL,day INT NOT NULL,UNIQUE KEY id (`id`),INDEX `control` (`control`),INDEX `day` (`day`) )";
        ServerUtils.checkAndCreatePeriodicTableName((Connection)this.con, (String)this.tableName, (String)createQuery);
    }

    public List<MangoFee> getListMangoFee(String control) throws BGException {
        if (ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return this.list("control=?", null, new Object[]{control});
        }
        return Collections.emptyList();
    }

    public int deleteByDay(int day) throws BGException {
        return this.delete("day=?", new Object[]{day});
    }

    public void insertList(List<MangoFee> list) throws BGException {
        if (list == null || list.size() == 0) {
            return;
        }
        for (MangoFee fee : list) {
            this.update(fee);
        }
    }

    public List<MangoFee> aggregatedByService() throws BGException {
        ArrayList<MangoFee> list = new ArrayList<MangoFee>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT control, serviceId, SUM(sum) as sum FROM " + this.tableName + " GROUP BY control, serviceId");){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                MangoFee agrFee = new MangoFee();
                agrFee.setControl(rs.getString("control"));
                agrFee.setServiceId(rs.getInt("serviceId"));
                agrFee.setSum(rs.getBigDecimal("sum"));
                list.add(agrFee);
            }
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    protected void updateImpl(MangoFee fee) throws BGException, SQLException {
        if (fee == null || fee.getId() < 1) {
            return;
        }
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET id=?, control=?, productId=?, serviceId=?, date=?, sum=?, day=?");){
            int index = 1;
            ps.setInt(index++, fee.getId());
            ps.setString(index++, fee.getControl());
            ps.setInt(index++, fee.getProductId());
            ps.setInt(index++, fee.getServiceId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)fee.getDate()));
            ps.setBigDecimal(index++, fee.getSum());
            ps.setInt(index++, fee.getDay());
            ps.executeUpdate();
        }
    }

    protected MangoFee getFromRS(ResultSet rs) throws SQLException, BGException {
        MangoFee fee = new MangoFee();
        fee.setId(rs.getInt("id"));
        fee.setControl(rs.getString("control"));
        fee.setProductId(rs.getInt("productId"));
        fee.setServiceId(rs.getInt("serviceId"));
        fee.setDate((Date)rs.getTimestamp("date"));
        fee.setSum(rs.getBigDecimal("sum"));
        fee.setDay(rs.getInt("day"));
        return fee;
    }
}

