/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductHistory;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductStatus;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;

public class MegafonContractProductHistoryDao
extends AbstractIdDao<MegafonContractProductHistory> {
    public MegafonContractProductHistoryDao(Connection con, int moduleId) {
        super(con, moduleId, "megafon_contract_product_history");
    }

    public Result<MegafonContractProductHistory> list(Page page, String filter, String orderBy, Object ... params) throws BGException {
        return super.list(page, filter, orderBy, params);
    }

    protected MegafonContractProductHistory getFromRS(ResultSet rs) throws SQLException, BGException {
        MegafonContractProductHistory productHistory = new MegafonContractProductHistory();
        productHistory.setId(rs.getInt("id"));
        productHistory.setProductId(rs.getInt("product_id"));
        productHistory.setContractId(rs.getInt("contract_id"));
        productHistory.setOldProductStatus(MegafonContractProductStatus.getStatusByCode((int)rs.getInt("old_product_status")));
        productHistory.setNewProductStatus(MegafonContractProductStatus.getStatusByCode((int)rs.getInt("new_product_status")));
        productHistory.setChangeDate(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("change_date")));
        productHistory.setUserId(rs.getInt("user_id"));
        productHistory.setMegafonOptionId(rs.getInt("megafon_option_id"));
        productHistory.setMsisdn(rs.getString("msisdn"));
        productHistory.setAdditionalMsisdn(rs.getString("additional_msisdn"));
        return productHistory;
    }

    protected void updateImpl(MegafonContractProductHistory productHistory) throws BGException, SQLException {
        boolean isUpdate;
        boolean bl = isUpdate = productHistory.getId() > 0;
        String query = isUpdate ? "UPDATE " : "INSERT INTO " + this.tableName + " SET product_id=?, contract_id=?, old_product_status=?, new_product_status=?, change_date=?, user_id=?, megafon_option_id=?, msisdn=?, additional_msisdn=?" + (isUpdate ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, productHistory.getProductId());
            ps.setInt(2, productHistory.getContractId());
            ps.setInt(3, productHistory.getOldProductStatus() != null ? productHistory.getOldProductStatus().ordinal() : -1);
            ps.setInt(4, productHistory.getNewProductStatus() != null ? productHistory.getNewProductStatus().ordinal() : -1);
            ps.setTimestamp(5, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)productHistory.getChangeDate()));
            ps.setInt(6, productHistory.getUserId());
            ps.setInt(7, productHistory.getMegafonOptionId());
            ps.setString(8, productHistory.getMsisdn());
            ps.setString(9, productHistory.getAdditionalMsisdn());
            if (isUpdate) {
                ps.setInt(10, productHistory.getId());
            }
            ps.executeUpdate();
        }
    }
}

