/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.task;

import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.List;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductStatus;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonProduct;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonContractService;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonService;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonKassaApiClient;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonContractProductDao;
import ru.bitel.common.Utils;

public class MegafonContractProductProlongateTask
extends TaskBase {
    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        try {
            ServerContext context = (ServerContext)ServerContext.get();
            this.activateProducts(context);
            this.prolongateProducts(context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void activateProducts(ServerContext context) throws Exception {
        this.getLogger().debug("\u041e\u0442\u043b\u043e\u0436\u0435\u043d\u043d\u0430\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 \u041c\u0435\u0433\u0430\u0444\u043e\u043d");
        MegafonContractService megafonContractService = (MegafonContractService)context.getService(MegafonContractService.class, this.getModuleId());
        for (MegafonContractProduct contractProduct : this.getProductForActivate(context.getConnection())) {
            try {
                this.getLogger().info(String.format("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u041c\u0435\u0433\u0430\u0444\u043e\u043d: cid=%s, productId=%s", contractProduct.getContractId(), contractProduct.getProductId()));
                megafonContractService.checkAllowActivateProduct(contractProduct);
                megafonContractService.productActivateRequest(contractProduct);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    private List<MegafonContractProduct> getProductForActivate(Connection connection) throws Exception {
        MegafonContractProductDao contractProductDao = new MegafonContractProductDao(connection, this.getModuleId());
        List forActivate = contractProductDao.list(null, "status=?", "", MegafonContractProductStatus.INACTIVE).getList();
        LocalDate now = LocalDate.now();
        forActivate.removeIf(p -> !p.getStartTime().toLocalDate().isEqual(now));
        this.getLogger().info("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 \u041c\u0435\u0433\u0430\u0444\u043e\u043d \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0430 \u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0447\u0438\u0441\u043b\u043e: " + forActivate.size());
        return forActivate;
    }

    private void prolongateProducts(ServerContext context) throws Exception {
        this.getLogger().debug("\u041f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 \u041c\u0435\u0433\u0430\u0444\u043e\u043d");
        MegafonService megafonService = (MegafonService)context.getService(MegafonService.class, this.moduleId);
        MegafonKassaApiClient kassaApiClient = new MegafonKassaApiClient(this.moduleId);
        for (MegafonContractProduct contractProduct : this.getProductForProlongate(context.getConnection())) {
            MegafonProduct product = megafonService.getProduct(contractProduct.getProductId());
            if (product == null) {
                this.getLogger().error("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 ID = " + contractProduct.getProductId());
                continue;
            }
            kassaApiClient.addPayment(contractProduct.getContractId(), Utils.isBlankString((String)contractProduct.getAdditionalMsisdn()) ? contractProduct.getMsisdn() : contractProduct.getAdditionalMsisdn(), new BigDecimal(product.getPrice()), "");
        }
    }

    private List<MegafonContractProduct> getProductForProlongate(Connection connection) throws Exception {
        MegafonContractProductDao contractProductDao = new MegafonContractProductDao(connection, this.getModuleId());
        List forProlongate = contractProductDao.list(null, "status=?", "", MegafonContractProductStatus.ACTIVE).getList();
        LocalDate now = LocalDate.now();
        forProlongate.removeIf(p -> p.getEndTime() == null || !p.getEndTime().toLocalDate().isEqual(now));
        this.getLogger().info("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 \u041c\u0435\u0433\u0430\u0444\u043e\u043d \u0434\u043b\u044f \u043f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u0438: " + forProlongate.size());
        return forProlongate;
    }

    public String getDescription() {
        return "\u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u0438 \u0438 \u043e\u0442\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0439 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432";
    }
}

