/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.service;

import jakarta.jws.WebService;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractCredentials;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubRequestLog;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscription;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscriptionStatusPeriod;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractTryAndBuy;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoSubscription;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoTryAndBuy;
import ru.bitel.bgbilling.modules.megogo.common.service.MegogoService;
import ru.bitel.bgbilling.modules.megogo.server.MegogoApi;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractCredentialsDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractSubRequestLogDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractSubscriptionDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractSubscriptionStatusPeriodDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractTryAndBuyDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoSubscriptionDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoTryAndBuyDao;
import ru.bitel.bgbilling.modules.megogo.server.event.MegogoCreateUserEvent;
import ru.bitel.bgbilling.modules.megogo.server.event.MegogoSubscriptionUpdateEvent;
import ru.bitel.bgbilling.modules.megogo.server.tasks.MegogoRecalculator;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.megogo.common.service.MegogoService")
public class MegogoServiceImpl
extends AbstractService
implements MegogoService {
    private MegogoContractSubscriptionDao contractSubDao;
    private MegogoSubscriptionDao subDao;
    private MegogoContractSubRequestLogDao logDao;
    private ContractDao contractDao;
    private MegogoTryAndBuyDao megogoTryAndBuyDao;
    private MegogoContractTryAndBuyDao contractTryAndBuyDao;
    private MegogoContractSubscriptionStatusPeriodDao statusPeriodDao;
    private MegogoContractCredentialsDao credentialsDao;

    private MegogoContractSubscriptionDao getContractSubDao() {
        if (this.contractSubDao == null) {
            this.contractSubDao = new MegogoContractSubscriptionDao(this.getConnection(), this.moduleId);
        }
        return this.contractSubDao;
    }

    private MegogoSubscriptionDao getSubscriptionDao() {
        if (this.subDao == null) {
            this.subDao = new MegogoSubscriptionDao(this.getConnection(), this.moduleId);
        }
        return this.subDao;
    }

    private ContractDao getContractDao() {
        if (this.contractDao == null) {
            this.contractDao = new ContractDao(this.getConnection(), this.userId);
        }
        return this.contractDao;
    }

    private MegogoContractSubRequestLogDao getLogDao() {
        if (this.logDao == null) {
            this.logDao = new MegogoContractSubRequestLogDao(this.getConnection(), this.moduleId);
        }
        return this.logDao;
    }

    private MegogoTryAndBuyDao getTryAndBuyDao() {
        if (this.megogoTryAndBuyDao == null) {
            this.megogoTryAndBuyDao = new MegogoTryAndBuyDao(this.getConnection(), this.moduleId);
        }
        return this.megogoTryAndBuyDao;
    }

    private MegogoContractTryAndBuyDao getContractTryAndBuyDao() {
        if (this.contractTryAndBuyDao == null) {
            this.contractTryAndBuyDao = new MegogoContractTryAndBuyDao(this.getConnection(), this.moduleId);
        }
        return this.contractTryAndBuyDao;
    }

    private MegogoContractSubscriptionStatusPeriodDao getStatusPeriodDao() {
        if (this.statusPeriodDao == null) {
            this.statusPeriodDao = new MegogoContractSubscriptionStatusPeriodDao(this.getConnection(), this.moduleId);
        }
        return this.statusPeriodDao;
    }

    private MegogoContractCredentialsDao getCredentialsDao() {
        if (this.credentialsDao == null) {
            this.credentialsDao = new MegogoContractCredentialsDao(this.getConnection(), this.moduleId);
        }
        return this.credentialsDao;
    }

    public int updateContractSubscription(MegogoContractSubscription contractSub, boolean sendToMegogo) throws BGException, BGMessageException {
        return this.updateContractSubscription(contractSub, sendToMegogo, null);
    }

    /*
     * Unable to fully structure code
     */
    private int updateContractSubscription(MegogoContractSubscription contractSub, boolean sendToMegogo, MegogoSubscription subscriptionTo) throws BGException {
        now = new Date();
        subscription = this.getSubscriptionDao().getByServiceId(contractSub.getServiceId());
        this.checkOnUpdate(contractSub);
        logId = -1;
        if (contractSub.getId() < 1) {
            if (TimeUtils.dateBefore((Date)contractSub.getPeriod().getDateFrom(), (Date)now)) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u043e\u0448\u043b\u043e\u043c!");
            }
            contractSub.setStatus(3);
            contractSub.setDateActivated(null);
            contractSub.setDateDeactivated(null);
            if (subscription.getType() == 1) {
                mainSids = Utils.toString(this.getSubscriptionDao().getMainSubscriptionsServiceIds());
                list = this.getContractSubDao().getContractsSubscriptionList("" + contractSub.getContractId(), mainSids, -1, contractSub.getPeriod().getDateFrom(), contractSub.getPeriod().getDateTo(), -1);
                for (MegogoContractSubscription sub : list) {
                    if (sub.getStatus() == 2) continue;
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0412\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442 \u043f\u0435\u0440\u0435\u0441\u0435\u0447\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u0432 \u043e\u0441\u043d\u043e\u0432\u043d\u044b\u0445 \u043d\u0435 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433/\u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a! \u041a\u043e\u0434 - " + sub.getId());
                }
            }
            if (!(event = (MegogoSubscriptionUpdateEvent)EventProcessor.getInstance().request((QueueEvent)new MegogoSubscriptionUpdateEvent(this.moduleId, contractSub, this.userId, sendToMegogo))).isProcessed()) {
                if (TimeUtils.dateBeforeOrEq((Date)contractSub.getPeriod().getDateFrom(), (Date)now) && sendToMegogo) {
                    logId = this.requesToMegogo(contractSub, subscription, 0);
                } else {
                    modeCreateUser = Utils.parseInt((String)this.getModuleSetup().get("user.create.mode", "1"), (int)1);
                    if (modeCreateUser == 2) {
                        credentialsDao = new MegogoContractCredentialsDao(this.getConnection(), this.moduleId);
                        try {
                            credentials = credentialsDao.getByContractId(contractSub.getContractId());
                            if (credentials != null) ** GOTO lbl55
                            credentials = new MegogoContractCredentials();
                            credentials.setContractId(contractSub.getContractId());
                            megogoCreateUserEvent = new MegogoCreateUserEvent(this.moduleId, contractSub.getContractId(), this.userId, credentials);
                            megogoCreateUserEvent = (MegogoCreateUserEvent)EventProcessor.getInstance().request((QueueEvent)megogoCreateUserEvent);
                            megogoApi = new MegogoApi(this.moduleId, this.userId, this.getConnection(), -1);
                            megogoApi.createUser(contractSub.getContractId(), credentials.getLogin(), credentials.getPwd());
                        }
                        finally {
                            credentialsDao.close();
                        }
                    }
                }
            }
        } else {
            old = (MegogoContractSubscription)this.getContractSubDao().get(contractSub.getId());
            contractSub.setContractId(old.getContractId());
            contractSub.setDateActivated(old.getDateActivated());
            contractSub.setDateDeactivated(old.getDateDeactivated());
            contractSub.setStatus(old.getStatus());
            if (old.getStatus() == 2 && !TimeUtils.dateEqual((Date)old.getPeriod().getDateFrom(), (Date)contractSub.getPeriod().getDateFrom())) {
                throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434 \u0443 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0439 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!");
            }
            if (TimeUtils.dateBeforeOrEq((Date)now, (Date)contractSub.getPeriod().getDateTo())) {
                contractSub.setStatus(1);
            } else if (contractSub.getPeriod().getDateTo() == null && old.getStatus() == 1) {
                contractSub.setStatus(0);
            }
            event = (MegogoSubscriptionUpdateEvent)EventProcessor.getInstance().request((QueueEvent)new MegogoSubscriptionUpdateEvent(this.moduleId, contractSub, this.userId, sendToMegogo, subscriptionTo));
            if (!event.isProcessed() && sendToMegogo && TimeUtils.dateBeforeOrEq((Date)contractSub.getPeriod().getDateTo(), (Date)now) && contractSub.getStatus() != 2) {
                this.requesToMegogo(contractSub, subscription, 2);
            }
        }
lbl55:
        // 7 sources

        contractSub.setUserId(this.userId);
        this.getContractSubDao().update(contractSub);
        if (logId > 0) {
            logDao = new MegogoContractSubRequestLogDao(this.getConnection(), this.moduleId);
            logDao.setContractSubscriptionId(logId, contractSub.getId());
            logDao.close();
        }
        return contractSub.getId();
    }

    private void checkOnUpdate(MegogoContractSubscription contractSubscription) throws BGException {
        Date now = new Date();
        if (contractSubscription.getPeriod() == null || contractSubscription.getPeriod().getDateFrom() == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!");
        }
        if (TimeUtils.dateBefore((Date)contractSubscription.getPeriod().getDateTo(), (Date)contractSubscription.getPeriod().getDateFrom())) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u043e\u0437\u0436\u0435 \u0434\u0430\u0442\u044b \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f!");
        }
        MegogoSubscription subscription = this.getSubscriptionDao().getByServiceId(contractSubscription.getServiceId());
        if (subscription == null || Utils.isBlankString((String)subscription.getKey())) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u0443\u0441\u043b\u0443\u0433\u0438!");
        }
        Contract contract = (Contract)this.getContractDao().get(contractSubscription.getContractId());
        if (contract == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
        }
        if (contract.getDateTo() != null && TimeUtils.dateBefore((Date)contract.getDateTo(), (Date)now)) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0437\u0430\u043a\u0440\u044b\u0442!");
        }
        List<MegogoContractSubscription> list = this.getContractSubDao().getContractSubscriptionList(contract.getId(), contractSubscription.getServiceId(), -1, contractSubscription.getPeriod(), contractSubscription.getId());
        if (list.size() > 0) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0412\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442 \u043f\u0435\u0440\u0435\u0441\u0435\u0447\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u0432 \u043e\u0434\u043d\u043e\u0439 \u0438 \u0442\u043e\u0439 \u0436\u0435 \u0443\u0441\u043b\u0443\u0433\u0438! \u041a\u043e\u0434 - " + list.get(0).getId());
        }
    }

    private int requesToMegogo(MegogoContractSubscription contractSubscription, MegogoSubscription subscription, int operation) throws BGException {
        MegogoApi megogoApi = new MegogoApi(this.moduleId, this.userId, this.getConnection(), contractSubscription.getId());
        MegogoContractSubRequestLog requestLog = null;
        if (operation == 0) {
            requestLog = megogoApi.subscribe(contractSubscription.getContractId(), subscription);
        } else if (operation == 2) {
            requestLog = megogoApi.unsubscribe(contractSubscription, subscription);
        } else if (operation == 4) {
            requestLog = megogoApi.suspend(contractSubscription.getContractId(), subscription);
        } else if (operation == 6) {
            requestLog = megogoApi.resume(contractSubscription.getContractId(), subscription);
        } else {
            return -1;
        }
        if (operation == 0) {
            contractSubscription.setDateActivated(new Date());
        } else if (operation == 2) {
            this.getContractSubDao().updateDateDeactivated(contractSubscription.getId(), new Date());
            contractSubscription.setDateDeactivated(new Date());
        }
        contractSubscription.setStatus(operation);
        return requestLog.getId();
    }

    public int deleteContractSubscription(int contractSubscriptionId) throws BGException, BGMessageException {
        MegogoContractSubscription subscription = (MegogoContractSubscription)this.getContractSubDao().get(contractSubscriptionId);
        if (subscription == null) {
            throw new BGMessageException("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0441 \u043a\u043e\u0434\u043e\u043c " + contractSubscriptionId + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
        }
        if (subscription.getStatus() == 3 && TimeUtils.dateBefore((Date)new Date(), (Date)subscription.getPeriod().getDateFrom()) && subscription.getDateActivated() == null) {
            return this.getContractSubDao().delete(contractSubscriptionId);
        }
        throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0435\u0449\u0435 \u043d\u0435 \u043d\u0430\u0441\u0442\u0443\u043f\u0438\u0432\u0448\u0438\u0445 \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a!");
    }

    public List<MegogoContractSubscription> contractSubscriptionList(int contractId, int serviceId, Date date) throws BGException, BGMessageException {
        return this.getContractSubDao().getContractSubscriptionList(contractId, serviceId, date);
    }

    public List<MegogoContractSubscription> getContractSubscriptionListByType(int contractId, int type, Period period) throws BGException {
        return this.getContractSubDao().getContractSubscriptionList(contractId, -1, type, period, -1);
    }

    public void subscribe(int contractId, int serviceId) throws BGException {
        List<MegogoContractSubscription> contractlistAll;
        List<MegogoContractSubscription> mainSubList;
        Contract contract = (Contract)this.getContractDao().get(contractId);
        try (BalanceUtils balanceUtils = new BalanceUtils(this.getConnection());){
            if (balanceUtils.getBalance(new Date(), contract).compareTo(contract.getBalanceLimit()) < 1) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u0430\u0442\u044c\u0441\u044f \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u0438 \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u043c \u0431\u0430\u043b\u0430\u043d\u0441\u0435!");
            }
        }
        Date from = new Date();
        int idFrom = -1;
        MegogoSubscription subscription = this.getSubscriptionByServiceId(serviceId);
        if (subscription.getType() == 1 && (mainSubList = this.getContractSubDao().getContractSubscriptionList(contractId, -1, 1, new Period(new Date(), null), -1)).size() > 0) {
            MegogoContractSubscription mainSub = mainSubList.get(0);
            if (mainSubList.size() > 1) {
                MegogoContractSubscription secondSub = mainSubList.get(1);
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0423 \u0432\u0430\u0441 \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0437\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u043d\u0430 \u0434\u0440\u0443\u0433\u0443\u044e \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443( \u2116 = " + secondSub.getId() + " )");
            }
            if (mainSub.getServiceId() == serviceId) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0423 \u0432\u0430\u0441 \u0438 \u0442\u0430\u043a \u0438\u043c\u0435\u0435\u0442\u0441\u044f \u0434\u0430\u043d\u043d\u0430\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430!");
            }
            int day = this.dayBetweenChangeSubscription(contractId, mainSub.getServiceId(), serviceId);
            Calendar to = Calendar.getInstance();
            to.add(6, day);
            mainSub.getPeriod().setDateTo(to.getTime());
            this.updateContractSubscription(mainSub, day != 0, subscription);
            to.add(6, 1);
            from = to.getTime();
            idFrom = mainSub.getId();
        }
        boolean firstConnection = (contractlistAll = this.contractSubscriptionList(contractId, -1, null)).size() == 0;
        MegogoContractSubscription service = new MegogoContractSubscription();
        service.setCount(1);
        service.setContractId(contractId);
        service.setServiceId(serviceId);
        service.setPeriod(new Period(from, null));
        service.setSubscriptionFrom(idFrom);
        this.updateContractSubscription(service, true);
        MapHolder<Integer, MegogoTryAndBuy> tryAndBuyMap = this.getTryAndBuyMap(true);
        MegogoTryAndBuy tAb = (MegogoTryAndBuy)tryAndBuyMap.getMap().get(subscription.getSid());
        if (tAb != null && (tAb.getType() != 1 || firstConnection)) {
            if (tAb.getType() == 2) {
                for (MegogoContractSubscription contractSubscription : contractlistAll) {
                    if (contractSubscription.getServiceId() != tAb.getSid()) continue;
                    break;
                }
            } else {
                Calendar to = TimeUtils.convertDateToCalendar((Date)from);
                to.add(5, Utils.parseInt((String)((String)tAb.getParams().get("countDay")), (int)30));
                MegogoContractTryAndBuy contractTryAndBuy = new MegogoContractTryAndBuy(contractId, tAb.getId(), service.getId(), new Period(from, to.getTime()), this.userId);
                this.getContractTryAndBuyDao().update(contractTryAndBuy);
            }
        }
    }

    public void unsubscribe(int contractSubscribeId) throws BGException {
        MegogoContractSubscription contractSub = (MegogoContractSubscription)this.getContractSubDao().get(contractSubscribeId);
        if (contractSub == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
        }
        int status = contractSub.getStatus();
        if (status != 0 && status != 4) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u0432 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u0435.");
        }
        ModuleSetup moduleSetup = this.getModuleSetup();
        MegogoSubscription subscription = this.getSubscriptionDao().getByServiceId(contractSub.getServiceId());
        int mode = Utils.parseInt((String)moduleSetup.get("service.unsubscribe.default.mode", "3"), (int)3);
        Calendar to = Calendar.getInstance();
        switch (mode) {
            case 1: {
                this.requesToMegogo(contractSub, subscription, 2);
                break;
            }
            case 2: {
                contractSub.setStatus(1);
                break;
            }
            default: {
                TimeUtils.moveToEndOfMonth((Calendar)to);
                contractSub.setStatus(1);
            }
        }
        contractSub.getPeriod().setDateTo(to.getTime());
        this.getContractSubDao().update(contractSub);
    }

    public void suspend(int contractSubscribeId) throws BGException {
        MegogoContractSubscriptionStatusPeriod statusPeriod;
        MegogoContractSubscription contractSub = (MegogoContractSubscription)this.getContractSubDao().get(contractSubscribeId);
        if (contractSub == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
        }
        int status = contractSub.getStatus();
        if (status != 0 && status != 1) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u0432 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u0435.");
        }
        MegogoSubscription subscription = this.getSubscriptionDao().getByServiceId(contractSub.getServiceId());
        this.requesToMegogo(contractSub, subscription, 4);
        contractSub.setUserId(this.userId);
        this.getContractSubDao().update(contractSub);
        List<MegogoContractSubscriptionStatusPeriod> list = this.getStatusPeriodDao().getList(contractSubscribeId, 4, false, TimeUtils.getPrevDay((Date)new Date()));
        if (list.size() > 0) {
            statusPeriod = list.get(0);
        } else {
            statusPeriod = new MegogoContractSubscriptionStatusPeriod();
            statusPeriod.setStatus(4);
            statusPeriod.setDateFrom(new Date());
            statusPeriod.setIdSub(contractSubscribeId);
        }
        statusPeriod.setDateTo(null);
        this.getStatusPeriodDao().update(statusPeriod);
    }

    public void resume(int contractSubscribeId) throws BGException {
        MegogoContractSubscription contractSub = (MegogoContractSubscription)this.getContractSubDao().get(contractSubscribeId);
        if (contractSub == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
        }
        int status = contractSub.getStatus();
        if (status != 4) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u0432 \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u0435.");
        }
        MegogoSubscription subscription = this.getSubscriptionDao().getByServiceId(contractSub.getServiceId());
        this.requesToMegogo(contractSub, subscription, 6);
        contractSub.setUserId(this.userId);
        contractSub.setStatus(0);
        this.getContractSubDao().update(contractSub);
        List<MegogoContractSubscriptionStatusPeriod> list = this.getStatusPeriodDao().getList(contractSubscribeId, 4, true, (Period)null);
        if (list.size() > 0) {
            MegogoContractSubscriptionStatusPeriod statusPeriod;
            if (list.size() > 1) {
                this.getLogger().error("ERROR. FOUND MORE THAN ONE SUSPEND STATUS PERIOD FOR SUBSCRIPTION id=" + contractSubscribeId);
            }
            if (TimeUtils.dateEqual((Date)(statusPeriod = list.get(0)).getDateFrom(), (Date)new Date())) {
                this.getStatusPeriodDao().delete(statusPeriod.getId());
            } else {
                statusPeriod.setDateTo(TimeUtils.getPrevDay((Date)new Date()));
                this.getStatusPeriodDao().update(statusPeriod);
            }
        } else {
            this.getLogger().error("ERROR. NOT FOUND SUSPEND STATUS PERIOD FOR SUBSCRIPTION id=" + contractSubscribeId);
        }
    }

    public void abortUnsubscribe(int contractSubscribeId) throws BGException {
        MegogoContractSubscription contractSub = (MegogoContractSubscription)this.getContractSubDao().get(contractSubscribeId);
        if (contractSub == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
        }
        if (contractSub.getStatus() != 1) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435 \u0432\u0435\u0440\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441!");
        }
        if (contractSub.getDateDeactivated() != null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u0423\u0436\u0435 \u0435\u0441\u0442\u044c \u0432\u0440\u0435\u043c\u044f \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438!");
        }
        MegogoContractSubscription to = this.getContractSubDao().getByFromId(contractSubscribeId);
        if (to != null) {
            if (to.getStatus() == 3) {
                this.getContractSubDao().delete(to.getId());
                this.getLogger().debug("Was deleted the megogo subscription on cid=" + contractSub.getContractId() + " sid=" + to.getServiceId());
            } else {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435 \u0432\u0435\u0440\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u0443 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u043f\u043b\u0430\u043d\u0438\u0440\u0443\u0435\u043c \u043f\u0435\u0440\u0435\u0445\u043e\u0434!");
            }
        }
        contractSub.getPeriod().setDateTo(null);
        contractSub.setStatus(0);
        this.getContractSubDao().update(contractSub);
    }

    public List<MegogoContractSubscriptionStatusPeriod> getContractSubscriptionStatusPeriodList(int idSub, int status, Period period) throws BGException {
        return this.getStatusPeriodDao().getList(idSub, status, false, period);
    }

    public int updateSubscription(MegogoSubscription subscription) throws BGException {
        subscription.setUserId(this.userId);
        this.getSubscriptionDao().update(subscription);
        return subscription.getId();
    }

    public List<MegogoSubscription> subscriptionList(Boolean used, int type) throws BGException {
        return this.getSubscriptionDao().getSubscriptionList(used, type);
    }

    public MegogoSubscription getSubscriptionByServiceId(int serviceId) throws BGException {
        return this.getSubscriptionDao().getByServiceId(serviceId);
    }

    public List<MegogoTryAndBuy> getTryAndBuyList(boolean onlyUsed) throws BGException {
        return this.getTryAndBuyDao().getTryAndBuyList(onlyUsed);
    }

    public MapHolder<Integer, MegogoTryAndBuy> getTryAndBuyMap(boolean onlyUsed) throws BGException {
        HashMap<Integer, MegogoTryAndBuy> tryAndBuyMap = new HashMap<Integer, MegogoTryAndBuy>();
        for (MegogoTryAndBuy tAb : this.getTryAndBuyList(onlyUsed)) {
            tryAndBuyMap.put(tAb.getSid(), tAb);
        }
        return new MapHolder(tryAndBuyMap);
    }

    public int updateTryAndBuy(MegogoTryAndBuy megogoTryAndBuy) throws BGException {
        this.getTryAndBuyDao().update(megogoTryAndBuy);
        return megogoTryAndBuy.getId();
    }

    public int deleteTryAndBuy(int id) throws BGException {
        return this.getTryAndBuyDao().delete(id);
    }

    public List<MegogoContractTryAndBuy> getContractTryAndBuyList(int contractId, Period period) throws BGException, BGMessageException {
        return this.getContractTryAndBuyDao().getContractTBList(contractId, null, -1);
    }

    public List<MegogoContractSubRequestLog> getContractRequestLog(int contractId) throws BGException {
        return this.getLogDao().getContractLogList(contractId);
    }

    public MegogoContractCredentials getContractCredentials(int contractId) throws BGException, BGMessageException {
        return this.getCredentialsDao().getByContractId(contractId);
    }

    public MegogoContractCredentials requestCredentials(int contractId, String login, String pwd) throws BGException {
        MegogoContractCredentials check;
        int uid = -1;
        MegogoApi megogoApi = new MegogoApi(this.moduleId, this.userId, this.getConnection());
        MegogoContractCredentials credentials = this.getCredentialsDao().getByContractId(contractId);
        if (credentials != null) {
            uid = credentials.getUid();
            MegogoContractCredentials credentialsNew = megogoApi.getMegogoUidAndLogin(contractId);
            if (credentialsNew == null) {
                throw new BGMessageException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043b\u043e\u0433\u0438\u043d \u0443 Megogo!");
            }
            login = credentialsNew.getLogin();
            uid = credentialsNew.getUid();
        } else if (Utils.notBlankString((String)login) && (check = this.getCredentialsDao().getByLogin(login)) != null) {
            throw new BGMessageException("\u0422\u0430\u043a\u043e\u0439 \u043b\u043e\u0433\u0438\u043d \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f. Cid = " + check.getContractId());
        }
        return megogoApi.requestCredentials(contractId, login, pwd, uid);
    }

    private int dayBetweenChangeSubscription(int contractId, int serviceIdFrom, int serviceIdTo) throws BGException {
        int result = 5;
        ModuleSetup moduleSetup = this.getModuleSetup();
        List list = moduleSetup.getIntegerList("service.main.cost.order", null);
        boolean moreExpensive = true;
        if (list != null) {
            int indexFrom = list.indexOf(serviceIdFrom);
            int indexTo = list.indexOf(serviceIdTo);
            if (indexTo != -1 && indexTo != -1) {
                moreExpensive = indexTo > indexFrom;
            }
        }
        Calendar now = Calendar.getInstance();
        String key = moreExpensive ? "expensive" : "cheap";
        int type = moduleSetup.getInt("service.main.migration." + key + ".type", moreExpensive ? 1 : 2);
        int value = moduleSetup.getInt("service.main.migration." + key + ".value", 1);
        switch (type) {
            case 1: {
                result = value > -1 ? value : TimeUtils.daysDelta((Calendar)now, (Calendar)TimeUtils.getEndMonth((Calendar)now));
                break;
            }
            case 2: {
                result = TimeUtils.daysDelta((Calendar)now, (Calendar)TimeUtils.getEndMonth((Calendar)now));
                break;
            }
            case 3: {
                result = -1;
                break;
            }
            default: {
                result = TimeUtils.daysDelta((Calendar)now, (Calendar)TimeUtils.getEndMonth((Calendar)now));
            }
        }
        return result;
    }

    public String getRedirectUrl(int contratId) throws BGException {
        MegogoApi megogoApi = new MegogoApi(this.moduleId, this.userId, this.getConnection());
        return megogoApi.getRedirectUrl(contratId);
    }

    public void recalculate(Date date, Set<Integer> contractSet) throws BGException {
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new MegogoRecalculator(this.moduleId, TimeUtils.convertDateToCalendar((Date)date), contractSet));
    }
}

