/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.notification.client.admin;

import bitel.billing.module.common.BGTextArea;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodWithTime;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGEditorDialogVPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.PeriodTableCellRenderer;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.plugins.notification.common.bean.NotificationData;
import ru.bitel.bgbilling.plugins.notification.common.bean.NotificationHandler;
import ru.bitel.bgbilling.plugins.notification.common.service.NotificationService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class NotificationTab
extends BGUPanel {
    private NotificationService notificationService;
    private NotificationTableModel tableModel = new NotificationTableModel();

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getNotificationTablePanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getNotificationTablePanel() {
        final BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && table.pointOnSelectRows(e.getPoint())) {
                    NotificationTab.this.performAction("edit");
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    private NotificationService getNotificationService() {
        if (this.notificationService == null) {
            this.notificationService = (NotificationService)((ClientContext)this.getContext()).getPort(NotificationService.class);
        }
        return this.notificationService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.tableModel.setData(this.getNotificationService().searchNotifications(0, null).getList())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new NotificationEditor("\u041d\u043e\u0432\u043e\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435", new NotificationData()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.showEditDialog(this.tableModel, NotificationEditor.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f"));
    }

    class NotificationTableModel
    extends BGTableModel<NotificationData> {
        public NotificationTableModel() {
            super(NotificationTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0422\u0435\u043c\u0430", 100, 200, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 300, 300, 300, "period", true, (TableCellRenderer)new PeriodTableCellRenderer());
            this.addColumn("\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430", 300, 300, 300, "handlerClassName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class NotificationEditor
    extends BGEditorDialog<NotificationData> {
        private JTabbedPane tabbedPane;
        private BGTextField subject;
        private BGControlPanelPeriodWithTime period;
        private BGTextArea answers;
        private DynamicClassChooser handlerClassName;

        public NotificationEditor(String title, NotificationData data) {
            super(title, (Object)data);
            this.tabbedPane = new JTabbedPane();
            this.subject = new BGTextField(50);
            this.period = new BGControlPanelPeriodWithTime();
            this.answers = new BGTextArea(5, 30);
            this.handlerClassName = new DynamicClassChooser(true);
        }

        public void doDialogPanel() {
            this.tabbedPane.add((Component)this.getBasePanel(), "\u041e\u0431\u0449\u0438\u0435");
            this.tabbedPane.add((Component)this.getTextPanel(), "\u0422\u0435\u043a\u0441\u0442");
            this.tabbedPane.add((Component)this.getAnswerPanel(), "\u041e\u0442\u0432\u0435\u0442");
            this.tabbedPane.add((Component)this.getClassPanel(), "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430");
            this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 10.0, 10, 1, new Insets(0, 0, 15, 0), 0, 0));
            this.subject.setText(((NotificationData)this.data).getTitle());
            this.period.setPeriod(((NotificationData)this.data).getPeriod());
        }

        private JPanel getBasePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new BGEditorDialogVPanel("\u0422\u0435\u043c\u0430", (Component)this.subject), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new BGEditorDialogVPanel("\u041f\u0435\u0440\u0438\u043e\u0434", (Component)this.period), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getTextPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            return panel;
        }

        private JPanel getAnswerPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0412\u0430\u0440\u0438\u0430\u043d\u0442\u044b \u043e\u0442\u0432\u0435\u0442\u043e\u0432 (\u043f\u043e \u043e\u0434\u043d\u043e\u043c\u0443 \u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0443)"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 2, 5), 0, 0));
            panel.add((Component)new JScrollPane((Component)this.answers), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getClassPanel() {
            this.handlerClassName.setIfaceName(NotificationHandler.class.getName());
            this.handlerClassName.performAction("refresh");
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new BGEditorDialogVPanel("\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430", (Component)this.handlerClassName), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        public boolean doApply() throws Exception {
            ((NotificationData)this.data).setTitle(this.subject.getText());
            ((NotificationData)this.data).setPeriod(this.period.getPeriod());
            ((NotificationService)((ClientContext)NotificationTab.this.getContext()).getWebService(NotificationService.class)).notificationDataUpdate((NotificationData)this.data);
            NotificationTab.this.performAction("refresh");
            return true;
        }
    }
}

