/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.organizer.server.action;

import bitel.billing.server.ActionBase;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.plugins.organizer.server.bean.JournalEntry;
import ru.bitel.bgbilling.plugins.organizer.server.bean.OrganizerManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ActionGetJournalList
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        Period period = this.getPeriod();
        if (period.getDateFrom() == null || period.getDateTo() == null) {
            throw new BGIllegalArgumentException();
        }
        int uid = this.getIntParameter("user", 0);
        Page page = this.getPage();
        OrganizerManager man = new OrganizerManager(this.con);
        List<JournalEntry> list = man.getJournalList(page, period, uid);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (JournalEntry entry : list) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(entry.getId()));
            row.setAttribute("rid", String.valueOf(entry.getRid()));
            row.setAttribute("who", entry.getName());
            row.setAttribute("message", entry.getMessage());
            row.setAttribute("date", TimeUtils.formatDate((Date)entry.getDate()));
        }
        page.setRecordCount(man.countJournalList(page, period, uid));
        this.setPageAttribute(table, page);
    }
}

