/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.organizer.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelButtonGroup;
import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.plugins.organizer.client.bean.RecordInfo;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class OrganizerRecordEditor
extends BGPanel {
    private String uid = "0";
    private String rid = "0";
    private String completeUid = "0";
    private BGTextField title = new BGTextField();
    private JTextArea comment = new JTextArea();
    private BGControlPanelContractSelect contract = new BGControlPanelContractSelect(false, true);
    private BGButtonPanelOkCancel control = new BGButtonPanelOkCancel();
    private BGComboBox<ComboBoxItem> usersCombo = new BGComboBox();
    private BGComboBox<ComboBoxItem> groupsCombo = new BGComboBox();
    private BGButton iamButton = new BGButton("\u041d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c \u0441\u0435\u0431\u0435");
    private BGControlPanelButtonGroup statusButtonGroup = new BGControlPanelButtonGroup();
    private BGControlPanelPeriod periodPanel = new BGControlPanelPeriod();
    private BGUPanel parentPanel;

    public OrganizerRecordEditor() {
        this.module = "ru.bitel.bgbilling.plugins.organizer";
        try {
            this.contract.init(this.module, this.getModuleId());
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        JPanel commentPanel = new JPanel(new GridBagLayout());
        JPanel titlePanel = new JPanel(new GridBagLayout());
        JPanel whoWhenPanel = new JPanel(new GridBagLayout());
        commentPanel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        JScrollPane scroll = new JScrollPane(this.comment);
        scroll.setVerticalScrollBarPolicy(22);
        commentPanel.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        titlePanel.setBorder((Border)new BGTitleBorder(" \u0422\u0435\u043c\u0430 "));
        titlePanel.add((Component)this.title, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel conPanel = new JPanel(new GridBagLayout());
        conPanel.setBorder((Border)new BGTitleBorder(" \u0414\u043e\u0433\u043e\u0432\u043e\u0440 "));
        conPanel.add((Component)this.contract, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel whoPanel = new JPanel(new GridBagLayout());
        whoPanel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u0443 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043e: "));
        whoPanel.add((Component)this.iamButton, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        whoPanel.add((Component)new JLabel("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        whoPanel.add((Component)this.usersCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        whoPanel.add((Component)new JLabel(" \u0438\u043b\u0438 \u0433\u0440\u0443\u043f\u043f\u0435: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        whoPanel.add((Component)this.groupsCombo, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        whoWhenPanel.add((Component)whoPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        whoWhenPanel.add((Component)this.periodPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel statusPanel = new JPanel(new GridBagLayout());
        statusPanel.setBorder((Border)new BGTitleBorder(" \u0421\u0442\u0430\u0442\u0443\u0441 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f "));
        statusPanel.add((Component)this.statusButtonGroup, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        whoWhenPanel.add((Component)statusPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.statusButtonGroup.addButton("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e", "done");
        this.statusButtonGroup.addButton("\u041d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e", "notdone");
        this.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.add(titlePanel, new GridBagConstraints(0, 0, 1, 1, 0.75, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(conPanel, new GridBagConstraints(1, 0, 1, 1, 0.15, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(commentPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(whoWhenPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.control, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 10, 10), 0, 0));
        this.usersCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OrganizerRecordEditor.this.usersCombo.getSelectedIndex() > 0) {
                    OrganizerRecordEditor.this.groupsCombo.setSelectedIndex(0);
                }
            }
        });
        this.groupsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OrganizerRecordEditor.this.groupsCombo.getSelectedIndex() > 0) {
                    OrganizerRecordEditor.this.usersCombo.setSelectedIndex(0);
                }
            }
        });
        this.iamButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrganizerRecordEditor.this.selectMe();
            }
        });
        this.control.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrganizerRecordEditor.this.performAction(e);
            }
        });
        this.init = false;
    }

    public void setData() {
        if (this.init) {
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetUsersAndGroups");
        this.setDocument(TransferManager.getDocument((Request)request));
    }

    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus((Document)doc)) {
            Node users = XMLUtils.selectNode((Node)doc, (String)"//users");
            this.usersCombo.setModel((ComboBoxModel)ClientUtils.buildComboBoxWithDefault((Node)users, null));
            Node groups = XMLUtils.selectNode((Node)doc, (String)"//groups");
            this.groupsCombo.setModel((ComboBoxModel)ClientUtils.buildComboBoxWithDefault((Node)groups, null));
            this.init = true;
        }
    }

    private void performAction(ActionEvent e) {
        if (e.getActionCommand().equals("ok")) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("UpdateOrganizerRecord");
            request.setAttribute("rid", this.rid);
            if (this.rid.equals("0")) {
                this.getUID();
                request.setAttribute("uid", this.uid);
                request.setAttribute("created", TimeUtils.formatDate((Date)new GregorianCalendar().getTime()));
                if (this.statusButtonGroup.getSelectedCommand().equals("done")) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043b\u044c\u0437\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u043e\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435!");
                    return;
                }
                request.setAttribute("journal", "created");
            }
            request.setAttribute("status", this.statusButtonGroup.getSelectedCommand());
            request.setAttribute("title", this.title.getText().trim());
            request.setAttribute("comment", this.comment.getText().trim());
            if (this.periodPanel.getDateString1().isEmpty() || this.periodPanel.getDateString2().isEmpty()) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f!");
                return;
            }
            if (this.periodPanel.getDateCalendar1().getTime().after(this.periodPanel.getDateCalendar2().getTime())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f!");
                return;
            }
            request.setPeriod(this.periodPanel.getPeriod());
            request.setAttribute("user_id", ((ComboBoxItem)this.usersCombo.getSelectedItem()).getObject().toString());
            request.setAttribute("group_id", ((ComboBoxItem)this.groupsCombo.getSelectedItem()).getObject().toString());
            List cids = Utils.toIntegerList((String)this.contract.getContracts());
            this.setContractId(cids.size() > 0 ? (Integer)cids.get(0) : -1);
            request.setContractId(this.getContractId());
            if (!this.rid.equals("0")) {
                if (this.statusButtonGroup.getSelectedCommand().equals("done")) {
                    if (this.completeUid.equals("0")) {
                        this.getUID();
                        request.setAttribute("complete_uid", this.uid);
                        request.setAttribute("complete_date", TimeUtils.formatDate((Date)new GregorianCalendar().getTime()));
                        request.setAttribute("journal", "marked_done");
                    } else {
                        request.setAttribute("journal", "marked_changed");
                    }
                } else if (!this.completeUid.equals("0")) {
                    request.setAttribute("journal", "marked_undone");
                } else {
                    request.setAttribute("journal", "marked_changed");
                }
            }
            if (ClientUtils.checkStatus((Document)TransferManager.getDocument((Request)request))) {
                this.parentPanel.performAction("refresh");
                this.setVisible(false);
            }
        } else {
            this.setVisible(false);
        }
    }

    private void getUID() {
        if (this.uid.equals("0")) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("GetMyUid");
            Document doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.uid = XMLUtils.selectElement((Node)doc, (String)"//user").getAttribute("id");
            }
        }
    }

    private void selectMe() {
        this.getUID();
        for (int i = 0; i < this.usersCombo.getItemCount(); ++i) {
            ComboBoxItem item = (ComboBoxItem)this.usersCombo.getItemAt(i);
            if (item == null || !this.uid.equals(item.getObject())) continue;
            this.usersCombo.setSelectedIndex(i);
            break;
        }
        this.groupsCombo.setSelectedIndex(0);
    }

    public void clear() {
        this.title.setText("");
        this.comment.setText("");
        try {
            this.usersCombo.setSelectedIndex(0);
            this.groupsCombo.setSelectedIndex(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.statusButtonGroup.setSelectedCommand("notdone");
        this.periodPanel.setDateString1("");
        this.periodPanel.setDateString2("");
        this.contract.setContracts(null, null);
    }

    public void initiate(RecordInfo info) {
        this.setData();
        String string = this.rid = info.getId().isEmpty() ? "0" : info.getId();
        if ("0".equals(this.rid)) {
            this.clear();
            return;
        }
        this.setContractId(info.getContractId());
        this.title.setText(info.getTitle());
        this.comment.setText(info.getComm());
        this.contract.setContracts(String.valueOf(this.getContractId()), info.getContractName());
        if (info.getUser() != null && !info.getUser().equals("")) {
            for (int i = 0; i < this.usersCombo.getItemCount(); ++i) {
                ComboBoxItem item = (ComboBoxItem)this.usersCombo.getItemAt(i);
                if (!info.getUser().equals(item.getObject())) continue;
                this.usersCombo.setSelectedIndex(i);
                break;
            }
            this.groupsCombo.setSelectedIndex(0);
        } else if (info.getGroup() != null && !info.getGroup().equals("")) {
            for (int i = 0; i < this.groupsCombo.getItemCount(); ++i) {
                ComboBoxItem item = (ComboBoxItem)this.groupsCombo.getItemAt(i);
                if (!info.getGroup().equals(item.getObject())) continue;
                this.groupsCombo.setSelectedIndex(i);
                break;
            }
            this.usersCombo.setSelectedIndex(0);
        }
        if (info.getPeriod() != null) {
            this.periodPanel.setDateCalendar1(info.getPeriod().getDateFromCalendar());
            this.periodPanel.setDateCalendar2(info.getPeriod().getDateToCalendar());
        }
        this.statusButtonGroup.setSelectedCommand(info.getStatus());
        this.completeUid = info.getUidCompleted().isEmpty() ? "0" : info.getUidCompleted();
    }

    public void setParent(BGUPanel organizerPanel) {
        this.parentPanel = organizerPanel;
    }

    public void setContractToField(int cid, String contractName) {
        this.contract.setContracts(String.valueOf(cid), contractName);
    }
}

