/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paymaster.server.action.apps;

import bitel.billing.server.contract.bean.ContractModuleManager;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.util.HashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.apps.server.bean.AppsAbstractAction;
import ru.bitel.bgbilling.kernel.container.service.server.ServiceFactory;
import ru.bitel.bgbilling.modules.paymaster.common.service.PayMasterService;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;

public class ActionDoPayment
extends AppsAbstractAction {
    public void execute() throws BGException {
        int moduleId = this.getIntParameter("module_id", -1);
        BigDecimal sum = this.getBigDecimal("amount", BigDecimal.ZERO).setScale(2, 6);
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        PayMasterService payMasterService = (PayMasterService)ServiceFactory.newService(PayMasterService.class, (int)moduleId);
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(moduleId)) {
            throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d. ");
        }
        BigDecimal sumMin = moduleSetup.getBigDecimal("paymaster.sum.min", new BigDecimal(100));
        BigDecimal sumMax = moduleSetup.getBigDecimal("paymaster.sum.max", new BigDecimal(5000));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430! ");
        }
        try {
            String successUrl = this.getParameter("urlSuccess");
            String failureUrl = this.getParameter("urlFailure");
            if (Utils.isBlankString((String)successUrl)) {
                successUrl = moduleSetup.get("paymaster.success.url", "http://successUrl");
            }
            if (Utils.isBlankString((String)failureUrl)) {
                failureUrl = moduleSetup.get("paymaster.failure.url", "http://failureUrl");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("successUrl", successUrl);
            map.put("failureUrl", failureUrl);
            Holder params = new Holder((Object)new MapHolder(map));
            Holder mode = new Holder();
            Holder redirectUrl = new Holder();
            payMasterService.beginTransaction(this.contractId, sum, redirectUrl, mode, params);
            if (redirectUrl != null) {
                this.actionMap.put("urlRedirect", redirectUrl.value);
                this.actionMap.put("urlSuccess", successUrl);
                this.actionMap.put("urlFailure", failureUrl);
            }
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }
}

