/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.inbuild;

import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_ContractBase
extends BGJasperReport {
    public static final String TABLE_DUMP = "report_contractbase_dumps";
    public static final String TABLE_DUMP_VALUES = "report_contractbase_dump_values";

    public Report_ContractBase() {
        this.id = "kernel_contract_contract_base";
    }

    @Override
    public void fillReportToStream(OutputStream out) throws BGException {
        try {
            BGReportFilter filter = this.createBGReportFilter();
            int dumpId = Utils.parseInt((String)filter.getStringParam("dump_id"));
            int FIO_PID = 0;
            int ADDRS_PID = 0;
            ArrayList<Integer> PHONE_PID = new ArrayList<Integer>();
            int DATE_PID = 0;
            ArrayList<String> phoneParamTable = new ArrayList<String>();
            ArrayList<String> phoneColumn = new ArrayList<String>();
            HashMap<Long, String> groups = new HashMap<Long, String>();
            String options = this.moduleSetup.get("report.contract_base.options", null);
            StringTokenizer st = new StringTokenizer(options, ";");
            while (st.hasMoreTokens()) {
                String[] key_value = st.nextToken().split(":");
                if (key_value[0].equals("addrs_pid")) {
                    ADDRS_PID = Utils.parseInt((String)key_value[1]);
                    continue;
                }
                if (key_value[0].equals("fio_pid")) {
                    FIO_PID = Utils.parseInt((String)key_value[1]);
                    continue;
                }
                if (key_value[0].startsWith("phone_pid")) {
                    if (key_value[0].endsWith("<phone>")) {
                        phoneParamTable.add("contract_parameter_type_phone");
                        phoneColumn.add("value");
                    } else {
                        phoneParamTable.add("contract_parameter_type_1");
                        phoneColumn.add("val");
                    }
                    PHONE_PID.add(Utils.parseInt((String)key_value[1]));
                    continue;
                }
                if (key_value[0].equals("date_pid")) {
                    DATE_PID = Utils.parseInt((String)key_value[1]);
                    continue;
                }
                if (!key_value[0].equals("groups")) continue;
                StringTokenizer stGroups = new StringTokenizer(key_value[1], ",");
                while (stGroups.hasMoreTokens()) {
                    String[] id_title = stGroups.nextToken().split("=>");
                    groups.put(1L << Utils.parseInt((String)id_title[0]), id_title[1]);
                }
            }
            StringBuilder phoneSelect = new StringBuilder(100);
            phoneSelect.append("concat( ''");
            for (int i = 0; i < phoneColumn.size(); ++i) {
                phoneSelect.append(", IF( ISNULL( ");
                phoneSelect.append("phone");
                phoneSelect.append(i);
                phoneSelect.append(".");
                phoneSelect.append((String)phoneColumn.get(i));
                phoneSelect.append(" ), '', ");
                phoneSelect.append("phone");
                phoneSelect.append(i);
                phoneSelect.append(".");
                phoneSelect.append((String)phoneColumn.get(i));
                phoneSelect.append(" ), ' '");
            }
            phoneSelect.append(" )");
            StringBuilder phoneJoins = new StringBuilder(100);
            for (int i = 0; i < phoneParamTable.size(); ++i) {
                phoneJoins.append("LEFT JOIN ");
                phoneJoins.append((String)phoneParamTable.get(i));
                phoneJoins.append(" AS phone");
                phoneJoins.append(i);
                phoneJoins.append(" ON contract.id=phone");
                phoneJoins.append(i);
                phoneJoins.append(".cid AND phone");
                phoneJoins.append(i);
                phoneJoins.append(".pid=? ");
            }
            StringBuilder query = new StringBuilder(200);
            query.append("SELECT contract.gr, contract.title, street.title, house.house, house.frac, addr.flat, addr.room, ");
            query.append(" fio.val, " + phoneSelect.toString() + ", date.val ");
            query.append(" FROM contract ");
            query.append(" LEFT JOIN contract_parameter_type_2 AS addr ON contract.id=addr.cid AND addr.pid=? ");
            query.append(" LEFT JOIN address_house AS house ON addr.hid=house.id");
            query.append(" LEFT JOIN address_street AS street ON house.streetid=street.id");
            query.append(" LEFT JOIN contract_parameter_type_1 AS fio ON contract.id=fio.cid AND fio.pid=? ");
            query.append(phoneJoins.toString());
            query.append(" LEFT JOIN contract_parameter_type_6 AS date ON contract.id=date.cid AND date.pid=? ");
            query.append(" INNER JOIN ");
            query.append(TABLE_DUMP_VALUES);
            query.append(" AS dv ON dv.cid=contract.id AND dv.dump_id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int i = 1;
            ps.setInt(i++, ADDRS_PID);
            ps.setInt(i++, FIO_PID);
            for (int j = 0; j < PHONE_PID.size(); ++j) {
                ps.setInt(i++, (Integer)PHONE_PID.get(j));
            }
            ps.setInt(i++, DATE_PID);
            ps.setInt(i++, dumpId);
            ResultSet rs = ps.executeQuery();
            BGDataSource bds = new BGDataSource();
            while (rs.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                int pos = 2;
                row.put("contract", rs.getString(pos++));
                row.put("street", rs.getString(pos++));
                row.put("house", rs.getString(pos++));
                row.put("frac", rs.getString(pos++));
                row.put("flat", rs.getString(pos++));
                row.put("room", rs.getString(pos++));
                row.put("fio", rs.getString(pos++));
                row.put("phone", rs.getString(pos++));
                String date = TimeUtils.formatDate((Date)rs.getDate(pos++));
                row.put("date", date);
                row.put("group", "");
                long group = rs.getLong(1);
                for (Map.Entry me : groups.entrySet()) {
                    if (((Long)me.getKey() & group) <= 0L) continue;
                    row.put("group", me.getValue());
                    break;
                }
                bds.addRow(row);
            }
            rs.close();
            ps.close();
            HashMap<String, Object> params = new HashMap<String, Object>();
            this.fillReportToStream(this.id, out, params, bds);
        }
        catch (Exception ex) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0442\u0447\u0451\u0442\u0430", (Throwable)ex);
        }
    }
}

