/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.modules.inet;

import bitel.billing.module.common.BGDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.oss.systems.inventory.resource.client.device.DevicePanel;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;

public class DeviceSelectDialog
extends BGDialog {
    private static DefaultListModel<BGUListItem> result;
    private static boolean voice;
    private static final String INET_MODULE_TITLE = "inet";
    private static final String VOICE_MODULE_TITLE = "voice";

    public DeviceSelectDialog(int mid) {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        Dimension dimension = new Dimension((int)(this.getToolkit().getScreenSize().getWidth() / 2.0), (int)(this.getToolkit().getScreenSize().getHeight() / 2.0));
        this.setSize(dimension);
        ClientContext context = voice ? new ClientContext(VOICE_MODULE_TITLE, mid, -1, "") : new ClientContext(INET_MODULE_TITLE, mid, -1, "");
        DeviceSelectPanel deviceSelectPanel = new DeviceSelectPanel(context);
        this.getContentPane().add((Component)((Object)deviceSelectPanel), "Center");
        this.pack();
        this.moveWindowToCenterScreen();
    }

    public static DefaultListModel<BGUListItem> showDeviceDialog(int inetMid) {
        DeviceSelectDialog dialog = new DeviceSelectDialog(inetMid);
        dialog.setVisible(true);
        return result;
    }

    public static DefaultListModel<BGUListItem> showDeviceDialog(int moduleId, boolean isVoice) {
        voice = isVoice;
        DeviceSelectDialog dialog = new DeviceSelectDialog(moduleId);
        dialog.setVisible(true);
        return result;
    }

    static {
        voice = false;
    }

    private class DeviceSelectPanel
    extends BGUPanel {
        private DevicePanel<? extends Device<?, ?>, DeviceType> devPanel;
        private AbstractBGUPanel.DefaultAction closeActionForEditor;
        private AbstractBGUPanel.DefaultAction okActionForEditor;

        public DeviceSelectPanel(ClientContext context) {
            super((LayoutManager)new BorderLayout(), context);
            this.closeActionForEditor = new AbstractBGUPanel.DefaultAction("close", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    result = new DefaultListModel();
                    DeviceSelectDialog.this.setVisible(false);
                    DeviceSelectDialog.this.dispose();
                }
            };
            this.okActionForEditor = new AbstractBGUPanel.DefaultAction("ok", "\u0412\u044b\u0431\u0440\u0430\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    result = new DefaultListModel();
                    List deviceList = DeviceSelectPanel.this.devPanel.getSelectedDevices();
                    this.extractDevices(deviceList);
                    DeviceSelectDialog.this.setVisible(false);
                    DeviceSelectDialog.this.dispose();
                }

                private void extractDevices(List<? extends Device<?, ?>> deviceList) {
                    for (Device<?, ?> device : deviceList) {
                        if (device.getDeviceTypeId() > 0) {
                            result.addElement(new BGUListItem(device.getId(), device.getTitle(), true));
                        }
                        if (!Utils.notEmptyCollection((Collection)device.getChildren())) continue;
                        this.extractDevices(device.getChildren());
                    }
                }
            };
        }

        protected void jbInit() throws Exception {
            String devicePanelClassName = voice ? "ru.bitel.bgbilling.modules.voice.client.device.VoiceDevicePanel" : "ru.bitel.bgbilling.modules.inet.client.InetDevicePanel";
            try {
                Class[] constructorSignature = new Class[]{ClientContext.class, Integer.TYPE, ActionListener.class};
                Class<?> clazz = Class.forName(devicePanelClassName);
                this.devPanel = (DevicePanel)clazz.getConstructor(constructorSignature).newInstance(this.getContext(), 2, null);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.devPanel.build();
            this.devPanel.getActionMap().put("close", (Action)this.closeActionForEditor);
            this.devPanel.getActionMap().put("ok", (Action)this.okActionForEditor);
            BGEditor editor = new BGEditor();
            editor.addForm(this.devPanel);
            this.add((Component)editor, "Center");
            this.devPanel.performAction("refresh");
        }
    }
}

