/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.shop.common.bean.ShopItemType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class ShopItemDao
extends AbstractIdDao<ShopItemType> {
    public ShopItemDao(Connection con) {
        super(con, 0, "shop_item_type");
    }

    public List<ShopItemType> list() throws BGException {
        return this.list("", "title", new Object[0]);
    }

    public List<ShopItemType> list(List<Integer> itemTypeIds) throws BGException {
        return this.list((String)(itemTypeIds == null || itemTypeIds.isEmpty() ? "" : "id IN ( " + Utils.toString(itemTypeIds) + " )"), "title", new Object[0]);
    }

    protected ShopItemType getFromRS(ResultSet rs) throws SQLException, BGException {
        ShopItemType shopItemType = new ShopItemType();
        shopItemType.setId(rs.getInt("id"));
        shopItemType.setTitle(rs.getString("title"));
        return shopItemType;
    }

    protected void updateImpl(ShopItemType shopItemType) throws BGException, SQLException {
        Objects.requireNonNull(shopItemType);
        boolean update = shopItemType.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, shopItemType.getTitle());
            if (update) {
                ps.setInt(index++, shopItemType.getId());
            }
            ps.executeUpdate();
            if (!update) {
                shopItemType.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }
}

