/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client.directory;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.shop.client.TitleLabel;
import ru.bitel.bgbilling.plugins.shop.common.bean.ShopItemType;
import ru.bitel.bgbilling.plugins.shop.common.service.ShopService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;

public class ShopItemTypesPanel
extends BGUPanel {
    private ShopItemType current = null;
    private JPanel editorPanel = null;
    private JTextField itemTypeTitle = new JTextField();
    private BGUList<ShopItemType> itemTypeList = new BGUList();
    private PropertyTableModel propertyTableModel = new PropertyTableModel();
    AbstractBGUPanel.DefaultAction addProperty = new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ShopItemTypesPanel.this.current.getProperties().add("{}");
            ShopItemTypesPanel.this.propertyTableModel.setData(ShopItemTypesPanel.this.current.getProperties());
        }
    };
    AbstractBGUPanel.DefaultAction editProperty = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
        }
    };
    AbstractBGUPanel.DefaultAction deleteProperty = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            int row = ShopItemTypesPanel.this.propertyTableModel.getSelectedRowIndex();
            if (row > -1) {
                ShopItemTypesPanel.this.current.getProperties().remove(row);
                ShopItemTypesPanel.this.propertyTableModel.setData(ShopItemTypesPanel.this.current.getProperties());
            }
        }
    };

    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)this.getListPanel(), (Component)this.getEditorPanel(), 400L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    private JPanel getListPanel() {
        this.itemTypeList.setCellRenderer((ListCellRenderer)new ShopItemTypeListCellRender());
        this.itemTypeList.setSelectionMode(0);
        this.itemTypeList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ShopItemTypesPanel.this.performAction("edit");
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0421\u043f\u0438\u0441\u043e\u043a:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.itemTypeList), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getEditorPanel() {
        this.editorPanel = new JPanel(new CardLayout());
        this.editorPanel.add((Component)new JPanel(), "empty");
        this.editorPanel.add((Component)this.getItemTypeEditorPanel(), "editor");
        return this.editorPanel;
    }

    private JPanel getItemTypeEditorPanel() {
        JLabel titleLabel = new JLabel("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0438\u043f\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430");
        titleLabel.setFont(titleLabel.getFont().deriveFont(1).deriveFont(titleLabel.getFont().getSize2D() * 1.5f));
        BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.SAVE, BGButtonPanel.CLOSE});
        buttonPanel.addActionListener(e -> {
            String actionCommand = e.getActionCommand();
            if (BGButtonPanel.SAVE.command.equals(actionCommand)) {
                this.current.setTitle(this.itemTypeTitle.getText());
                try {
                    ((ShopService)((ClientContext)this.getContext()).getWebService(ShopService.class)).shopItemTypeUpdate(this.current);
                    this.current = null;
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            } else if (BGButtonPanel.CLOSE.command.equals(actionCommand)) {
                this.current = null;
                this.itemTypeList.setEnabled(true);
                ((CardLayout)this.editorPanel.getLayout()).show(this.editorPanel, "empty");
                this.performAction("refresh");
            }
        });
        BGUTable propertyTable = new BGUTable((TableModel)((Object)this.propertyTableModel));
        propertyTable.setSelectionMode(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)titleLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        panel.add((Component)this.getTitlePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 0, 0), 0, 0));
        panel.add((Component)this.getPpopertyPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)propertyTable, (int)500, (int)400), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 0, 0), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 10), 0, 0));
        return panel;
    }

    private JPanel getTitlePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.itemTypeTitle, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getPpopertyPanel() {
        this.getActionMap().put("property.new", (Action)this.addProperty);
        this.getActionMap().put("property.edit", (Action)this.editProperty);
        this.getActionMap().put("property.delete", (Action)this.deleteProperty);
        BGDialogToolBar toolBar = new BGDialogToolBar();
        BGSwingUtilites.buildToolBar((BGDialogToolBar)toolBar, (JComponent)((Object)this), (String[])new String[]{"property.new", "property.edit", "property.delete"});
        toolBar.setFloatable(false);
        toolBar.compact();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new TitleLabel("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430:", 1, 1.25f), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)toolBar, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (!this.itemTypeList.isEnabled()) {
                return;
            }
            this.itemTypeList.setData(((ShopService)((ClientContext)this.getContext()).getPort(ShopService.class)).shopItemTypeList());
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            if (!this.itemTypeList.isEnabled()) {
                return;
            }
            this.current = new ShopItemType();
            this.itemTypeTitle.setText("");
            this.itemTypeList.setEnabled(false);
            ((CardLayout)this.editorPanel.getLayout()).show(this.editorPanel, "editor");
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            if (!this.itemTypeList.isEnabled()) {
                return;
            }
            this.current = (ShopItemType)this.itemTypeList.getSelectedValue();
            if (this.current == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430");
                return;
            }
            this.itemTypeTitle.setText(this.current.getTitle());
            this.itemTypeList.setEnabled(false);
            ((CardLayout)this.editorPanel.getLayout()).show(this.editorPanel, "editor");
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            if (!this.itemTypeList.isEnabled()) {
                return;
            }
        });
    }

    class PropertyTableModel
    extends BGTableModel<String> {
        public PropertyTableModel() {
            super(PropertyTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0418\u043c\u044f", 100, 200, 300, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 400, 500, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0438\u043f", 100, 200, 500, "type", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f", 100, 200, -1, "config", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class ShopItemTypeListCellRender
    extends DefaultListCellRenderer {
        ShopItemTypeListCellRender() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ShopItemType shopItemType = (ShopItemType)value;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            panel.add((Component)new JLabel(shopItemType.getTitle()), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 5, 2, 3), 0, 0));
            panel.add((Component)new JLabel("ID#" + shopItemType.getId()), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 3, 2, 5), 0, 0));
            return panel;
        }
    }
}

