/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.tv.access.manage;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.apps.tv.access.TvAccess;
import ru.bitel.bgbilling.apps.tv.access.om.AccessDeviceManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.common.bean.AlarmErrorMessage;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.kernel.event.PartitionedQueueEvent;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDevice;
import ru.bitel.bgbilling.modules.tv.common.event.access.manage.TvDeviceManageEvent;
import ru.bitel.bgbilling.modules.tv.server.bean.TvDeviceDao;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvDeviceRuntime;
import ru.bitel.common.Utils;
import ru.bitel.oss.systems.inventory.resource.common.dm.DeviceManager;

public class DeviceManageWorker
extends EventWorker {
    private static final Semaphore dbSemaphore = new Semaphore(8);
    private final ScheduledExecutorService scheduledExecutorService;
    private final TvAccess access;
    private final int deviceId;
    private final int invDeviceId;
    private long uptimePause;
    private long uptimeErrorPause;
    private boolean uptimeErrorAlarm;
    private int uptimeErrorCount;
    private final long fetchDelay;
    private TvDeviceRuntime deviceRuntime;
    private DeviceManager deviceManager;
    private volatile Future<?> future;
    private long lastUptime = 0L;
    private long lastCheckUptime = 0L;

    private static String destination(int invDeviceId) {
        return PartitionedQueueEvent.getDestinationMask(TvDeviceManageEvent.class, (int)invDeviceId);
    }

    public DeviceManageWorker(TvAccess access, AccessDeviceManager accessDeviceManager, ScheduledExecutorService scheduledExecutorService, int invDeviceId, int deviceId) throws BGException {
        super(EventProcessor.getInstance(), DeviceManageWorker.destination(invDeviceId), access.moduleId, -1, "deviceId=" + invDeviceId, true, new Class[]{TvDeviceManageEvent.class});
        this.scheduledExecutorService = scheduledExecutorService;
        this.access = access;
        this.invDeviceId = invDeviceId;
        this.deviceId = deviceId;
        TvDeviceRuntime deviceRuntime = access.deviceMap.get(deviceId);
        this.initParams(deviceRuntime);
        int size = Math.max(access.childrenDeviceIds.size() / 5, 1);
        long delay = size > 1 ? this.uptimePause / (long)size * (long)(deviceId % size + 1) : 0L;
        delay += (long)(deviceId % 10 * 100);
        this.fetchDelay = delay = Math.min(this.uptimePause, delay);
    }

    public void start() {
        this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), 3000L + this.fetchDelay, 500L, TimeUnit.MILLISECONDS);
    }

    protected synchronized void runImpl() throws Exception {
        int result = this.internalRunWorker(100L, false);
        if (result == 0 && this.uptimePause != 0L) {
            this.uptime();
        } else if (result < 0) {
            this.getLogger().info("Execution error - waiting " + this.errorPause + "ms for next try.");
            this.future.cancel(false);
            this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), this.errorPause, 500L, TimeUnit.MILLISECONDS);
        }
    }

    private void initParams(TvDeviceRuntime deviceRuntime) {
        this.errorPause = deviceRuntime.config.getLong("manage.error.pause.millis", deviceRuntime.config.getLong("manage.error.pause", TimeUnit.SECONDS.convert(5L, TimeUnit.SECONDS)) * 1000L);
        this.batchWait = deviceRuntime.config.getLong("manage.batch.wait.millis", deviceRuntime.config.getLong("manage.batch.wait", 5L) * 1000L);
        this.uptimePause = deviceRuntime.config.getLong("manage.uptime.pause.millis", deviceRuntime.config.getLong("manage.uptime.pause", 300L) * 1000L);
        this.uptimeErrorPause = deviceRuntime.config.getLong("manage.uptime.error.pause.millis", deviceRuntime.config.getLong("manage.uptime.error.pause", 60L) * 1000L);
        this.uptimeErrorAlarm = deviceRuntime.config.getInt("manage.uptime.error.alarm", 1) > 0;
    }

    /*
     * Loose catch block
     */
    protected boolean runWorker() throws BGException {
        this.deviceRuntime = this.access.deviceMap.get(this.deviceId);
        try {
            this.deviceManager = this.deviceRuntime.deviceManager;
            if (this.deviceManager == null) {
                this.doTasks();
                boolean bl = true;
                return bl;
            }
            this.initParams(this.deviceRuntime);
            try {
                try {
                    this.deviceManager.connect();
                }
                catch (Exception e) {
                    throw new BGException((Throwable)e);
                }
                boolean e = this.doTasks();
                return e;
            }
            catch (BGException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                throw e;
            }
            finally {
                try {
                    this.deviceManager.disconnect();
                }
                catch (Exception e) {
                    throw new BGException((Throwable)e);
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (this.deviceRuntime != null) {
                this.deviceRuntime = null;
            }
            this.deviceManager = null;
        }
    }

    public Object doTask(Object task) throws BGException {
        this.getLogger().info("Do task invDeviceId: " + this.invDeviceId + "; " + task);
        if (task instanceof TvDeviceManageEvent) {
            TvDeviceManageEvent e = (TvDeviceManageEvent)task;
            try {
                Object result = this.doCommand(e, e.getOperation());
                e.setResult(result);
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() instanceof BGException) {
                    throw (BGException)ex.getCause();
                }
                throw new BGException(ex.getCause());
            }
            catch (Throwable ex) {
                throw new BGException(ex);
            }
        } else {
            this.getLogger().error(task);
            return Boolean.TRUE;
        }
        return null;
    }

    private Object doCommand(TvDeviceManageEvent e, String operation) throws Throwable {
        Object result = true;
        this.getLogger().info("Processing invDeviceId:" + this.invDeviceId + "; command " + operation);
        if (operation.startsWith("__skipSaEvent")) {
            if (operation.length() > "__skipSaEvent".length()) {
                // empty if block
            }
        } else {
            Method method = null;
            if (this.deviceRuntime.deviceManagerInfo != null) {
                try {
                    method = this.deviceRuntime.deviceManagerInfo.getMethod(operation);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (method != null) {
                result = method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(TvDeviceManageEvent.class) ? method.invoke((Object)this.deviceManager, e) : method.invoke((Object)this.deviceManager, new Object[0]);
            } else {
                switch (operation) {
                    case "onReboot": 
                    case "onDeviceSyncFinish": {
                        this.getLogger().info("Method " + operation + " for deviceId=" + this.deviceId + " not found.");
                        break;
                    }
                    default: {
                        this.getLogger().error("Method " + operation + " for deviceId=" + this.deviceId + " not found!");
                        AlarmSender.sendAlarm((String)"inet.manage.methodNotFound", (long)60000L, (String)("\u041c\u0435\u0442\u043e\u0434 \"" + operation + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"), (String)("\u041c\u0435\u0442\u043e\u0434 \"" + operation + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043b\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0441 ID=" + this.deviceId));
                    }
                }
            }
        }
        this.getLogger().info("Process operation[" + operation + "] result=" + result);
        return result;
    }

    private void uptime() {
        TvDeviceRuntime deviceRuntime = null;
        try {
            long millis = System.currentTimeMillis();
            if (this.uptimeErrorCount > 0 ? millis <= this.lastCheckUptime + this.uptimeErrorPause : millis <= this.lastUptime + this.uptimePause) {
                return;
            }
            deviceRuntime = this.access.deviceMap.get(this.deviceId);
            if (deviceRuntime == null || deviceRuntime.deviceManager == null) {
                return;
            }
            this.uptime(deviceRuntime, millis);
            this.uptimeErrorCount = 0;
        }
        catch (Exception ex) {
            if (ex.getMessage() != null && ex.getMessage().contains("Timed out")) {
                this.getLogger().error("Check uptime error for device: " + this.deviceId + ": " + ex.getMessage() + ". Waiting " + this.uptimeErrorPause + " ms for next try.");
            } else {
                this.getLogger().error("Check uptime error for device: " + this.deviceId + ": " + ex.getMessage() + ". Waiting " + this.uptimeErrorPause + " ms for next try.", (Throwable)ex);
            }
            this.future.cancel(false);
            this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), this.errorPause, 500L, TimeUnit.MILLISECONDS);
            ++this.uptimeErrorCount;
            try {
                if (this.uptimeErrorAlarm && this.uptimeErrorCount >= 3) {
                    long interval;
                    String key = "inet.manage.uptime.error";
                    long time = System.currentTimeMillis();
                    long l = interval = this.uptimeErrorCount > 10 ? 3600000L : 600000L;
                    if (AlarmSender.needAlarmSend((String)"inet.manage.uptime.error", (long)time, (long)interval)) {
                        String message;
                        String subject;
                        if (deviceRuntime != null) {
                            subject = "Inet: \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f uptime \u0434\u043b\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 [" + this.deviceId + "] " + deviceRuntime.tvDevice;
                            message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f uptime \u0434\u043b\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 [" + this.deviceId + "] " + deviceRuntime.tvDevice + "\n" + deviceRuntime.tvDevice.getHost() + "\n(" + deviceRuntime.tvDevice.getComment() + ")\n\n" + ex.getMessage();
                        } else {
                            subject = "Inet: \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f uptime \u0434\u043b\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 [" + this.deviceId + "]";
                            message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f uptime \u0434\u043b\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 [" + this.deviceId + "]\n\n" + ex.getMessage();
                        }
                        AlarmSender.sendAlarm((AlarmErrorMessage)new AlarmErrorMessage("inet.manage.uptime.error", subject, message), (long)time);
                    }
                }
            }
            catch (Exception ex2) {
                this.getLogger().error(ex2.getMessage(), (Throwable)ex2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uptime(TvDeviceRuntime deviceRuntime, long millis) throws Exception {
        this.lastCheckUptime = millis;
        Date uptimeTime = deviceRuntime.tvDevice.getUptimeTime();
        if (uptimeTime == null || uptimeTime.getTime() + this.uptimePause < millis) {
            this.getLogger().debug("Check uptime for device:" + this.deviceId);
            TvDeviceRuntime tvDeviceRuntime = deviceRuntime;
            synchronized (tvDeviceRuntime) {
                boolean disconnected = false;
                deviceRuntime.deviceManager.connect();
                try {
                    Object uptimeObj = deviceRuntime.deviceManager.uptime();
                    disconnected = true;
                    deviceRuntime.deviceManager.disconnect();
                    this.getLogger().debug("Returned: " + uptimeObj);
                    if (uptimeObj == null) {
                        this.lastUptime = millis + 600000L;
                        return;
                    }
                    Map<String, Long> uptimeMap = DeviceManageWorker.unpack(deviceRuntime.tvDevice, uptimeObj);
                    Map<String, Long> oldUptimeMap = DeviceManageWorker.unpack(deviceRuntime.tvDevice, Utils.maskBlank((String)deviceRuntime.tvDevice.getUptime(), (String)"0"));
                    for (Map.Entry<String, Long> e : uptimeMap.entrySet()) {
                        long oldMillis;
                        Long uptime = e.getValue();
                        Long oldUptime = oldUptimeMap.get(e.getKey());
                        if (oldUptime == null) {
                            oldUptime = oldUptimeMap.get("");
                        }
                        long l = oldMillis = uptimeTime != null ? uptimeTime.getTime() : 0L;
                        if ((uptime >= oldUptime || millis <= oldMillis) && millis - oldMillis <= uptime * 1000L) continue;
                        this.getLogger().info("Hardware reboot detected");
                        EventProcessor.getInstance().publish((Event)new TvDeviceManageEvent(this.access.moduleId, 0, this.invDeviceId, "onReboot", 0, 0));
                        break;
                    }
                    this.lastUptime = millis;
                    String newUptime = DeviceManageWorker.pack(uptimeMap);
                    Date newUptimeTime = new Date(millis);
                    dbSemaphore.acquire();
                    try (TvDeviceDao deviceDao = new TvDeviceDao(((EventListenerContext)this.context).getConnection(), this.access.moduleId);){
                        deviceDao.updateUptime(this.invDeviceId, newUptime, newUptimeTime);
                        ((EventListenerContext)this.context).commit();
                        ((EventListenerContext)this.context).recycle();
                    }
                    finally {
                        dbSemaphore.release();
                    }
                    deviceRuntime.tvDevice.setUptime(newUptime);
                    deviceRuntime.tvDevice.setUptimeTime(newUptimeTime);
                }
                finally {
                    if (!disconnected) {
                        deviceRuntime.deviceManager.disconnect();
                    }
                }
            }
        }
        this.lastUptime = uptimeTime.getTime();
    }

    private static Map<String, Long> unpack(TvDevice device, Object uptime) {
        HashMap<String, Long> result;
        if (uptime instanceof Integer) {
            uptime = ((Integer)uptime).longValue();
        }
        if (uptime instanceof Long) {
            result = new HashMap();
            List hosts = device.getHostsAsString();
            if (hosts.size() == 0) {
                result.put("", (Long)uptime);
            } else {
                for (String[] host : hosts) {
                    result.put(host[0], (Long)uptime);
                }
            }
        } else {
            result = DeviceManageWorker.unpack0((String)uptime);
        }
        return result;
    }

    private static Map<String, Long> unpack0(String data) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        StringTokenizer st = new StringTokenizer(data, ";");
        while (st.hasMoreTokens()) {
            String[] pair = st.nextToken().split(":");
            if (pair.length == 2) {
                result.put(pair[0], Utils.parseLong((String)pair[1]));
                continue;
            }
            result.put("", Utils.parseLong((String)pair[0]));
        }
        return result;
    }

    private static String pack(Map<String, Long> data) {
        StringBuilder result = new StringBuilder();
        if (data.size() == 1) {
            for (Long uptime : data.values()) {
                result.append(String.valueOf(uptime));
            }
            return result.toString();
        }
        long current = Long.MIN_VALUE;
        for (Map.Entry<String, Long> entry : data.entrySet()) {
            if (current == Long.MIN_VALUE) {
                current = entry.getValue();
                continue;
            }
            if (current == entry.getValue()) continue;
            current = Long.MIN_VALUE;
            break;
        }
        if (current == Long.MIN_VALUE) {
            for (Long l : data.values()) {
                result.append(String.valueOf(l));
            }
            return result.toString();
        }
        for (Map.Entry entry : data.entrySet()) {
            if (result.length() != 0) {
                result.append(";");
            }
            result.append((String)entry.getKey());
            result.append(":");
            result.append(entry.getValue());
        }
        return result.toString();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "@" + System.identityHashCode((Object)this);
    }
}

