/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.service;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccountSpec;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDevice;
import ru.bitel.bgbilling.modules.tv.common.event.TvAccountModifiedEvent;
import ru.bitel.bgbilling.modules.tv.common.event.TvAccountModifyEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.om.OmTvAccountModifyEvent;
import ru.bitel.bgbilling.modules.tv.common.service.TvAccountService;
import ru.bitel.bgbilling.modules.tv.server.bean.TvAccountDao;
import ru.bitel.bgbilling.modules.tv.server.bean.TvAccountGenerate;
import ru.bitel.bgbilling.modules.tv.server.bean.TvDeviceDao;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.PatternStringGenerator;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Node;
import ru.bitel.common.worker.Commitable;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.tv.common.service.TvAccountService")
public class TvAccountServiceImpl
extends AbstractService
implements TvAccountService {
    private Directory<TvAccountSpec> tvAccountSpecDirectory = null;

    private Directory<TvAccountSpec> getTvAccountSpecDirectory() throws BGException {
        if (this.tvAccountSpecDirectory == null) {
            this.tvAccountSpecDirectory = this.context.getDirectory(TvAccountSpec.class, this.moduleId);
        }
        return this.tvAccountSpecDirectory;
    }

    @PostConstruct
    protected void init() {
    }

    public String tvProductStatus(int contractId, int tvAccountId) throws BGException {
        ProductService productService = (ProductService)this.context.getService(ProductService.class, 0);
        List productList = productService.productList(this.moduleId, contractId, tvAccountId, false, null, null, new Date(), null, false, false);
        int enabled = 0;
        int disabled = 0;
        for (Product product : productList) {
            if (product.getDeviceState() == 1) {
                ++enabled;
                continue;
            }
            ++disabled;
        }
        return enabled + "/" + disabled;
    }

    public TvAccount tvAccountTree(int contractId) throws BGException {
        try (TvAccountDao tvAccountDao = new TvAccountDao(this.getConnection(), this.moduleId);){
            List<TvAccount> result = tvAccountDao.list(contractId);
            TvAccount root = new TvAccount();
            root.setTitle("\u0410\u043a\u043a\u0430\u0443\u043d\u0442\u044b");
            TvAccount tvAccount = (TvAccount)TreeUtils.tree(result, (Node)root);
            return tvAccount;
        }
    }

    public List<TvAccountSpec> tvAccountSpecList() throws BGException {
        return this.getTvAccountSpecDirectory().list();
    }

    public List<IdTitle> tvAccountSpecTitleList() throws BGException {
        return this.getTvAccountSpecDirectory().list().stream().map(IdTitle::toIdTitle).toList();
    }

    public TvAccount tvAccountGet(int contractId, int id) throws BGException {
        try (TvAccountDao tvAccountDao = new TvAccountDao(this.getConnection(), this.moduleId);){
            TvAccount result = (TvAccount)tvAccountDao.get(id);
            if (result != null && contractId > 0 && contractId != result.getContractId()) {
                throw new BGIllegalArgumentException("contractId");
            }
            TvAccount tvAccount = result;
            return tvAccount;
        }
    }

    public List<TvAccount> tvAccountList(int deviceId, String login, Date dateFrom, Date dateTo) throws BGException {
        try (TvAccountDao tvAccountDao = new TvAccountDao(this.getConnection(), this.moduleId);){
            List<TvAccount> list = tvAccountDao.list(deviceId, login, dateFrom, dateTo);
            return list;
        }
    }

    public List<TvAccount> tvAccounContracttList(int contractId) throws BGException, BGMessageException {
        try (TvAccountDao tvAccountDao = new TvAccountDao(this.getConnection(), this.moduleId);){
            List<TvAccount> list = tvAccountDao.list(contractId, false);
            return list;
        }
    }

    public TvAccount tvAccountGetByLogin(String login, Date time) throws BGException {
        try (TvAccountDao tvAccountDao = new TvAccountDao(this.getConnection(), this.moduleId);){
            TvAccount tvAccount = tvAccountDao.get(login, time);
            return tvAccount;
        }
    }

    public void tvAccountDelete(int contractId, int id, boolean force) throws BGException {
        try (TvAccountDao tvAccountDao = new TvAccountDao(this.getConnection(), this.moduleId);){
            TvAccount oldTvAccount = (TvAccount)tvAccountDao.get(id);
            if (oldTvAccount == null) {
                throw new BGException("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 ID=" + id + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
            }
            if (contractId != oldTvAccount.getContractId()) {
                throw new BGIllegalArgumentException("contractId");
            }
            if (!force) {
                this.tvAccountIsActive(oldTvAccount);
            }
            if (contractId > 0 && oldTvAccount.getContractId() != contractId) {
                throw new BGIllegalArgumentException("contractId");
            }
            List<TvAccount> childrenAccountList = tvAccountDao.listChildren(id);
            if (oldTvAccount.getParentId() <= 0) {
                ProductService productService = (ProductService)this.context.getService(ProductService.class, 0);
                List productList = productService.productList(-1, contractId, id, true, null, null, null, null, true, false);
                for (Product product : productList) {
                    productService.productDelete(contractId, product.getId());
                }
            }
            if (childrenAccountList.size() > 0) {
                oldTvAccount.setChildren(childrenAccountList);
                for (TvAccount childAccount : childrenAccountList) {
                    tvAccountDao.delete(childAccount.getId());
                    this.context.publishAfterCommit((Event)new TvAccountModifiedEvent(this.moduleId, oldTvAccount.getContractId(), this.userId, childAccount, null));
                }
            }
            tvAccountDao.delete(id);
            if (oldTvAccount.getParentId() != 0 || oldTvAccount.getDeviceState() != -1) {
                this.publishEvent(oldTvAccount, null, (short)-1, 0L);
            }
            this.context.publishAfterCommit((Event)new TvAccountModifiedEvent(this.moduleId, oldTvAccount.getContractId(), this.userId, oldTvAccount, null));
        }
    }

    private String tvAccountUpdateGeneratePassword(int contractId, TvAccount tvAccount, ParameterMap config) throws BGException {
        String pswd = null;
        String accountPasswordClass = config.get("account.password.class");
        if (accountPasswordClass != null) {
            try {
                pswd = DynamicClassManager.getInstance().loadClass(accountPasswordClass).asSubclass(TvAccountGenerate.class).getConstructor(new Class[0]).newInstance(new Object[0]).generatePassword(contractId, tvAccount, config);
            }
            catch (Exception e) {
                this.getLogger().error((Object)e);
                return null;
            }
        }
        if (pswd == null) {
            int length = config.getInt("account.password.length.auto", 6);
            String passwordChars = config.get("account.password.chars.auto", config.get("account.password.chars", "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"));
            pswd = PswdGen.generatePassword((int)length, (String)passwordChars);
        }
        return pswd;
    }

    private short getNewDeviceState(TvAccount tvAccount) throws BGException {
        short newDeviceState;
        Date now = new Date();
        if (!TimeUtils.dateInRange((Date)now, (Date)tvAccount.getDateFrom(), (Date)tvAccount.getDateTo())) {
            newDeviceState = -1;
        } else if (tvAccount.getStatus() != 0) {
            newDeviceState = 0;
        } else {
            try (ContractManager contractManager = new ContractManager(this.getConnection());){
                StatusCache statusCache = StatusCache.getInstance();
                Contract contract = contractManager.getContractById(tvAccount.getContractId());
                newDeviceState = !statusCache.isModuleActiveStatus(this.moduleId, contract.getStatus()) ? (short)0 : 1;
            }
        }
        return newDeviceState;
    }

    private String tvAccountUpdateGenerateLogin(int contractId, TvAccount tvAccount, ParameterMap config) throws Exception {
        String login = null;
        String accountLoginClass = config.get("account.login.class");
        if (accountLoginClass != null) {
            try {
                login = DynamicClassManager.getInstance().loadClass(accountLoginClass).asSubclass(TvAccountGenerate.class).getConstructor(new Class[0]).newInstance(new Object[0]).generateLogin(contractId, tvAccount, config);
            }
            catch (Exception e) {
                this.getLogger().error((Object)e);
                return null;
            }
        }
        if (login == null) {
            int min = config.getInt("account.login.min", 1);
            int max = config.getInt("account.login.max", 9999999);
            String format = config.get("account.login.format", null);
            try (TvAccountDao tvAccountDao = new TvAccountDao(this.getConnection(), this.moduleId);){
                int loginValue = Math.max(tvAccountDao.lastNumericLogin(max) + 1, min);
                login = Utils.isBlankString((String)format) ? String.valueOf(loginValue) : new DecimalFormat(format).format(loginValue);
            }
        } else {
            String chars = config.get("account.login.chars", "01234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
            if (!PswdGen.checkChars(login, (String)chars)) {
                throw new BGMessageException("\u041b\u043e\u0433\u0438\u043d \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0438\u0437 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432: " + chars);
            }
        }
        return login;
    }

    public int tvAccountUpdate(int contractId, TvAccount tvAccount, boolean generateLogin, boolean generatePassword, long omWaitTimeout) throws BGException {
        Preferences tvAccountSpecConfig;
        int constDeviceId;
        this.checkAccountCondition(tvAccount, contractId);
        TvAccountSpec tvAccountSpec = (TvAccountSpec)this.getTvAccountSpecDirectory().get(tvAccount.getSpecId());
        if (tvAccountSpec.isNeedLogin()) {
            try {
                this.generateLogin(tvAccount, contractId, tvAccountSpec, generateLogin);
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        tvAccount.setTitle(tvAccount.getLogin());
        if (tvAccountSpec.isNeedPassword()) {
            this.generatePassword(tvAccount, contractId, tvAccountSpec, generatePassword);
        }
        if ((constDeviceId = (tvAccountSpecConfig = new Preferences(tvAccountSpec.getConfig(), "\n\r")).getInt("const.device.id", -1)) > 0) {
            tvAccount.setDeviceId(constDeviceId);
        }
        if (tvAccount.getTitle() == null) {
            tvAccount.setTitle("");
        }
        try (TvAccountDao tvAccountDao = new TvAccountDao(this.getConnection(), this.moduleId);){
            TvAccount oldAccount = (TvAccount)tvAccountDao.getAndUpdate((Id)tvAccount);
            if (oldAccount != null && contractId > 0 && oldAccount.getContractId() != contractId) {
                throw new BGIllegalArgumentException("contractId");
            }
            TvAccountModifyEvent modifyEvent = new TvAccountModifyEvent(this.moduleId, this.userId, oldAccount, tvAccount);
            tvAccount = ((TvAccountModifyEvent)EventProcessor.getInstance().request((QueueEvent)modifyEvent)).getNewTvAccount();
            tvAccount.setTitle("");
            this.generateAccountTitleByPattern(tvAccount, tvAccountSpecConfig);
            tvAccountDao.update(tvAccount);
            short newDeviceState = this.getNewDeviceState(tvAccount);
            if (oldAccount != null && oldAccount.getParentId() <= 0 && oldAccount.getDeviceId() != tvAccount.getDeviceId()) {
                this.publishEvent(oldAccount, null, (short)-1, 0L);
                this.publishEvent(null, tvAccount, newDeviceState, 0L);
            } else {
                this.publishEvent(oldAccount, tvAccount, newDeviceState, 0L);
            }
            this.context.publishAfterCommit((Event)new TvAccountModifiedEvent(this.moduleId, tvAccount.getContractId(), this.userId, oldAccount, tvAccount));
            int n = tvAccount.getId();
            return n;
        }
    }

    private void checkAccountCondition(TvAccount tvAccount, int contractId) throws BGIllegalArgumentException {
        if (tvAccount == null) {
            throw new BGIllegalArgumentException("tvAccount");
        }
        if (tvAccount.getContractId() <= 0) {
            throw new BGIllegalArgumentException("tvAccount.contractId");
        }
        if (tvAccount.getSpecId() <= 0) {
            throw new BGIllegalArgumentException("tvAccount.specId");
        }
        if (contractId > 0 && tvAccount.getContractId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
    }

    private void generateLogin(TvAccount tvAccount, int contractId, TvAccountSpec tvAccountSpec, boolean generateLogin) throws Exception {
        String login;
        if (generateLogin) {
            ParameterMap config = this.getModuleSetup().inherit((ParameterMap)new Preferences(tvAccountSpec.getConfig(), "\n"));
            tvAccount.setLogin(this.tvAccountUpdateGenerateLogin(contractId, tvAccount, config));
        }
        if (Utils.isBlankString((String)(login = tvAccount.getLogin()))) {
            throw new BGMessageException("\u041b\u043e\u0433\u0438\u043d \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.", "tvAccount.login.empty");
        }
        try (TvAccountDao tvAccountDao = new TvAccountDao(this.getConnection(), this.moduleId);){
            List<TvAccount> list = tvAccountDao.list(-1, login, null, null);
            for (TvAccount s : list) {
                if (s.getId() == tvAccount.getId() || s.getDeviceState() == -1 && !TimeUtils.checkDateIntervalsIntersection((Date)tvAccount.getDateFrom(), (Date)tvAccount.getDateTo(), (Date)s.getDateFrom(), (Date)s.getDateTo())) continue;
                throw new BGMessageException("\u041b\u043e\u0433\u0438\u043d " + login + " \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f.");
            }
        }
    }

    private void generatePassword(TvAccount tvAccount, int contractId, TvAccountSpec tvAccountSpec, boolean generatePassword) throws BGException {
        ModuleSetup config = this.getModuleSetup();
        if (tvAccountSpec != null) {
            config = config.inherit((ParameterMap)new Preferences(tvAccountSpec.getConfig(), "\n"));
        }
        if (generatePassword) {
            tvAccount.setPassword(this.tvAccountUpdateGeneratePassword(contractId, tvAccount, (ParameterMap)config));
        } else {
            String password = Utils.maskNull((String)tvAccount.getPassword());
            int minLength = config.getInt("account.password.length.min", 0);
            int maxLength = config.getInt("account.password.length.max", 8);
            String passwordChars = config.get("account.password.chars", "01234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
            String passwordCharsDescription = config.get("serv.password.chars.description", null);
            if (password.length() < minLength) {
                throw new BGMessageException("\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f " + minLength + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.");
            }
            if (password.length() > maxLength) {
                throw new BGMessageException("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f " + maxLength + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.");
            }
            if (!PswdGen.checkChars((String)password, (String)passwordChars)) {
                if (Utils.notBlankString((String)passwordCharsDescription)) {
                    throw new BGMessageException(passwordCharsDescription);
                }
                throw new BGMessageException("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0438\u0437 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 " + passwordChars + ".");
            }
        }
    }

    private void generateAccountTitleByPattern(TvAccount tvAccount, Preferences tvAccountSpecConfig) throws BGException {
        TvDevice device;
        try (TvDeviceDao tvDeviceDao = new TvDeviceDao(this.getConnection(), this.moduleId);){
            device = (TvDevice)tvDeviceDao.get(tvAccount.getDeviceId());
        }
        if (device == null) {
            throw new BGMessageException("\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e!");
        }
        String titlePattern = tvAccountSpecConfig.get("title.pattern", "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 title.pattern \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0442\u0438\u043f\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u0430!");
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"deviceIdentifier", (String)device.getIdentifier());
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"deviceTitle", (String)device.getTitle());
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"login", (String)tvAccount.getLogin());
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"id", (String)String.valueOf(tvAccount.getId()));
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"identifier", (String)tvAccount.getIdentifier());
        StringBuilder macString = new StringBuilder();
        if (tvAccount.getMacAddressList() != null && tvAccount.getMacAddressList().size() > 0) {
            for (byte[] mac : tvAccount.getMacAddressList()) {
                macString.append(Utils.bytesToString((byte[])mac, (boolean)true, null));
                macString.append(", ");
            }
            macString.setLength(macString.length() - 2);
        }
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"macAddress", (String)macString.toString());
        tvAccount.setTitle(titlePattern);
    }

    private void publishEvent(TvAccount oldTvAccount, TvAccount newTvAccount, short newDeviceState, final long timeout) throws BGException {
        final EventProcessor ep = EventProcessor.getInstance();
        int tvAccountId = oldTvAccount != null ? oldTvAccount.getId() : newTvAccount.getId();
        int parentTvAccountId = oldTvAccount != null ? oldTvAccount.getParentId() : newTvAccount.getParentId();
        try (TvAccountDao tvAccountDao = new TvAccountDao(this.getConnection(), this.moduleId);){
            if (parentTvAccountId > 0) {
                TvAccount oldParentTvAccount = (TvAccount)tvAccountDao.get(parentTvAccountId);
                TvAccount newParentTvAccount = oldParentTvAccount.clone();
                List<TvAccount> newChildrenTvAccounts = tvAccountDao.listChildren(oldParentTvAccount.getId());
                ArrayList<TvAccount> oldChildrenTvAccounts = new ArrayList<TvAccount>(newChildrenTvAccounts);
                if (oldTvAccount != null && newTvAccount == null) {
                    oldChildrenTvAccounts.add(oldTvAccount);
                } else {
                    int size = oldChildrenTvAccounts.size();
                    for (int i = 0; i < size; ++i) {
                        if (((TvAccount)oldChildrenTvAccounts.get(i)).getId() != tvAccountId) continue;
                        if (oldTvAccount == null) {
                            oldChildrenTvAccounts.remove(i);
                            break;
                        }
                        oldChildrenTvAccounts.set(i, oldTvAccount);
                        break;
                    }
                }
                oldParentTvAccount.setChildren(oldChildrenTvAccounts);
                newParentTvAccount.setChildren(newChildrenTvAccounts);
                newDeviceState = (short)(newParentTvAccount != null ? (int)this.getNewDeviceState(newParentTvAccount) : -1);
                if (newParentTvAccount != null && newDeviceState == -1) {
                    newParentTvAccount = null;
                }
                if (oldParentTvAccount != null && oldParentTvAccount.getDeviceState() == -1 && newParentTvAccount != null) {
                    oldParentTvAccount = null;
                }
                OmTvAccountModifyEvent e = new OmTvAccountModifyEvent(this.moduleId, 0, oldParentTvAccount, newParentTvAccount, newDeviceState);
                if (timeout > 0L) {
                    e = (OmTvAccountModifyEvent)ep.request((Event)e, timeout);
                } else {
                    ep.publish((Event)e);
                }
            } else {
                if (newTvAccount != null && newDeviceState == -1) {
                    newTvAccount = null;
                }
                if (oldTvAccount != null && oldTvAccount.getDeviceState() == -1 && newTvAccount != null) {
                    oldTvAccount = null;
                }
                List<TvAccount> childrenServs = tvAccountDao.listChildren(tvAccountId);
                if (oldTvAccount != null && oldTvAccount.getChildren() == null) {
                    oldTvAccount.setChildren(childrenServs);
                }
                if (newTvAccount != null) {
                    if (newTvAccount.getChildren() == null) {
                        newTvAccount.setChildren(childrenServs);
                    }
                } else {
                    newDeviceState = (short)-1;
                }
                final OmTvAccountModifyEvent e = new OmTvAccountModifyEvent(this.moduleId, 0, oldTvAccount, newTvAccount, newDeviceState);
                if (timeout > 0L) {
                    this.context.addCommitable(new Commitable(){

                        public void commit() throws Exception {
                            ep.request((Event)e, timeout);
                        }
                    });
                } else {
                    this.context.publishAfterCommit((Event)e);
                }
            }
        }
    }

    public TvAccountSpec tvAccountSpecGet(int tvAccountSpecId) throws BGException {
        System.out.println(this.getTvAccountSpecDirectory().get(tvAccountSpecId));
        System.out.println(this.getTvAccountSpecDirectory().get(tvAccountSpecId));
        return (TvAccountSpec)this.getTvAccountSpecDirectory().get(tvAccountSpecId);
    }

    public int tvAccountSpecUpdate(TvAccountSpec tvAccountSpec) throws BGException {
        this.getTvAccountSpecDirectory().update((Id)tvAccountSpec);
        return tvAccountSpec.getId();
    }

    public void tvAccountSpecDelete(int id) throws BGException {
        this.getTvAccountSpecDirectory().delete(id);
    }

    public void tvAccountIsActive(TvAccount tvAccount) throws BGException {
        boolean deviceStateDeleted;
        boolean bl = deviceStateDeleted = tvAccount.getParentId() == 0 && tvAccount.getDeviceState() == -1;
        if (!deviceStateDeleted && TimeUtils.dateInRange((Date)new Date(), (Date)tvAccount.getDateFrom(), (Date)tvAccount.getDateTo())) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u043c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f.");
        }
        if (tvAccount.getParentId() == 0) {
            try (TvAccountDao tvAccountDao = new TvAccountDao(this.getConnection(), this.moduleId);){
                List<TvAccount> childrenServs = tvAccountDao.listChildren(tvAccount.getId());
                for (TvAccount child : childrenServs) {
                    if (deviceStateDeleted || !TimeUtils.dateInRange((Date)new Date(), (Date)child.getDateFrom(), (Date)child.getDateTo())) continue;
                    throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u043c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0432 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0445 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430\u0445.");
                }
                ProductService productService = (ProductService)this.context.getService(ProductService.class, 0);
                List productList = productService.productList(0, tvAccount.getContractId(), tvAccount.getId(), true, null, null, new Date(), null, false, false);
                if (productList.size() > 0) {
                    throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430\u043c\u0438.");
                }
            }
        }
    }

    public List<TvAccount> tvAccountSearch(List<KeyValue> filter, int tvAccountSpecId, boolean strict) throws BGException {
        try (TvAccountDao tvAccountDao = new TvAccountDao(this.getConnection(), this.moduleId);){
            List<TvAccount> list = tvAccountDao.search(filter, tvAccountSpecId, strict);
            return list;
        }
    }
}

