/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client.tariff;

import bitel.billing.module.common.FloatTextField;
import bitel.billing.module.tariff.directory.DirectoriesManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.directory.tariff.common.TariffDirectory;
import ru.bitel.bgbilling.kernel.tariff.client.tree.MultiSelectTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.bgbilling.modules.tv.client.tariff.ProductTariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;

public class ActivationModeTariffTreeNode
extends MultiSelectTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"fugue/price-tag");
    private FloatTextField cost = new FloatTextField();

    protected String getDirName() {
        return "activationMode";
    }

    protected boolean needMode() {
        return false;
    }

    protected boolean canEmpty() {
        return true;
    }

    protected String getViewLabel() {
        return "\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f: ";
    }

    protected String getViewLabel(Map<String, String> data) {
        return "\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0437\u0430 " + data.get("cost") + ": ";
    }

    protected String getStoreKey() {
        return "activationModeIds";
    }

    protected Icon getIcon() {
        return icon;
    }

    protected void buildDirectoryCombo(Directory dir, JComboBox<IdTitle> combo) {
        TariffTreeNode parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof ProductTariffTreeNode); parent = parent.getParent()) {
        }
        if (parent == null) {
            for (IdTitle idTitle : dir.getItems()) {
                combo.addItem(idTitle);
            }
            return;
        }
        ProductTariffTreeNode productTariffTreeNode = (ProductTariffTreeNode)parent;
        List<Integer> productSpecIds = productTariffTreeNode.getProductSpecIds();
        Directory productSpecDir = this.getDirManager().getDirectory("productSpec");
        if (productSpecDir instanceof DirectoriesManager.LazyDirectory) {
            productSpecDir = ((DirectoriesManager.LazyDirectory)productSpecDir).getDirectory();
        }
        TariffDirectory productSpecDirectory = (TariffDirectory)productSpecDir;
        for (Integer productSpecId : productSpecIds) {
            ProductSpec productSpec = (ProductSpec)productSpecDirectory.get(productSpecId.intValue());
            if (productSpec == null) continue;
            for (ProductSpecActivationMode activationMode : productSpec.getActivationModeList()) {
                combo.addItem(new IdTitle(activationMode.getId(), productSpec.getTitle() + ": " + activationMode.getTitle()));
            }
        }
    }

    protected String getValue(int activationModeId) {
        try {
            TariffTreeNode parent;
            for (parent = this.getParent(); parent != null && !(parent instanceof ProductTariffTreeNode); parent = parent.getParent()) {
            }
            if (parent == null) {
                return super.getValue(activationModeId);
            }
            ProductTariffTreeNode productTariffTreeNode = (ProductTariffTreeNode)parent;
            List<Integer> productSpecIds = productTariffTreeNode.getProductSpecIds();
            Directory productSpecDir = this.getDirManager().getDirectory("productSpec");
            if (productSpecDir instanceof DirectoriesManager.LazyDirectory) {
                productSpecDir = ((DirectoriesManager.LazyDirectory)productSpecDir).getDirectory();
            }
            TariffDirectory productSpecDirectory = (TariffDirectory)productSpecDir;
            for (Integer productSpecId : productSpecIds) {
                ProductSpec productSpec = (ProductSpec)productSpecDirectory.get(productSpecId.intValue());
                if (productSpec == null) continue;
                for (ProductSpecActivationMode activationMode : productSpec.getActivationModeList()) {
                    if (activationMode.getId() != activationModeId) continue;
                    return super.getValue(activationModeId);
                }
            }
            return "<font color=\"#dd0000\">" + super.getValue(activationModeId) + "</font>";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    protected JPanel getBottomPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.cost, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    protected void loadDataImpl(Map<String, String> data) {
        this.cost.setText(Utils.maskNull((String)data.get("cost")));
    }

    protected void setDataImpl(Map<String, String> data) {
        data.put("cost", this.cost.getText().trim());
    }
}

